/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Service
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(Service.class);
    private volatile boolean keepRunning;
    private long shutdownTimeout = 3000L;
    private final String name;
    private final ExecutorService executorService;
    private Future<?> thread;
    private Throwable serviceExitedWithException;
    private CountDownLatch startupLatch = new CountDownLatch(1);

    public Service(String name, ExecutorService executorService) {
        this.name = name;
        this.executorService = executorService;
    }

    public boolean isRunning() {
        return this.keepRunning;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setShutdownTimeout(long shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public void start() {
        if (this.keepRunning) {
            throw new IllegalStateException("Service is already running");
        }
        log.debug("Starting service {}", (Object)this.name);
        this.keepRunning = true;
        ExecutorService service = this.getExecutorService();
        if (service.isShutdown()) {
            throw new IllegalStateException("ExecutorService is shut down");
        }
        this.thread = service.submit(this);
    }

    public void startAndWait() throws InterruptedException {
        this.start();
        this.startupLatch.await();
    }

    protected void afterStartup() {
    }

    protected abstract void handle();

    public void stop() {
        if (this.isRunning()) {
            this.prepareTermination();
        }
    }

    public void waitForTermination() {
        if (!this.thread.isDone()) {
            try {
                this.thread.get(this.shutdownTimeout, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException ee) {
            }
            catch (TimeoutException te) {
                log.warn("Thread did not stop after {} milliseconds. Now cancelling.", (Object)this.shutdownTimeout);
                this.thread.cancel(true);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public final void stopAndWait() {
        this.stop();
        this.waitForTermination();
    }

    protected void afterTermination() {
    }

    protected void prepareTermination() {
        log.debug("Prepare to stop thread {}", (Object)this.name);
        this.keepRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        try {
            this.afterStartup();
            log.debug("Thread {} entering main loop", (Object)this.name);
            while (this.isRunning()) {
                this.handle();
                this.startupLatch.countDown();
            }
            log.debug("Thread {} leaving main loop", (Object)this.name);
        }
        catch (RuntimeException t) {
            this.serviceExitedWithException = t.getCause() != null ? t.getCause() : t;
            log.warn("Thread exiting main loop due to exception:", (Throwable)t);
        }
        catch (Throwable t) {
            this.serviceExitedWithException = t;
            log.warn("Thread exiting main loop due to exception:", t);
        }
        finally {
            this.startupLatch.countDown();
            this.afterTermination();
        }
    }

    protected void setServiceExitedWithException(Throwable theThreadExitedWithException) {
        this.serviceExitedWithException = theThreadExitedWithException;
    }

    public Throwable getServiceExitedWithException() {
        return this.serviceExitedWithException;
    }
}

