/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.IS;
import ca.uhn.hl7v2.model.v25.datatype.TS;

public class ICD
extends AbstractComposite {
    private Type[] data;

    public ICD(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[3];
        this.data[0] = new IS(this.getMessage(), 150);
        this.data[1] = new ID(this.getMessage(), 136);
        this.data[2] = new TS(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public IS getCertificationPatientType() {
        return (IS)this.getTyped(0, IS.class);
    }

    public IS getIcd1_CertificationPatientType() {
        return (IS)this.getTyped(0, IS.class);
    }

    public ID getCertificationRequired() {
        return (ID)this.getTyped(1, ID.class);
    }

    public ID getIcd2_CertificationRequired() {
        return (ID)this.getTyped(1, ID.class);
    }

    public TS getDateTimeCertificationRequired() {
        return (TS)this.getTyped(2, TS.class);
    }

    public TS getIcd3_DateTimeCertificationRequired() {
        return (TS)this.getTyped(2, TS.class);
    }
}

