/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.BRT_O32_TIMING;
import ca.uhn.hl7v2.model.v25.segment.BPO;
import ca.uhn.hl7v2.model.v25.segment.BTX;
import ca.uhn.hl7v2.model.v25.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BRT_O32_ORDER
extends AbstractGroup {
    public BRT_O32_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(BRT_O32_TIMING.class, false, true, false);
            this.add(BPO.class, false, false, false);
            this.add(BTX.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating BRT_O32_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public BRT_O32_TIMING getTIMING() {
        BRT_O32_TIMING retVal = (BRT_O32_TIMING)this.getTyped("TIMING", BRT_O32_TIMING.class);
        return retVal;
    }

    public BRT_O32_TIMING getTIMING(int rep) {
        BRT_O32_TIMING retVal = (BRT_O32_TIMING)this.getTyped("TIMING", rep, BRT_O32_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<BRT_O32_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", BRT_O32_TIMING.class);
    }

    public void insertTIMING(BRT_O32_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public BRT_O32_TIMING insertTIMING(int rep) throws HL7Exception {
        return (BRT_O32_TIMING)super.insertRepetition("TIMING", rep);
    }

    public BRT_O32_TIMING removeTIMING(int rep) throws HL7Exception {
        return (BRT_O32_TIMING)super.removeRepetition("TIMING", rep);
    }

    public BPO getBPO() {
        BPO retVal = (BPO)this.getTyped("BPO", BPO.class);
        return retVal;
    }

    public BTX getBTX() {
        BTX retVal = (BTX)this.getTyped("BTX", BTX.class);
        return retVal;
    }

    public BTX getBTX(int rep) {
        BTX retVal = (BTX)this.getTyped("BTX", rep, BTX.class);
        return retVal;
    }

    public int getBTXReps() {
        return this.getReps("BTX");
    }

    public List<BTX> getBTXAll() throws HL7Exception {
        return this.getAllAsList("BTX", BTX.class);
    }

    public void insertBTX(BTX structure, int rep) throws HL7Exception {
        super.insertRepetition("BTX", (Structure)structure, rep);
    }

    public BTX insertBTX(int rep) throws HL7Exception {
        return (BTX)super.insertRepetition("BTX", rep);
    }

    public BTX removeBTX(int rep) throws HL7Exception {
        return (BTX)super.removeRepetition("BTX", rep);
    }
}

