/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.undertow;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.component.undertow.UndertowComponent;
import org.apache.camel.component.undertow.UndertowConsumer;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.apache.camel.component.undertow.UndertowHost;
import org.jboss.gravia.runtime.ServiceLocator;
import org.wildfly.extension.camel.CamelLogger;
import org.wildfly.extension.camel.parser.SubsystemRuntimeState;

public class WildFlyUndertowComponent
extends UndertowComponent {
    private final SubsystemRuntimeState runtimeState;

    public WildFlyUndertowComponent(SubsystemRuntimeState runtimeState) {
        this.runtimeState = runtimeState;
    }

    protected UndertowEndpoint createEndpointInstance(URI endpointUri, UndertowComponent component) throws URISyntaxException {
        return new WildFlyUndertowEndpoint(endpointUri.toString(), component);
    }

    public void startServer(UndertowConsumer consumer) {
    }

    class WildFlyUndertowUndertowConsumer
    extends UndertowConsumer {
        WildFlyUndertowUndertowConsumer(UndertowEndpoint endpoint, Processor processor) throws Exception {
            super(endpoint, processor);
            URI uri = new URI(endpoint.getEndpointUri());
            String host = uri.getHost();
            int port = uri.getPort();
            if (!"localhost".equals(host)) {
                CamelLogger.LOGGER.warn("Ignoring configured host: {}", (Object)uri);
            }
        }

        protected UndertowHost createUndertowHost() {
            return (UndertowHost)ServiceLocator.getRequiredService(UndertowHost.class);
        }

        protected void doStart() throws Exception {
            super.doStart();
            URI httpUri = this.getEndpoint().getHttpURI();
            String contextPath = httpUri.getPath();
            WildFlyUndertowComponent.this.runtimeState.addHttpContext(contextPath);
        }

        protected void doStop() {
            URI httpUri = this.getEndpoint().getHttpURI();
            String contextPath = httpUri.getPath();
            WildFlyUndertowComponent.this.runtimeState.removeHttpContext(contextPath);
            super.doStop();
        }
    }

    class WildFlyUndertowEndpoint
    extends UndertowEndpoint {
        WildFlyUndertowEndpoint(String uri, UndertowComponent component) throws URISyntaxException {
            super(uri, component);
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            return new WildFlyUndertowUndertowConsumer(this, processor);
        }
    }
}

