/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.undertow;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.component.undertow.UndertowComponent;
import org.apache.camel.component.undertow.UndertowConsumer;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.apache.camel.component.undertow.UndertowHost;
import org.apache.camel.component.undertow.UndertowHostKey;
import org.jboss.gravia.runtime.ServiceLocator;
import org.wildfly.extension.camel.CamelLogger;
import org.wildfly.extension.camel.parser.SubsystemState;

public class WildFlyUndertowComponent
extends UndertowComponent {
    private final SubsystemState.RuntimeState runtimeState;

    public WildFlyUndertowComponent(SubsystemState.RuntimeState runtimeState) {
        this.runtimeState = runtimeState;
    }

    protected UndertowEndpoint createEndpointInstance(URI endpointUri, UndertowComponent component) throws URISyntaxException {
        return new WildFlyUndertowEndpoint(endpointUri.toString(), component);
    }

    protected UndertowHost createUndertowHost(UndertowHostKey key) {
        return (UndertowHost)ServiceLocator.getRequiredService(UndertowHost.class);
    }

    class WildFlyUndertowUndertowConsumer
    extends UndertowConsumer {
        WildFlyUndertowUndertowConsumer(UndertowEndpoint endpoint, Processor processor) throws Exception {
            super(endpoint, processor);
            URI uri = new URI(endpoint.getEndpointUri());
            String host = uri.getHost();
            if (!"localhost".equals(host)) {
                CamelLogger.LOGGER.warn("Ignoring configured host: {}", (Object)uri);
            }
        }

        protected void doStart() throws Exception {
            super.doStart();
            URI httpUri = this.getEndpoint().getHttpURI();
            String contextPath = httpUri.getPath();
            WildFlyUndertowComponent.this.runtimeState.addHttpContext(contextPath);
        }

        protected void doStop() throws Exception {
            URI httpUri = this.getEndpoint().getHttpURI();
            String contextPath = httpUri.getPath();
            WildFlyUndertowComponent.this.runtimeState.removeHttpContext(contextPath);
            super.doStop();
        }
    }

    class WildFlyUndertowEndpoint
    extends UndertowEndpoint {
        WildFlyUndertowEndpoint(String uri, UndertowComponent component) throws URISyntaxException {
            super(uri, component);
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            return new WildFlyUndertowUndertowConsumer(this, processor);
        }
    }
}

