/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.deployment;

import org.apache.camel.CamelContext;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.wildfly.camel.CamelConstants;
import org.wildfly.camel.CamelMessages;

public class CamelContextActivationProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        CamelContext camelctx = (CamelContext)depUnit.getAttachment(CamelConstants.CAMEL_CONTEXT_KEY);
        if (camelctx == null) {
            return;
        }
        try {
            camelctx.start();
        }
        catch (Exception ex) {
            throw CamelMessages.MESSAGES.cannotStartCamelContext(ex, camelctx);
        }
    }

    public void undeploy(DeploymentUnit depUnit) {
        CamelContext camelctx = (CamelContext)depUnit.getAttachment(CamelConstants.CAMEL_CONTEXT_KEY);
        if (camelctx != null) {
            try {
                camelctx.stop();
            }
            catch (Exception ex) {
                throw CamelMessages.MESSAGES.cannotStopCamelContext(ex, camelctx);
            }
        }
    }
}

