/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.parser;

import java.util.List;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.wildfly.camel.deployment.CamelComponentRegistrationProcessor;
import org.wildfly.camel.deployment.CamelContextActivationProcessor;
import org.wildfly.camel.deployment.CamelContextCreateProcessor;
import org.wildfly.camel.deployment.CamelContextRegistrationProcessor;
import org.wildfly.camel.deployment.CamelIntegrationProcessor;
import org.wildfly.camel.deployment.RepositoryContentInstallProcessor;
import org.wildfly.camel.parser.SubsystemState;
import org.wildfly.camel.service.CamelBootstrapService;
import org.wildfly.camel.service.CamelComponentRegistryService;
import org.wildfly.camel.service.CamelContextFactoryBindingService;
import org.wildfly.camel.service.CamelContextFactoryService;
import org.wildfly.camel.service.CamelContextRegistryBindingService;
import org.wildfly.camel.service.CamelContextRegistryService;
import org.wildfly.camel.service.EnvironmentService;
import org.wildfly.camel.service.ProvisionerService;
import org.wildfly.camel.service.RepositoryService;
import org.wildfly.camel.service.ResolverService;

final class CamelSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    public static final int PARSE_CAMEL_ITEGRATION_PROVIDER = 14337;
    public static final int POST_MODULE_CAMEL_CONTEXT_CREATE = 7681;
    public static final int INSTALL_REPOSITORY_CONTENT = 8257;
    public static final int INSTALL_CAMEL_COMPONENT_REGISTRATION = 8258;
    public static final int INSTALL_CAMEL_CONTEXT_REGISTRATION = 8259;
    public static final int INSTALL_CAMEL_CONTEXT_ACTIVATION = 8260;
    private final SubsystemState subsystemState;

    public CamelSubsystemAdd(SubsystemState subsystemState) {
        this.subsystemState = subsystemState;
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        model.setEmptyObject();
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, final ServiceVerificationHandler verificationHandler, final List<ServiceController<?>> newControllers) {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                newControllers.add(CamelBootstrapService.addService(context.getServiceTarget(), verificationHandler));
                newControllers.add(CamelComponentRegistryService.addService(context.getServiceTarget(), verificationHandler));
                newControllers.add(CamelContextFactoryService.addService(context.getServiceTarget(), verificationHandler));
                newControllers.add(CamelContextFactoryBindingService.addService(context.getServiceTarget(), verificationHandler));
                newControllers.add(CamelContextRegistryService.addService(context.getServiceTarget(), CamelSubsystemAdd.this.subsystemState, verificationHandler));
                newControllers.add(CamelContextRegistryBindingService.addService(context.getServiceTarget(), verificationHandler));
                newControllers.add(EnvironmentService.addService(context.getServiceTarget(), verificationHandler));
                newControllers.add(ResolverService.addService(context.getServiceTarget(), verificationHandler));
                newControllers.add(RepositoryService.addService(context.getServiceTarget(), verificationHandler));
                newControllers.add(ProvisionerService.addService(context.getServiceTarget(), verificationHandler));
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("camel", Phase.PARSE, 14337, (DeploymentUnitProcessor)new CamelIntegrationProcessor());
                processorTarget.addDeploymentProcessor("camel", Phase.POST_MODULE, 7681, (DeploymentUnitProcessor)new CamelContextCreateProcessor());
                processorTarget.addDeploymentProcessor("camel", Phase.INSTALL, 8258, (DeploymentUnitProcessor)new CamelComponentRegistrationProcessor());
                processorTarget.addDeploymentProcessor("camel", Phase.INSTALL, 8259, (DeploymentUnitProcessor)new CamelContextRegistrationProcessor());
                processorTarget.addDeploymentProcessor("camel", Phase.INSTALL, 8260, (DeploymentUnitProcessor)new CamelContextActivationProcessor());
                processorTarget.addDeploymentProcessor("camel", Phase.INSTALL, 8257, (DeploymentUnitProcessor)new RepositoryContentInstallProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }
}

