/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.service;

import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.camel.CamelConstants;
import org.wildfly.camel.CamelContextRegistry;
import org.wildfly.camel.CamelLogger;

public final class CamelContextRegistryBindingService {
    public static ServiceController<?> addService(ServiceTarget serviceTarget, ServiceVerificationHandler verificationHandler) {
        final ContextNames.BindInfo bindInfo = CamelContextRegistryBindingService.getBindInfo();
        BinderService binderService = new BinderService(bindInfo.getBindName()){

            public synchronized void start(StartContext context) throws StartException {
                super.start(context);
                CamelLogger.LOGGER.infoBoundCamelNamingObject(bindInfo.getAbsoluteJndiName());
            }

            public synchronized void stop(StopContext context) {
                CamelLogger.LOGGER.debugf("Unbind camel jndi name: %s", bindInfo.getAbsoluteJndiName());
                super.stop(context);
            }
        };
        Injector injector = binderService.getManagedObjectInjector();
        ServiceBuilder builder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService);
        builder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector());
        builder.addDependency(CamelConstants.CAMEL_CONTEXT_REGISTRY_SERVICE_NAME, CamelContextRegistry.class, (Injector)new ManagedReferenceInjector(injector));
        builder.addListener((ServiceListener)verificationHandler);
        return builder.install();
    }

    static ServiceName getBinderServiceName() {
        return CamelContextRegistryBindingService.getBindInfo().getBinderServiceName();
    }

    static ContextNames.BindInfo getBindInfo() {
        return ContextNames.bindInfoFor((String)"java:jboss/camel/CamelContextRegistry");
    }
}

