/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.gravia.repository.DefaultMavenIdentityRepository;
import org.jboss.gravia.repository.DefaultPersistentRepository;
import org.jboss.gravia.repository.DefaultRepositoryXMLReader;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.repository.RepositoryAggregator;
import org.jboss.gravia.repository.RepositoryStorage;
import org.jboss.gravia.resource.Resource;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.camel.CamelConstants;
import org.wildfly.camel.CamelMessages;

public class RepositoryService
extends AbstractService<Repository> {
    private final InjectedValue<ServerEnvironment> injectedServerEnvironment = new InjectedValue();
    private Repository repository;

    public static ServiceController<Repository> addService(ServiceTarget serviceTarget, ServiceVerificationHandler verificationHandler) {
        RepositoryService service = new RepositoryService();
        ServiceBuilder builder = serviceTarget.addService(CamelConstants.REPOSITORY_SERVICE_NAME, (Service)service);
        builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.injectedServerEnvironment);
        builder.addListener((ServiceListener)verificationHandler);
        return builder.install();
    }

    private RepositoryService() {
    }

    public void start(StartContext startContext) throws StartException {
        Repository.ConfigurationPropertyProvider propertyProvider = new Repository.ConfigurationPropertyProvider(){

            public String getProperty(String key, String defaultValue) {
                String value = null;
                if ("org.jboss.gravia.repository.storage.dir".equals(key)) {
                    try {
                        ServerEnvironment serverenv = (ServerEnvironment)RepositoryService.this.injectedServerEnvironment.getValue();
                        File storageDir = new File(serverenv.getServerDataDir().getPath() + File.separator + "repository");
                        value = storageDir.getCanonicalPath();
                    }
                    catch (IOException ex) {
                        throw CamelMessages.MESSAGES.cannotCreateRepositoryStorageArea(ex);
                    }
                }
                return value != null ? value : defaultValue;
            }
        };
        DefaultMavenIdentityRepository mavenRepo = new DefaultMavenIdentityRepository(propertyProvider);
        this.repository = new DefaultPersistentRepository(propertyProvider, (Repository)new RepositoryAggregator(new Repository[]{mavenRepo}));
        RepositoryStorage storage = (RepositoryStorage)this.repository.adapt(RepositoryStorage.class);
        ModuleClassLoader classLoader = Module.getCallerModule().getClassLoader();
        Iterator itres = classLoader.iterateResources("META-INF/repository-content", false);
        while (itres.hasNext()) {
            org.jboss.modules.Resource res = (org.jboss.modules.Resource)itres.next();
            try {
                InputStream input = res.openStream();
                DefaultRepositoryXMLReader reader = new DefaultRepositoryXMLReader(input);
                Resource auxres = reader.nextResource();
                while (auxres != null) {
                    if (storage.getResource(auxres.getIdentity()) == null) {
                        storage.addResource(auxres);
                    }
                    auxres = reader.nextResource();
                }
            }
            catch (IOException e) {
                throw CamelMessages.MESSAGES.cannotInstallCamelFeature(res.getName());
            }
        }
    }

    public Repository getValue() throws IllegalStateException {
        return this.repository;
    }
}

