/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.impl.DefaultComponentResolver;
import org.apache.camel.spi.ComponentResolver;
import org.wildfly.camel.CamelComponentRegistry;
import org.wildfly.camel.CamelMessages;

public class WildflyComponentResolver
implements ComponentResolver {
    private static ComponentResolver defaultResolver = new DefaultComponentResolver();
    private final CamelComponentRegistry componentRegistry;

    public WildflyComponentResolver(CamelComponentRegistry componentRegistry) {
        if (componentRegistry == null) {
            throw CamelMessages.MESSAGES.illegalArgumentNull("componentRegistry");
        }
        this.componentRegistry = componentRegistry;
    }

    public Component resolveComponent(String name, CamelContext context) throws Exception {
        Component component = defaultResolver.resolveComponent(name, context);
        if (component != null) {
            return component;
        }
        ComponentResolver resolver = this.componentRegistry.getComponent(name);
        component = resolver != null ? resolver.resolveComponent(name, context) : null;
        return component;
    }
}

