/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.parser;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.camel.parser.SubsystemState;

final class CamelContextRemove
extends AbstractRemoveStepHandler {
    private final SubsystemState subsystemState;

    CamelContextRemove(SubsystemState subsystemState) {
        this.subsystemState = subsystemState;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        final String propName = operation.get("address").asObject().get("context").asString();
        final String oldContextDefinition = this.subsystemState.removeContextDefinition(propName);
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                CamelContextRemove.this.subsystemState.putContextDefinition(propName, oldContextDefinition);
            }
        });
    }
}

