/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.deployment;

import org.apache.camel.CamelContext;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.wildfly.camel.CamelConstants;
import org.wildfly.camel.CamelContextRegistry;
import org.wildfly.camel.CamelMessages;

public class CamelContextRegistrationProcessor
implements DeploymentUnitProcessor {
    AttachmentKey<CamelContextRegistry.CamelContextRegistration> CAMEL_CONTEXT_REGISTRATION_KEY = AttachmentKey.create(CamelContextRegistry.CamelContextRegistration.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        CamelContext camelctx = (CamelContext)depUnit.getAttachment(CamelConstants.CAMEL_CONTEXT_KEY);
        if (camelctx == null) {
            return;
        }
        CamelContextRegistry registry = (CamelContextRegistry)depUnit.getAttachment(CamelConstants.CAMEL_CONTEXT_REGISTRY_KEY);
        try {
            CamelContextRegistry.CamelContextRegistration registration = registry.registerCamelContext(camelctx);
            depUnit.putAttachment(this.CAMEL_CONTEXT_REGISTRATION_KEY, (Object)registration);
        }
        catch (Exception ex) {
            throw CamelMessages.MESSAGES.cannotStartCamelContext(ex, camelctx);
        }
    }

    public void undeploy(DeploymentUnit depUnit) {
        CamelContextRegistry.CamelContextRegistration registration = (CamelContextRegistry.CamelContextRegistration)depUnit.getAttachment(this.CAMEL_CONTEXT_REGISTRATION_KEY);
        if (registration != null) {
            registration.unregister();
        }
    }
}

