/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.gravia.repository.DefaultRepositoryXMLReader;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.resolver.Environment;
import org.jboss.gravia.resource.Resource;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.camel.CamelConstants;
import org.wildfly.extension.camel.CamelLogger;
import org.wildfly.extension.gravia.GraviaConstants;

public final class CamelBootstrapService
extends AbstractService<Void> {
    private final InjectedValue<Environment> injectedEnvironment = new InjectedValue();
    private final InjectedValue<Repository> injectedRepository = new InjectedValue();

    public static ServiceController<Void> addService(ServiceTarget serviceTarget, ServiceVerificationHandler verificationHandler) {
        CamelBootstrapService service = new CamelBootstrapService();
        ServiceBuilder builder = serviceTarget.addService(CamelConstants.CAMEL_SUBSYSTEM_SERVICE_NAME, (Service)service);
        builder.addDependency(GraviaConstants.ENVIRONMENT_SERVICE_NAME, Environment.class, service.injectedEnvironment);
        builder.addDependency(GraviaConstants.REPOSITORY_SERVICE_NAME, Repository.class, service.injectedRepository);
        builder.addListener((ServiceListener)verificationHandler);
        return builder.install();
    }

    private CamelBootstrapService() {
    }

    public void start(StartContext startContext) throws StartException {
        CamelLogger.LOGGER.info("Activating Camel Subsystem");
        this.installRepositoryContent(startContext);
    }

    private void installRepositoryContent(StartContext startContext) throws StartException {
        Repository repository = (Repository)this.injectedRepository.getValue();
        ModuleClassLoader classLoader = Module.getCallerModule().getClassLoader();
        Iterator itres = classLoader.iterateResources("META-INF/repository-content", false);
        while (itres.hasNext()) {
            org.jboss.modules.Resource res = (org.jboss.modules.Resource)itres.next();
            try {
                InputStream input = res.openStream();
                DefaultRepositoryXMLReader reader = new DefaultRepositoryXMLReader(input);
                Resource auxres = reader.nextResource();
                while (auxres != null) {
                    if (repository.getResource(auxres.getIdentity()) == null) {
                        repository.addResource(auxres);
                    }
                    auxres = reader.nextResource();
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot install feature to repository: " + res.getName(), ex);
            }
        }
    }
}

