/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.deployment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.dataformat.bindy.annotation.CsvRecord;
import org.apache.camel.dataformat.bindy.annotation.FixedLengthRecord;
import org.jboss.as.ee.component.deployers.BooleanAnnotationInformationFactory;
import org.jboss.as.ee.metadata.ClassAnnotationInformationFactory;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;

public class BindyAnnotationProcessor
implements DeploymentUnitProcessor {
    final List<ClassAnnotationInformationFactory> factories;

    public BindyAnnotationProcessor() {
        ArrayList<BooleanAnnotationInformationFactory> factories = new ArrayList<BooleanAnnotationInformationFactory>();
        factories.add(new BooleanAnnotationInformationFactory(CsvRecord.class));
        factories.add(new BooleanAnnotationInformationFactory(FixedLengthRecord.class));
        this.factories = Collections.unmodifiableList(factories);
    }

    public final void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (index == null) {
            return;
        }
        for (ClassAnnotationInformationFactory factory : this.factories) {
            factory.createAnnotationInformation(index, false);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

