/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.deployment;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilters;

public final class CamelDependenciesProcessor
implements DeploymentUnitProcessor {
    private static final String GRAVIA = "org.jboss.gravia";
    private static final String APACHE_CAMEL = "org.apache.camel";
    private static final String APACHE_CAMEL_COMPONENT = "org.apache.camel.component";
    private static final String WILDFLY_CAMEL = "org.wildfly.extension.camel";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        String runtimeName = unit.getName();
        if (runtimeName.startsWith("hawtio") && runtimeName.endsWith(".war")) {
            return;
        }
        ModuleLoader moduleLoader = (ModuleLoader)unit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        ModuleSpecification moduleSpec = (ModuleSpecification)unit.getAttachment(Attachments.MODULE_SPECIFICATION);
        moduleSpec.addUserDependency(new ModuleDependency(moduleLoader, ModuleIdentifier.create((String)GRAVIA), false, false, false, false));
        moduleSpec.addUserDependency(new ModuleDependency(moduleLoader, ModuleIdentifier.create((String)APACHE_CAMEL), false, false, false, false));
        moduleSpec.addUserDependency(new ModuleDependency(moduleLoader, ModuleIdentifier.create((String)WILDFLY_CAMEL), false, false, false, false));
        moduleSpec.addUserDependency(new ModuleDependency(moduleLoader, ModuleIdentifier.create((String)APACHE_CAMEL_COMPONENT), false, false, true, false));
        ModuleDependency moddep = new ModuleDependency(moduleLoader, ModuleIdentifier.create((String)"org.apache.camel.component.cdi"), false, false, false, false);
        moddep.addImportFilter(PathFilters.getMetaInfSubdirectoriesFilter(), true);
        moddep.addImportFilter(PathFilters.getMetaInfFilter(), true);
        moduleSpec.addUserDependency(moddep);
        moddep = new ModuleDependency(moduleLoader, ModuleIdentifier.create((String)"org.apache.deltaspike.core.api"), false, false, false, false);
        moddep.addImportFilter(PathFilters.getMetaInfSubdirectoriesFilter(), true);
        moddep.addImportFilter(PathFilters.getMetaInfFilter(), true);
        moduleSpec.addUserDependency(moddep);
        moddep = new ModuleDependency(moduleLoader, ModuleIdentifier.create((String)"org.apache.deltaspike.core.impl"), false, false, false, false);
        moddep.addImportFilter(PathFilters.getMetaInfSubdirectoriesFilter(), true);
        moddep.addImportFilter(PathFilters.getMetaInfFilter(), true);
        moduleSpec.addUserDependency(moddep);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

