/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.deployment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.dataformat.bindy.annotation.CsvRecord;
import org.apache.camel.dataformat.bindy.annotation.FixedLengthRecord;
import org.apache.camel.impl.DefaultPackageScanClassResolver;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanFilter;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.wildfly.extension.camel.CamelConstants;
import org.wildfly.extension.camel.CamelContextFactory;

public class PackageScanResolverProcessor
implements DeploymentUnitProcessor {
    private CamelContextFactory.ContextCreateHandler contextCreateHandler;

    public final void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        CompositeIndex index = (CompositeIndex)depUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (index == null) {
            return;
        }
        ArrayList annotations = new ArrayList();
        annotations.addAll(index.getAnnotations(DotName.createSimple((String)CsvRecord.class.getName())));
        annotations.addAll(index.getAnnotations(DotName.createSimple((String)FixedLengthRecord.class.getName())));
        final HashMap<DotName, HashSet<ClassInfo>> annotatedClasses = new HashMap<DotName, HashSet<ClassInfo>>();
        for (AnnotationInstance instance : annotations) {
            DotName name = instance.name();
            AnnotationTarget target = instance.target();
            if (!(target instanceof ClassInfo)) continue;
            HashSet<ClassInfo> set = (HashSet<ClassInfo>)annotatedClasses.get(name);
            if (set == null) {
                set = new HashSet<ClassInfo>();
                annotatedClasses.put(name, set);
            }
            set.add((ClassInfo)target);
        }
        if (annotatedClasses.isEmpty()) {
            return;
        }
        final ModuleClassLoader classLoader = ((Module)depUnit.getAttachment(Attachments.MODULE)).getClassLoader();
        this.contextCreateHandler = new CamelContextFactory.ContextCreateHandler(){

            @Override
            public void setup(CamelContext camelctx) {
                DefaultPackageScanClassResolver resolver = new DefaultPackageScanClassResolver(){

                    protected void find(PackageScanFilter filter, String packageName, ClassLoader loader, Set<Class<?>> classes) {
                        if (loader == classLoader) {
                            for (Map.Entry entry : annotatedClasses.entrySet()) {
                                for (ClassInfo classInfo : (Set)entry.getValue()) {
                                    Class targetClass = PackageScanResolverProcessor.this.loadClass(classLoader, classInfo.name());
                                    if (!filter.matches(targetClass)) continue;
                                    classes.add(targetClass);
                                }
                            }
                        }
                    }
                };
                resolver.addClassLoader((ClassLoader)classLoader);
                camelctx.setPackageScanClassResolver((PackageScanClassResolver)resolver);
            }
        };
        CamelContextFactory factory = (CamelContextFactory)depUnit.getAttachment(CamelConstants.CAMEL_CONTEXT_FACTORY_KEY);
        factory.addContextCreateHandler((ClassLoader)classLoader, this.contextCreateHandler);
    }

    private Class<?> loadClass(ModuleClassLoader classLoader, DotName dotname) {
        try {
            return classLoader.loadClass(dotname.toString());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void undeploy(DeploymentUnit depUnit) {
        CamelContextFactory factory = (CamelContextFactory)depUnit.getAttachment(CamelConstants.CAMEL_CONTEXT_FACTORY_KEY);
        ModuleClassLoader classLoader = ((Module)depUnit.getAttachment(Attachments.MODULE)).getClassLoader();
        factory.removeContextCreateHandler((ClassLoader)classLoader, this.contextCreateHandler);
    }
}

