/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.deployment;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.camel.CamelConstants;
import org.wildfly.extension.camel.CamelLogger;
import org.wildfly.extension.camel.deployment.CamelDeploymentSettings;

public final class CamelEnablementProcessor
implements DeploymentUnitProcessor {
    private static Map<String, DeploymentUnit> deploymentMap = new HashMap<String, DeploymentUnit>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeploymentUnit getDeploymentUnitForName(String name) {
        Map<String, DeploymentUnit> map = deploymentMap;
        synchronized (map) {
            return deploymentMap.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        CamelDeploymentSettings depSettings = (CamelDeploymentSettings)depUnit.getAttachment(CamelDeploymentSettings.ATTACHMENT_KEY);
        if (depSettings == null) {
            depSettings = new CamelDeploymentSettings();
            depUnit.putAttachment(CamelDeploymentSettings.ATTACHMENT_KEY, (Object)depSettings);
        }
        Map<String, DeploymentUnit> map = deploymentMap;
        synchronized (map) {
            deploymentMap.put(this.getCanonicalDepUnitName(depUnit), depUnit);
        }
        VirtualFile rootFile = ((ResourceRoot)depUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        if (rootFile.getChild("META-INF/switchyard.xml").exists()) {
            depSettings.setEnabled(false);
            return;
        }
        String runtimeName = depUnit.getName();
        if (runtimeName.startsWith("hawtio") && runtimeName.endsWith(".war") || runtimeName.endsWith(".rar")) {
            depSettings.setEnabled(false);
            return;
        }
        if (runtimeName.equals("arquillian-service")) {
            depSettings.setEnabled(true);
            return;
        }
        AttachmentList subDeployments = (AttachmentList)depUnit.getAttachment(Attachments.SUB_DEPLOYMENTS);
        if (depUnit.getName().endsWith(".ear") && subDeployments != null) {
            for (DeploymentUnit subDepUnit : subDeployments) {
                CamelDeploymentSettings subDepSettings = new CamelDeploymentSettings();
                this.enableCamelIfRequired(subDepUnit, subDepSettings);
                if (!subDepSettings.isEnabled()) continue;
                depSettings.setEnabled(true);
                return;
            }
        }
        this.enableCamelIfRequired(depUnit, depSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(DeploymentUnit depUnit) {
        Map<String, DeploymentUnit> map = deploymentMap;
        synchronized (map) {
            deploymentMap.remove(this.getCanonicalDepUnitName(depUnit));
        }
    }

    private void enableCamelIfRequired(DeploymentUnit depUnit, CamelDeploymentSettings depSettings) {
        List contextURLs;
        AnnotationInstance annotation = this.getAnnotation(depUnit, "org.wildfly.extension.camel.CamelAware");
        if (annotation != null) {
            CamelLogger.LOGGER.info("@CamelAware annotation found");
            AnnotationValue value = annotation.value();
            depSettings.setEnabled(value != null ? value.asBoolean() : true);
            return;
        }
        List<AnnotationInstance> annotations = this.getAnnotations(depUnit, "org.apache.camel.cdi.ContextName");
        if (!annotations.isEmpty()) {
            CamelLogger.LOGGER.info("@ContextName annotation found");
            depSettings.setEnabled(true);
        }
        if (!(contextURLs = depUnit.getAttachmentList(CamelConstants.CAMEL_CONTEXT_DESCRIPTORS_KEY)).isEmpty()) {
            CamelLogger.LOGGER.info("Camel context descriptors found");
            depSettings.setEnabled(true);
        }
    }

    private List<AnnotationInstance> getAnnotations(DeploymentUnit depUnit, String className) {
        CompositeIndex index = (CompositeIndex)depUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        return index.getAnnotations(DotName.createSimple((String)className));
    }

    private AnnotationInstance getAnnotation(DeploymentUnit depUnit, String className) {
        List<AnnotationInstance> annotations = this.getAnnotations(depUnit, className);
        if (annotations.size() > 1) {
            CamelLogger.LOGGER.warn("Multiple annotations found: {}", annotations);
        }
        return annotations.size() > 0 ? annotations.get(0) : null;
    }

    private String getCanonicalDepUnitName(DeploymentUnit depUnit) {
        DeploymentUnit parent = depUnit.getParent();
        return parent != null ? parent.getName() + "." + depUnit.getName() : depUnit.getName();
    }
}

