/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.handler;

import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Route;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.support.LifecycleStrategySupport;
import org.wildfly.extension.camel.ContextCreateHandler;

public final class ContextValidationHandler
implements ContextCreateHandler {
    @Override
    public void setup(CamelContext camelctx) {
        camelctx.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

            public void onRoutesAdd(Collection<Route> routes) {
                for (Route route : routes) {
                    Consumer consumer = route.getConsumer();
                    if (consumer == null) continue;
                    Endpoint endpoint = consumer.getEndpoint();
                    String eppackage = endpoint.getClass().getPackage().getName();
                    if (eppackage.startsWith("org.apache.camel.component.cxf")) {
                        throw new UnsupportedOperationException("CXF consumer endpoint not supported");
                    }
                    if (!eppackage.startsWith("org.apache.camel.component.restlet")) continue;
                    throw new UnsupportedOperationException("Restlet consumer endpoint not supported");
                }
            }
        });
    }
}

