/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.CamelContextTrackerRegistry;
import org.apache.camel.management.event.CamelContextStartingEvent;
import org.apache.camel.management.event.CamelContextStoppedEvent;
import org.apache.camel.spi.CamelContextTracker;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.support.EventNotifierSupport;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.ServiceRegistration;
import org.jboss.gravia.utils.IllegalStateAssertion;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.camel.CamelConstants;
import org.wildfly.extension.camel.CamelContextRegistry;
import org.wildfly.extension.camel.CamelLogger;
import org.wildfly.extension.camel.ContextCreateHandler;
import org.wildfly.extension.camel.ContextCreateHandlerRegistry;
import org.wildfly.extension.camel.SpringCamelContextFactory;
import org.wildfly.extension.camel.deployment.CamelDeploymentSettings;
import org.wildfly.extension.camel.deployment.CamelDeploymentSettingsProcessor;
import org.wildfly.extension.camel.handler.ModuleClassLoaderAssociationHandler;
import org.wildfly.extension.camel.parser.SubsystemState;
import org.wildfly.extension.camel.service.CamelContextBindingService;
import org.wildfly.extension.gravia.GraviaConstants;

public class CamelContextRegistryService
extends AbstractService<CamelContextRegistry> {
    private static final String SPRING_BEANS_HEADER = "<beans xmlns='http://www.springframework.org/schema/beans' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd http://www.springframework.org/schema/context http://www.springframework.org/schema/context/spring-context.xsd http://camel.apache.org/schema/spring http://camel.apache.org/schema/spring/camel-spring.xsd'>";
    private final SubsystemState subsystemState;
    private final InjectedValue<Runtime> injectedRuntime = new InjectedValue();
    private final InjectedValue<ContextCreateHandlerRegistry> injectedHandlerRegistry = new InjectedValue();
    private CamelContextRegistry contextRegistry;
    private ServiceRegistration<CamelContextRegistry> registration;

    public static ServiceController<CamelContextRegistry> addService(ServiceTarget serviceTarget, SubsystemState subsystemState, ServiceVerificationHandler verificationHandler) {
        CamelContextRegistryService service = new CamelContextRegistryService(subsystemState);
        ServiceBuilder builder = serviceTarget.addService(CamelConstants.CAMEL_CONTEXT_REGISTRY_SERVICE_NAME, (Service)service);
        builder.addDependency(GraviaConstants.RUNTIME_SERVICE_NAME, Runtime.class, service.injectedRuntime);
        builder.addDependency(CamelConstants.CONTEXT_CREATE_HANDLER_REGISTRY_SERVICE_NAME, ContextCreateHandlerRegistry.class, service.injectedHandlerRegistry);
        builder.addListener((ServiceListener)verificationHandler);
        return builder.install();
    }

    private CamelContextRegistryService(SubsystemState subsystemState) {
        this.subsystemState = subsystemState;
    }

    public void start(StartContext startContext) throws StartException {
        ContextCreateHandlerRegistry handlerRegistry = (ContextCreateHandlerRegistry)this.injectedHandlerRegistry.getValue();
        ServiceContainer serviceRegistry = startContext.getController().getServiceContainer();
        this.contextRegistry = new CamelContextRegistryImpl(handlerRegistry, (ServiceRegistry)serviceRegistry, startContext.getChildTarget());
        Runtime runtime = (Runtime)this.injectedRuntime.getValue();
        ModuleContext syscontext = runtime.getModuleContext();
        this.registration = syscontext.registerService(CamelContextRegistry.class, (Object)this.contextRegistry, null);
        for (String name : this.subsystemState.getContextDefinitionNames()) {
            this.createCamelContext(name, this.subsystemState.getContextDefinition(name));
        }
    }

    public void stop(StopContext context) {
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    public CamelContextRegistry getValue() {
        return this.contextRegistry;
    }

    public void createCamelContext(String name, String contextDefinition) {
        ClassLoader classLoader = CamelContextRegistry.class.getClassLoader();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            String beansXML = this.getBeansXML(name, contextDefinition);
            SpringCamelContextFactory.createCamelContextList(beansXML.getBytes(), classLoader);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot create camel context: " + name, ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    private String getBeansXML(String name, String contextDefinition) {
        String hashReplaced = contextDefinition.replace("#{", "${");
        return "<beans xmlns='http://www.springframework.org/schema/beans' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd http://www.springframework.org/schema/context http://www.springframework.org/schema/context/spring-context.xsd http://camel.apache.org/schema/spring http://camel.apache.org/schema/spring/camel-spring.xsd'><camelContext id='" + name + "' xmlns='http://camel.apache.org/schema/spring'>" + hashReplaced + "</camelContext></beans>";
    }

    static final class CamelContextRegistryImpl
    extends CamelContextTracker
    implements CamelContextRegistry {
        private final Map<CamelContext, CamelContextRegistration> contexts = new HashMap<CamelContext, CamelContextRegistration>();
        private final ContextCreateHandlerRegistry handlerRegistry;
        private final ServiceTarget serviceTarget;

        CamelContextRegistryImpl(ContextCreateHandlerRegistry handlerRegistry, ServiceRegistry serviceRegistry, ServiceTarget serviceTarget) {
            this.handlerRegistry = handlerRegistry;
            this.serviceTarget = serviceTarget;
            CamelContextTrackerRegistry.INSTANCE.addTracker((CamelContextTracker)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CamelContext getCamelContext(String name) {
            CamelContext result = null;
            Map<CamelContext, CamelContextRegistration> map = this.contexts;
            synchronized (map) {
                for (CamelContext camelctx : this.contexts.keySet()) {
                    if (!camelctx.getName().equals(name)) continue;
                    result = camelctx;
                    break;
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<CamelContext> getCamelContexts() {
            Map<CamelContext, CamelContextRegistration> map = this.contexts;
            synchronized (map) {
                return Collections.unmodifiableSet(this.contexts.keySet());
            }
        }

        public void contextCreated(CamelContext camelctx) {
            boolean enableIntegration = true;
            ModuleClassLoader moduleClassLoader = ModuleClassLoaderAssociationHandler.getModuleClassLoader(camelctx);
            ModuleIdentifier moduleId = moduleClassLoader.getModule().getIdentifier();
            if (moduleId.getName().startsWith("deployment.")) {
                String depName = moduleId.getName().substring(11);
                CamelDeploymentSettings depSettings = CamelDeploymentSettingsProcessor.getDeploymentSettings(depName);
                enableIntegration = depSettings.isEnabled();
            }
            if (enableIntegration) {
                for (ContextCreateHandler handler : this.handlerRegistry.getContextCreateHandlers(null)) {
                    handler.setup(camelctx);
                }
                ClassLoader classLoader = camelctx.getApplicationContextClassLoader();
                IllegalStateAssertion.assertTrue((Boolean)(classLoader instanceof ModuleClassLoader), (String)("Invalid class loader association: " + classLoader));
                for (ContextCreateHandler handler : this.handlerRegistry.getContextCreateHandlers(classLoader)) {
                    handler.setup(camelctx);
                }
                ManagementStrategy mgmtStrategy = camelctx.getManagementStrategy();
                mgmtStrategy.addEventNotifier((EventNotifier)new EventNotifierSupport(){

                    public void notify(EventObject event) throws Exception {
                        if (event instanceof CamelContextStartingEvent) {
                            CamelContextStartingEvent camelevt = (CamelContextStartingEvent)event;
                            CamelContext camelctx = camelevt.getContext();
                            CamelContextRegistryImpl.this.addContext(camelctx);
                            CamelLogger.LOGGER.info("Camel context starting: {}", (Object)camelctx.getName());
                        } else if (event instanceof CamelContextStoppedEvent) {
                            CamelContextStoppedEvent camelevt = (CamelContextStoppedEvent)event;
                            CamelContext camelctx = camelevt.getContext();
                            CamelContextRegistryImpl.this.removeContext(camelctx);
                            CamelLogger.LOGGER.info("Camel context stopped: {}", (Object)camelctx.getName());
                        }
                    }

                    public boolean isEnabled(EventObject event) {
                        return true;
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CamelContextRegistration addContext(CamelContext camelctx) {
            Map<CamelContext, CamelContextRegistration> map = this.contexts;
            synchronized (map) {
                CamelContextRegistration registration = this.contexts.get(camelctx);
                if (registration == null) {
                    ServiceController<?> controller = CamelContextBindingService.addService(this.serviceTarget, camelctx);
                    registration = new CamelContextRegistration().addServiceDependency(controller);
                    this.contexts.put(camelctx, registration);
                }
                return registration;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeContext(CamelContext camelctx) {
            Map<CamelContext, CamelContextRegistration> map = this.contexts;
            synchronized (map) {
                CamelContextRegistration registration = this.contexts.remove(camelctx);
                if (registration != null) {
                    for (ServiceController controller : registration.controllers) {
                        controller.setMode(ServiceController.Mode.REMOVE);
                    }
                }
            }
        }

        class CamelContextRegistration {
            private List<ServiceController<?>> controllers = new ArrayList();

            CamelContextRegistration() {
            }

            CamelContextRegistration addServiceDependency(ServiceController<?> controller) {
                this.controllers.add(controller);
                return this;
            }
        }
    }
}

