/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.ServiceRegistration;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.camel.CamelConstants;
import org.wildfly.extension.camel.ContextCreateHandler;
import org.wildfly.extension.camel.ContextCreateHandlerRegistry;
import org.wildfly.extension.camel.handler.ClassResolverAssociationHandler;
import org.wildfly.extension.camel.handler.ContextValidationHandler;
import org.wildfly.extension.camel.handler.ModelJAXBContextFactoryWrapperHandler;
import org.wildfly.extension.camel.handler.ModuleClassLoaderAssociationHandler;
import org.wildfly.extension.camel.handler.NamingContextAssociationHandler;
import org.wildfly.extension.gravia.GraviaConstants;

public class ContextCreateHandlerRegistryService
extends AbstractService<ContextCreateHandlerRegistry> {
    private final InjectedValue<Runtime> injectedRuntime = new InjectedValue();
    private ServiceRegistration<ContextCreateHandlerRegistry> registration;
    private ContextCreateHandlerRegistry createHandlerRegistry;

    public static ServiceController<ContextCreateHandlerRegistry> addService(ServiceTarget serviceTarget, ServiceVerificationHandler verificationHandler) {
        ContextCreateHandlerRegistryService service = new ContextCreateHandlerRegistryService();
        ServiceBuilder builder = serviceTarget.addService(CamelConstants.CONTEXT_CREATE_HANDLER_REGISTRY_SERVICE_NAME, (Service)service);
        builder.addDependency(GraviaConstants.RUNTIME_SERVICE_NAME, Runtime.class, service.injectedRuntime);
        builder.addListener((ServiceListener)verificationHandler);
        return builder.install();
    }

    public void start(StartContext startContext) throws StartException {
        ServiceContainer serviceRegistry = startContext.getController().getServiceContainer();
        this.createHandlerRegistry = new ContextCreateHandlerRegistryImpl((ServiceRegistry)serviceRegistry, startContext.getChildTarget());
        Runtime runtime = (Runtime)this.injectedRuntime.getValue();
        ModuleContext syscontext = runtime.getModuleContext();
        this.registration = syscontext.registerService(ContextCreateHandlerRegistry.class, (Object)this.createHandlerRegistry, null);
    }

    public void stop(StopContext context) {
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    public ContextCreateHandlerRegistry getValue() {
        return this.createHandlerRegistry;
    }

    static final class ContextCreateHandlerRegistryImpl
    implements ContextCreateHandlerRegistry {
        private final Map<ClassLoader, List<ContextCreateHandler>> handlerMapping = new HashMap<ClassLoader, List<ContextCreateHandler>>();

        ContextCreateHandlerRegistryImpl(ServiceRegistry serviceRegistry, ServiceTarget serviceTarget) {
            this.addContextCreateHandler(null, new ModuleClassLoaderAssociationHandler());
            this.addContextCreateHandler(null, new ClassResolverAssociationHandler());
            this.addContextCreateHandler(null, new NamingContextAssociationHandler(serviceRegistry, serviceTarget));
            this.addContextCreateHandler(null, new ContextValidationHandler());
            this.addContextCreateHandler(null, new ModelJAXBContextFactoryWrapperHandler());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<ContextCreateHandler> getContextCreateHandlers(ClassLoader classsLoader) {
            ArrayList<ContextCreateHandler> result = new ArrayList<ContextCreateHandler>();
            Map<ClassLoader, List<ContextCreateHandler>> map = this.handlerMapping;
            synchronized (map) {
                List<ContextCreateHandler> handlers = this.handlerMapping.get(classsLoader);
                if (handlers != null) {
                    result.addAll(handlers);
                }
            }
            return Collections.unmodifiableList(result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addContextCreateHandler(ClassLoader classsLoader, ContextCreateHandler handler) {
            Map<ClassLoader, List<ContextCreateHandler>> map = this.handlerMapping;
            synchronized (map) {
                List<ContextCreateHandler> handlers = this.handlerMapping.get(classsLoader);
                if (handlers == null) {
                    handlers = new ArrayList<ContextCreateHandler>();
                    this.handlerMapping.put(classsLoader, handlers);
                }
                handlers.add(handler);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeContextCreateHandler(ClassLoader classsLoader, ContextCreateHandler handler) {
            Map<ClassLoader, List<ContextCreateHandler>> map = this.handlerMapping;
            synchronized (map) {
                List<ContextCreateHandler> handlers = this.handlerMapping.get(classsLoader);
                if (handlers != null) {
                    handlers.remove(handler);
                    if (handlers.isEmpty()) {
                        this.handlerMapping.remove(classsLoader);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeContextCreateHandlers(ClassLoader classsLoader) {
            Map<ClassLoader, List<ContextCreateHandler>> map = this.handlerMapping;
            synchronized (map) {
                this.handlerMapping.remove(classsLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(ClassLoader classLoader) {
            Map<ClassLoader, List<ContextCreateHandler>> map = this.handlerMapping;
            synchronized (map) {
                return this.handlerMapping.containsKey(classLoader);
            }
        }
    }
}

