/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.deployment;

import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.camel.CamelConstants;
import org.wildfly.extension.camel.CamelLogger;
import org.wildfly.extension.camel.deployment.CamelDeploymentSettings;

public final class CamelEnablementProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        List contextURLs;
        VirtualFile rootFile;
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        CamelDeploymentSettings depSettings = (CamelDeploymentSettings)depUnit.getAttachment(CamelDeploymentSettings.ATTACHMENT_KEY);
        if (depSettings == null) {
            depSettings = new CamelDeploymentSettings();
            depUnit.putAttachment(CamelDeploymentSettings.ATTACHMENT_KEY, (Object)depSettings);
        }
        if ((rootFile = ((ResourceRoot)depUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot()).getChild("META-INF/switchyard.xml").exists()) {
            depSettings.setEnabled(false);
            return;
        }
        String runtimeName = depUnit.getName();
        if (runtimeName.startsWith("hawtio") && runtimeName.endsWith(".war") || runtimeName.endsWith(".rar")) {
            depSettings.setEnabled(false);
            return;
        }
        AnnotationInstance annotation = this.getAnnotation(depUnit, "org.wildfly.extension.camel.CamelAware");
        if (annotation != null) {
            CamelLogger.LOGGER.info("@CamelAware annotation found");
            AnnotationValue value = annotation.value();
            depSettings.setEnabled(value != null ? value.asBoolean() : true);
            return;
        }
        List<AnnotationInstance> annotations = this.getAnnotations(depUnit, "org.apache.camel.cdi.ContextName");
        if (!annotations.isEmpty()) {
            CamelLogger.LOGGER.info("@ContextName annotation found");
            depSettings.setEnabled(true);
        }
        if (!(contextURLs = depUnit.getAttachmentList(CamelConstants.CAMEL_CONTEXT_DESCRIPTORS_KEY)).isEmpty()) {
            CamelLogger.LOGGER.info("Camel context descriptors found");
            depSettings.setEnabled(true);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private List<AnnotationInstance> getAnnotations(DeploymentUnit depUnit, String className) {
        CompositeIndex index = (CompositeIndex)depUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        return index.getAnnotations(DotName.createSimple((String)className));
    }

    private AnnotationInstance getAnnotation(DeploymentUnit depUnit, String className) {
        List<AnnotationInstance> annotations = this.getAnnotations(depUnit, className);
        if (annotations.size() > 1) {
            CamelLogger.LOGGER.warn("Multiple annotations found: {}", annotations);
        }
        return annotations.size() > 0 ? annotations.get(0) : null;
    }
}

