/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.service;

import io.undertow.server.HttpHandler;
import java.net.URI;
import org.apache.camel.component.undertow.UndertowHost;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.ServiceRegistration;
import org.jboss.gravia.utils.IllegalStateAssertion;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.camel.CamelConstants;
import org.wildfly.extension.gravia.GraviaConstants;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.UndertowService;

public class CamelUndertowHostService
extends AbstractService<UndertowHost> {
    private static final ServiceName SERVICE_NAME = CamelConstants.CAMEL_BASE_NAME.append(new String[]{"Undertow"});
    private final InjectedValue<Host> injectedDefaultHost = new InjectedValue();
    private final InjectedValue<Runtime> injectedRuntime = new InjectedValue();
    private ServiceRegistration<UndertowHost> registration;
    private UndertowHost undertowHost;

    public static ServiceController<UndertowHost> addService(ServiceTarget serviceTarget) {
        CamelUndertowHostService service = new CamelUndertowHostService();
        ServiceBuilder builder = serviceTarget.addService(SERVICE_NAME, (Service)service);
        builder.addDependency(GraviaConstants.RUNTIME_SERVICE_NAME, Runtime.class, service.injectedRuntime);
        builder.addDependency(UndertowService.virtualHostName((String)"default-server", (String)"default-host"), Host.class, service.injectedDefaultHost);
        return builder.install();
    }

    private CamelUndertowHostService() {
    }

    public void start(StartContext startContext) throws StartException {
        this.undertowHost = new WildflyUndertowHost((Host)this.injectedDefaultHost.getValue());
        ModuleContext syscontext = ((Runtime)this.injectedRuntime.getValue()).getModuleContext();
        this.registration = syscontext.registerService(UndertowHost.class, (Object)this.undertowHost, null);
    }

    public void stop(StopContext context) {
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    public UndertowHost getValue() throws IllegalStateException {
        return this.undertowHost;
    }

    class WildflyUndertowHost
    implements UndertowHost {
        private final Host defaultHost;

        WildflyUndertowHost(Host host) {
            this.defaultHost = host;
        }

        public void validateEndpointURI(URI httpURI) {
            IllegalStateAssertion.assertEquals((Object)"localhost", (Object)httpURI.getHost(), (String)("Cannot bind to host other than 'localhost': " + httpURI));
            IllegalStateAssertion.assertEquals((Object)-1, (Object)httpURI.getPort(), (String)("Cannot bind to specific port: " + httpURI));
        }

        public void registerHandler(String path, HttpHandler handler) {
            this.defaultHost.registerHandler(path, handler);
        }

        public void unregisterHandler(String path) {
            this.defaultHost.unregisterHandler(path);
        }
    }
}

