/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.cloud.annotation.processor;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.annotation.Port;
import io.dekorate.openshift.annotation.OpenshiftApplication;
import io.dekorate.s2i.annotation.S2iBuild;
import java.util.Map;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import org.wildfly.test.cloud.annotation.processor.WildFlyDefaultsAbstractAnnotationProcessor;

@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
@Description(value="Generates kubernetes manifests.")
@SupportedAnnotationTypes(value={"io.dekorate.openshift.annotation.OpenshiftApplication"})
public class WildFlyDefaultsOpenshiftAnnotationProcessor
extends WildFlyDefaultsAbstractAnnotationProcessor {
    Class<OpenshiftApplication> getAnnotationClass() {
        return OpenshiftApplication.class;
    }

    @Override
    Port[] getPorts(Element mainClass) {
        return mainClass.getAnnotation(this.getAnnotationClass()).ports();
    }

    @Override
    String getEnvVarPrefix() {
        return "dekorate.openshift.";
    }

    @Override
    String getPortPrefix() {
        return "dekorate.openshift.";
    }

    @Override
    void addAddtionalProperties(Map<String, Object> inputProperties, S2iBuild s2iBuild) {
        String dockerGroup = this.getBlankPropertyAsNull("dekorate.docker.group");
        if (dockerGroup != null) {
            inputProperties.put("dekorate.docker.group", dockerGroup);
        }
    }

    private String getBlankPropertyAsNull(String propertyName) {
        String value = System.getProperty("dekorate.docker.group");
        if (value == null || value.isBlank()) {
            return null;
        }
        return value;
    }
}

