/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.format;

abstract class Flags<E extends Enum<E>, This extends Flags<E, This>> {
    final int bits;

    Flags(int bits) {
        this.bits = bits;
    }

    abstract This[] values();

    abstract This this_();

    static int bitOf(Enum<?> item) {
        return 1 << item.ordinal();
    }

    public final boolean contains(E flag) {
        return flag != null && (this.bits & Flags.bitOf(flag)) != 0;
    }

    public final boolean containsAny(This flags) {
        return flags != null && (this.bits & ((Flags)flags).bits) != 0;
    }

    public final boolean containsAny(E flag1, E flag2) {
        return this.contains(flag1) || this.contains(flag2);
    }

    public final boolean containsAny(E flag1, E flag2, E flag3) {
        return this.contains(flag1) || this.contains(flag2) || this.contains(flag3);
    }

    public final This complement() {
        Flags[] values = this.values();
        return (This)values[~this.bits & values.length - 1];
    }

    public final This with(E flag) {
        return (This)(flag == null ? this.this_() : this.values()[this.bits | Flags.bitOf(flag)]);
    }

    public final This without(E flag) {
        return (This)(flag == null ? this.this_() : this.values()[this.bits & ~Flags.bitOf(flag)]);
    }

    public final void forbidAll() {
        if (this.bits != 0) {
            throw Flags.notAllowed(this);
        }
    }

    public final void forbidAllBut(E flag) {
        ((Flags)this.without(flag)).forbidAll();
    }

    private static IllegalArgumentException notAllowed(Flags<?, ?> flags) {
        return new IllegalArgumentException("Flags " + flags + " not allowed here");
    }

    public void forbid(E flag) {
        if (this.contains(flag)) {
            throw Flags.notAllowed(this.values()[0].with(flag));
        }
    }
}

