/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.PatchRepository;
import org.wildfly.extras.patch.PatchSet;
import org.wildfly.extras.patch.SmartPatch;
import org.wildfly.extras.patch.internal.Lock;
import org.wildfly.extras.patch.internal.Parser;
import org.wildfly.extras.patch.internal.PatchLogger;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;
import org.wildfly.extras.patch.utils.IllegalStateAssertion;
import org.wildfly.extras.patch.utils.PatchAssertion;

final class DefaultPatchRepository
implements PatchRepository {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPatchRepository.class);
    private final Path rootPath;

    DefaultPatchRepository(URL repoUrl) {
        if (repoUrl == null) {
            repoUrl = DefaultPatchRepository.getConfiguredUrl();
        }
        IllegalStateAssertion.assertNotNull(repoUrl, "Cannot obtain repository URL");
        Path path = Paths.get(repoUrl.getPath(), new String[0]);
        PatchAssertion.assertTrue(path.toFile().isDirectory(), "Repository root does not exist: " + path);
        LOG.debug("Repository location: {}", (Object)path);
        this.rootPath = path.toAbsolutePath();
    }

    @Override
    public List<PatchId> queryAvailable(String prefix) {
        Lock.tryLock();
        try {
            List<PatchId> list = Parser.getAvailable(this.rootPath, prefix, false);
            return list;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PatchId getLatestAvailable(String prefix) {
        IllegalArgumentAssertion.assertNotNull(prefix, "prefix");
        Lock.tryLock();
        try {
            List<PatchId> list = Parser.getAvailable(this.rootPath, prefix, true);
            PatchId patchId = list.isEmpty() ? null : list.get(0);
            return patchId;
        }
        finally {
            Lock.unlock();
        }
    }

    @Override
    public PatchSet getPatchSet(PatchId patchId) {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        Lock.tryLock();
        try {
            PatchSet patchSet = Parser.readPatchSet(this.rootPath, patchId);
            return patchSet;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            Lock.unlock();
        }
    }

    @Override
    public PatchId addArchive(URL fileUrl) throws IOException {
        return this.addArchive(fileUrl, null, Collections.emptySet());
    }

    @Override
    public PatchId addArchive(URL fileUrl, PatchId oneoffId) throws IOException {
        return this.addArchive(fileUrl, oneoffId, Collections.emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public PatchId addArchive(URL fileUrl, PatchId oneoffId, Set<PatchId> dependencies) throws IOException {
        IllegalArgumentAssertion.assertNotNull(fileUrl, "fileUrl");
        IllegalArgumentAssertion.assertTrue(fileUrl.getPath().endsWith(".zip"), "Unsupported file extension: " + fileUrl);
        Lock.tryLock();
        try {
            void var10_20;
            PatchSet patchSet;
            Path sourcePath = Paths.get(fileUrl.getPath(), new String[0]);
            PatchId patchId = PatchId.fromFile(sourcePath.toFile());
            PatchAssertion.assertFalse(this.queryAvailable(null).contains(patchId), "Repository already contains " + patchId);
            if (oneoffId != null) {
                File metadataFile = Parser.getMetadataFile(this.rootPath, oneoffId);
                PatchAssertion.assertTrue(metadataFile.isFile(), "Cannot obtain target patch for: " + oneoffId);
            }
            HashMap<Path, PatchId> pathMap = new HashMap<Path, PatchId>();
            for (PatchId auxid : Parser.getAvailable(this.rootPath, null, false)) {
                if (patchId.getName().equals(auxid.getName())) continue;
                for (PatchSet.Record record : this.getPatchSet(auxid).getRecords()) {
                    pathMap.put(record.getPath(), auxid);
                }
            }
            if (oneoffId != null) {
                PatchSet oneoffSet = this.getPatchSet(oneoffId);
                HashMap<Path, PatchSet.Record> records = new HashMap<Path, PatchSet.Record>();
                for (PatchSet.Record record : oneoffSet.getRecords()) {
                    records.put(record.getPath(), record);
                }
                PatchSet patchSet2 = Parser.buildPatchSetFromZip(patchId, PatchSet.Action.INFO, sourcePath.toFile());
                for (PatchSet.Record rec : patchSet2.getRecords()) {
                    records.put(rec.getPath(), rec);
                }
                LinkedHashSet<PatchId> linkedHashSet = new LinkedHashSet<PatchId>(dependencies);
                linkedHashSet.add(oneoffId);
                patchSet = PatchSet.create(patchId, records.values(), linkedHashSet);
            } else {
                PatchSet sourceSet = Parser.buildPatchSetFromZip(patchId, PatchSet.Action.INFO, sourcePath.toFile());
                patchSet = PatchSet.create(patchId, sourceSet.getRecords(), dependencies);
            }
            HashSet<PatchId> duplicates = new HashSet<PatchId>();
            for (PatchSet.Record record : patchSet.getRecords()) {
                PatchId patchId2 = (PatchId)pathMap.get(record.getPath());
                if (patchId2 == null) continue;
                PatchLogger.error("Path '" + record.getPath() + "' already contained in: " + patchId2);
                duplicates.add(patchId2);
            }
            PatchAssertion.assertTrue(duplicates.isEmpty(), "Cannot add " + patchId + " because of duplicate paths in " + duplicates);
            File targetFile = this.getPatchFile(patchId);
            targetFile.getParentFile().mkdirs();
            Files.copy(sourcePath, targetFile.toPath(), new CopyOption[0]);
            Parser.writePatchSet(this.rootPath, patchSet);
            if (sourcePath.startsWith(this.rootPath)) {
                sourcePath.toFile().delete();
            }
            String string = "Added " + patchId;
            if (oneoffId != null) {
                String string2 = string + " patching " + oneoffId;
            }
            if (!dependencies.isEmpty()) {
                void var10_18;
                String string3 = (String)var10_18 + " with dependencies on " + dependencies;
            }
            PatchLogger.info((String)var10_20);
            PatchId patchId3 = patchId;
            return patchId3;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPostCommand(PatchId patchId, String[] cmdarr) {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        IllegalArgumentAssertion.assertNotNull(cmdarr, "cmdarr");
        Lock.tryLock();
        try {
            PatchSet patchSet = this.getPatchSet(patchId);
            ArrayList<String> commands = new ArrayList<String>(patchSet.getPostCommands());
            commands.add(this.commandString(cmdarr));
            patchSet = PatchSet.create(patchId, patchSet.getRecords(), commands);
            try {
                Parser.writePatchSet(this.rootPath, patchSet);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
            PatchLogger.info("Added post install command to " + patchId);
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SmartPatch getSmartPatch(PatchSet seedPatch, PatchId patchId) {
        Lock.tryLock();
        try {
            if (patchId == null) {
                IllegalArgumentAssertion.assertNotNull(seedPatch, "seedPatch");
                patchId = this.getLatestAvailable(seedPatch.getPatchId().getName());
            }
            File zipfile = this.getPatchFile(patchId);
            PatchAssertion.assertTrue(zipfile.isFile(), "Cannot obtain patch file: " + zipfile);
            PatchSet targetSet = this.getPatchSet(patchId);
            PatchSet smartSet = PatchSet.smartSet(seedPatch, targetSet);
            SmartPatch smartPatch = new SmartPatch(smartSet, zipfile);
            return smartPatch;
        }
        finally {
            Lock.unlock();
        }
    }

    static URL getConfiguredUrl() {
        String repoSpec = System.getProperty("fusepatch.repository");
        if (repoSpec == null) {
            repoSpec = System.getenv("FUSEPATCH_REPOSITORY");
        }
        if (repoSpec != null) {
            try {
                return new URL(repoSpec);
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return null;
    }

    private String commandString(String[] cmdarr) {
        StringBuffer result = new StringBuffer();
        for (String tok : cmdarr) {
            result.append(tok + " ");
        }
        return result.toString().trim();
    }

    private File getPatchFile(PatchId patchId) {
        return this.rootPath.resolve(Paths.get(patchId.getName(), patchId.getVersion().toString(), patchId + ".zip")).toFile();
    }
}

