/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.PatchSet;
import org.wildfly.extras.patch.ServerInstance;
import org.wildfly.extras.patch.SmartPatch;
import org.wildfly.extras.patch.internal.Lock;
import org.wildfly.extras.patch.internal.Parser;
import org.wildfly.extras.patch.internal.PatchLogger;
import org.wildfly.extras.patch.utils.IOUtils;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;
import org.wildfly.extras.patch.utils.IllegalStateAssertion;
import org.wildfly.extras.patch.utils.PatchAssertion;

final class WildFlyServerInstance
implements ServerInstance {
    private static final Logger LOG = LoggerFactory.getLogger(WildFlyServerInstance.class);
    private final Path homePath;

    WildFlyServerInstance(Path homePath) {
        if (homePath == null) {
            homePath = WildFlyServerInstance.getConfiguredHomePath();
        }
        IllegalStateAssertion.assertNotNull(homePath, "Cannot obtain JBOSS_HOME");
        IllegalStateAssertion.assertTrue(homePath.toFile().isDirectory(), "Directory JBOSS_HOME does not exist: " + homePath);
        this.homePath = homePath.toAbsolutePath();
    }

    @Override
    public Path getDefaultRepositoryPath() {
        return this.homePath.resolve(Paths.get("fusepatch", "repository"));
    }

    @Override
    public Path getServerHome() {
        return this.homePath;
    }

    @Override
    public List<PatchId> queryAppliedPatches() {
        Lock.tryLock();
        try {
            List<PatchId> list = Parser.getAvailable(this.getWorkspace(), null, true);
            return list;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PatchSet getPatchSet(String prefix) {
        IllegalArgumentAssertion.assertNotNull(prefix, "prefix");
        Lock.tryLock();
        try {
            List<PatchId> list = Parser.getAvailable(this.getWorkspace(), prefix, true);
            PatchSet patchSet = list.isEmpty() ? null : this.getPatchSet(list.get(0));
            return patchSet;
        }
        finally {
            Lock.unlock();
        }
    }

    @Override
    public List<String> getAuditLog() {
        Lock.tryLock();
        try {
            List<String> list = Parser.readAuditLog(this.getWorkspace());
            return list;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            Lock.unlock();
        }
    }

    @Override
    public PatchSet getPatchSet(PatchId patchId) {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        Lock.tryLock();
        try {
            PatchSet patchSet = Parser.readPatchSet(this.getWorkspace(), patchId);
            return patchSet;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PatchSet applySmartPatch(SmartPatch smartPatch, boolean force) throws IOException {
        IllegalArgumentAssertion.assertNotNull(smartPatch, "smartPatch");
        if (smartPatch.getRecords().isEmpty()) {
            PatchLogger.warn("Patch " + smartPatch.getPatchId() + " has already been applied");
            return null;
        }
        Lock.tryLock();
        try {
            PatchId serverId;
            Path path;
            List<PatchId> appliedPatches = this.queryAppliedPatches();
            ArrayList<PatchId> unsatisfied = new ArrayList<PatchId>();
            for (PatchId depId : smartPatch.getDependencies()) {
                if (appliedPatches.contains(depId)) continue;
                unsatisfied.add(depId);
            }
            PatchAssertion.assertTrue(unsatisfied.isEmpty(), "Unsatisfied dependencies: " + unsatisfied);
            PatchId patchId = smartPatch.getPatchId();
            PatchSet serverSet = this.getPatchSet(patchId.getName());
            HashMap<Path, PatchSet.Record> serverRecords = new HashMap<Path, PatchSet.Record>();
            if (serverSet != null) {
                for (PatchSet.Record record : serverSet.getRecords()) {
                    serverRecords.put(record.getPath(), record);
                }
            }
            for (PatchSet.Record record : smartPatch.getRemoveSet()) {
                path = this.getServerHome().resolve(record.getPath());
                if (!path.toFile().exists()) {
                    PatchLogger.warn("Attempt to delete a non existing file " + record.getPath());
                }
                serverRecords.remove(record.getPath());
            }
            for (PatchSet.Record record : smartPatch.getReplaceSet()) {
                Long wasCheck;
                PatchSet.Record exprec;
                Long expcheck;
                path = this.getServerHome().resolve(record.getPath());
                String filename = path.getFileName().toString();
                if (!path.toFile().exists()) {
                    PatchLogger.warn("Attempt to replace a non existing file " + record.getPath());
                } else if ((filename.endsWith(".xml") || filename.endsWith(".properties")) && !(expcheck = Long.valueOf((exprec = (PatchSet.Record)serverRecords.get(record.getPath())) != null ? exprec.getChecksum() : 0L)).equals(wasCheck = Long.valueOf(IOUtils.getCRC32(path)))) {
                    PatchAssertion.assertTrue(force, "Attempt to override an already modified file " + record.getPath());
                    PatchLogger.warn("Overriding an already modified file " + record.getPath());
                }
                serverRecords.put(record.getPath(), record);
            }
            for (PatchSet.Record record : smartPatch.getAddSet()) {
                Long wasCheck;
                Long expcheck;
                path = this.getServerHome().resolve(record.getPath());
                if (path.toFile().exists() && !(expcheck = record.getChecksum()).equals(wasCheck = Long.valueOf(IOUtils.getCRC32(path)))) {
                    PatchAssertion.assertTrue(force, "Attempt to add an already existing file " + record.getPath());
                    PatchLogger.warn("Overriding an already existing file " + record.getPath());
                }
                serverRecords.put(record.getPath(), record);
            }
            this.updateServerFiles(smartPatch);
            HashSet<PatchSet.Record> inforecs = new HashSet<PatchSet.Record>();
            for (PatchSet.Record rec : serverRecords.values()) {
                inforecs.add(PatchSet.Record.create(rec.getPath(), rec.getChecksum()));
            }
            PatchSet patchSet = PatchSet.create(patchId, inforecs);
            Parser.writePatchSet(this.getWorkspace(), patchSet);
            String message = serverSet == null ? "Installed " + patchId : ((serverId = serverSet.getPatchId()).compareTo(patchId) < 0 ? "Upgraded from " + serverId + " to " + patchId : (serverId.compareTo(patchId) == 0 ? "Reinstalled " + patchId : "Downgraded from " + serverId + " to " + patchId));
            PatchLogger.info(message);
            Parser.writeAuditLog(this.getWorkspace(), message, smartPatch);
            Runtime runtime = Runtime.getRuntime();
            File procdir = this.homePath.toFile();
            for (String cmd : smartPatch.getPostCommands()) {
                PatchLogger.info("Run: " + cmd);
                String[] envarr = new String[]{};
                String[] cmdarr = cmd.split("\\s");
                Process proc = runtime.exec(cmdarr, envarr, procdir);
                try {
                    this.startStreaming(proc.getInputStream(), System.out);
                    this.startStreaming(proc.getErrorStream(), System.err);
                    if (proc.waitFor() == 0) continue;
                    LOG.error("Command did not terminate normally: " + cmd);
                    break;
                }
                catch (InterruptedException ex) {
                }
            }
            PatchSet patchSet2 = patchSet;
            return patchSet2;
        }
        finally {
            Lock.unlock();
        }
    }

    private Thread startStreaming(final InputStream input, final OutputStream output) {
        Thread thread = new Thread("io"){

            @Override
            public void run() {
                try {
                    IOUtils.copy(input, output);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        thread.start();
        return thread;
    }

    private void updateServerFiles(SmartPatch smartPatch) throws IOException {
        HashSet<Path> addupdPaths = new HashSet<Path>();
        for (PatchSet.Record rec : smartPatch.getAddSet()) {
            addupdPaths.add(rec.getPath());
        }
        for (PatchSet.Record rec : smartPatch.getReplaceSet()) {
            addupdPaths.add(rec.getPath());
        }
        File patchFile = smartPatch.getPatchFile();
        try (Object zip = new ZipInputStream(new FileInputStream(patchFile));){
            ZipEntry entry = ((ZipInputStream)zip).getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    Path path = Paths.get(entry.getName(), new String[0]);
                    addupdPaths.remove(path);
                }
                entry = ((ZipInputStream)zip).getNextEntry();
            }
        }
        IllegalStateAssertion.assertTrue(addupdPaths.isEmpty(), "Patch file does not contain expected paths: " + addupdPaths);
        for (PatchSet.Record rec : smartPatch.getRemoveSet()) {
            Path path = this.getServerHome().resolve(rec.getPath());
            Files.deleteIfExists(path);
        }
        zip = new ZipInputStream(new FileInputStream(patchFile));
        var5_5 = null;
        try {
            byte[] buffer = new byte[1024];
            ZipEntry entry = ((ZipInputStream)zip).getNextEntry();
            while (entry != null) {
                Path path;
                if (!entry.isDirectory() && (smartPatch.isReplacePath(path = Paths.get(entry.getName(), new String[0])) || smartPatch.isAddPath(path))) {
                    File file = this.homePath.resolve(path).toFile();
                    file.getParentFile().mkdirs();
                    try (FileOutputStream fos = new FileOutputStream(file);){
                        int read = ((FilterInputStream)zip).read(buffer);
                        while (read > 0) {
                            fos.write(buffer, 0, read);
                            read = ((FilterInputStream)zip).read(buffer);
                        }
                    }
                    if (file.getName().endsWith(".sh") || file.getName().endsWith(".bat")) {
                        file.setExecutable(true);
                    }
                }
                entry = ((ZipInputStream)zip).getNextEntry();
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (zip != null) {
                if (var5_5 != null) {
                    try {
                        ((ZipInputStream)zip).close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    ((ZipInputStream)zip).close();
                }
            }
        }
    }

    private Path getWorkspace() {
        return this.homePath.resolve(Paths.get("fusepatch", "workspace"));
    }

    static Path getConfiguredHomePath() {
        String jbossHome = System.getProperty("jboss.home");
        if (jbossHome == null) {
            jbossHome = System.getProperty("jboss.home.dir");
        }
        if (jbossHome == null) {
            jbossHome = System.getenv("JBOSS_HOME");
        }
        return jbossHome != null ? Paths.get(jbossHome, new String[0]) : null;
    }
}

