/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extras.patch.ManagedPath;
import org.wildfly.extras.patch.ManagedPaths;
import org.wildfly.extras.patch.Patch;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.PatchMetadata;
import org.wildfly.extras.patch.PatchMetadataBuilder;
import org.wildfly.extras.patch.Record;
import org.wildfly.extras.patch.Server;
import org.wildfly.extras.patch.SmartPatch;
import org.wildfly.extras.patch.internal.MetadataParser;
import org.wildfly.extras.patch.utils.IOUtils;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;
import org.wildfly.extras.patch.utils.IllegalStateAssertion;
import org.wildfly.extras.patch.utils.PatchAssertion;

public abstract class AbstractServer
implements Server {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractServer.class);
    private static final String AUDIT_LOG = "audit.log";
    private final Lock lock;
    private final Path homePath;

    public AbstractServer(Lock lock, Path homePath) {
        IllegalArgumentAssertion.assertNotNull(lock, "lock");
        IllegalArgumentAssertion.assertNotNull(homePath, "homePath");
        this.homePath = homePath.toAbsolutePath();
        this.lock = lock;
    }

    @Override
    public Path getServerHome() {
        return this.homePath;
    }

    @Override
    public List<PatchId> queryAppliedPatches() {
        this.lock.tryLock();
        try {
            List<PatchId> list = MetadataParser.queryAvailablePatches(this.getWorkspace(), null, true);
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<ManagedPath> queryManagedPaths(String pattern) {
        this.lock.tryLock();
        try {
            List<ManagedPath> list = this.queryManagedPaths(this.getWorkspace(), pattern);
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Patch getPatch(String prefix) {
        IllegalArgumentAssertion.assertNotNull(prefix, "prefix");
        this.lock.tryLock();
        try {
            List<PatchId> list = MetadataParser.queryAvailablePatches(this.getWorkspace(), prefix, true);
            Patch patch = list.isEmpty() ? null : this.getPatch(list.get(0));
            return patch;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<String> getAuditLog() {
        this.lock.tryLock();
        try {
            List<String> list = this.readAuditLog(this.getWorkspace());
            return list;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Patch getPatch(PatchId patchId) {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        this.lock.tryLock();
        try {
            Patch patch = MetadataParser.readPatch(this.getWorkspace(), patchId);
            return patch;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Patch applySmartPatch(SmartPatch smartPatch, boolean force) throws IOException {
        IllegalArgumentAssertion.assertNotNull(smartPatch, "smartPatch");
        this.lock.tryLock();
        try {
            Patch result;
            Object path;
            if (smartPatch.getRecords().isEmpty()) {
                LOG.warn("Patch {} has already been applied", (Object)smartPatch.getPatchId());
                Patch patch = null;
                return patch;
            }
            List<PatchId> appliedPatches = this.queryAppliedPatches();
            ArrayList<PatchId> unsatisfied = new ArrayList<PatchId>();
            for (PatchId depId : smartPatch.getMetadata().getDependencies()) {
                if (appliedPatches.contains(depId)) continue;
                unsatisfied.add(depId);
            }
            PatchAssertion.assertTrue(unsatisfied.isEmpty(), "Unsatisfied dependencies: " + unsatisfied);
            PatchId patchId = smartPatch.getPatchId();
            Patch serverSet = this.getPatch(patchId.getName());
            PatchId serverId = serverSet != null ? serverSet.getPatchId() : null;
            HashMap<Path, Record> serverRecords = new HashMap<Path, Record>();
            if (serverSet != null) {
                for (Record record : serverSet.getRecords()) {
                    serverRecords.put(record.getPath(), record);
                }
            }
            String message = serverId == null ? "Install " + patchId : (serverId.compareTo(patchId) < 0 ? "Upgrade from " + serverId + " to " + patchId : (serverId.compareTo(patchId) == 0 ? (smartPatch.isUninstall() ? "Uninstall " + patchId : "Reinstall " + patchId) : "Downgrade from " + serverId + " to " + patchId));
            LOG.info(message);
            for (Record rec : smartPatch.getRemoveSet()) {
                path = this.homePath.resolve(rec.getPath());
                if (!path.toFile().exists()) {
                    LOG.warn("Attempt to delete a non existing file: {}", (Object)rec.getPath());
                }
                serverRecords.remove(rec.getPath());
            }
            for (Record rec : smartPatch.getReplaceSet()) {
                Long wasCheck;
                Record exprec;
                Long expcheck;
                path = this.homePath.resolve(rec.getPath());
                String string = path.getFileName().toString();
                if (!path.toFile().exists()) {
                    LOG.warn("Attempt to replace a non existing file: {}", (Object)rec.getPath());
                } else if ((string.endsWith(".xml") || string.endsWith(".properties")) && !(expcheck = Long.valueOf((exprec = (Record)serverRecords.get(rec.getPath())) != null ? exprec.getChecksum() : 0L)).equals(wasCheck = Long.valueOf(IOUtils.getCRC32((Path)path)))) {
                    PatchAssertion.assertTrue(force, "Attempt to override an already modified file " + rec.getPath());
                    LOG.warn("Overriding an already modified file: {}", (Object)rec.getPath());
                }
                serverRecords.put(rec.getPath(), rec);
            }
            for (Record rec : smartPatch.getAddSet()) {
                Long wasCheck;
                Long l;
                path = this.homePath.resolve(rec.getPath());
                if (path.toFile().exists() && !(l = rec.getChecksum()).equals(wasCheck = Long.valueOf(IOUtils.getCRC32((Path)path)))) {
                    PatchAssertion.assertTrue(force, "Attempt to add an already existing file " + rec.getPath());
                    LOG.warn("Overriding an already existing file: {}", (Object)rec.getPath());
                }
                serverRecords.put(rec.getPath(), rec);
            }
            ManagedPaths managedPaths = this.readManagedPaths(this.getWorkspace());
            managedPaths.updatePaths(this.homePath, smartPatch, Record.Action.ADD, Record.Action.UPD);
            this.updateServerFiles(smartPatch, managedPaths);
            managedPaths.updatePaths(this.homePath, smartPatch, Record.Action.DEL);
            this.writeManagedPaths(this.getWorkspace(), managedPaths);
            if (!smartPatch.isUninstall()) {
                if (serverId != null && serverId.compareTo(patchId) > 0) {
                    for (PatchId patchId2 : MetadataParser.queryAvailablePatches(this.getWorkspace(), patchId.getName(), false)) {
                        if (patchId2.compareTo(patchId) <= 0) continue;
                        File packageDir = MetadataParser.getMetadataDirectory(this.getWorkspace(), patchId2).getParentFile();
                        IOUtils.rmdirs(packageDir.toPath());
                    }
                }
                HashSet<Record> records = new HashSet<Record>();
                for (Record rec : serverRecords.values()) {
                    records.add(Record.create(rec.getPath(), rec.getChecksum()));
                }
                result = Patch.create(smartPatch.getMetadata(), records);
                MetadataParser.writePatch(this.getWorkspace(), result);
            } else {
                result = Patch.create(smartPatch.getMetadata(), smartPatch.getRecords());
                File packageDir = MetadataParser.getMetadataDirectory(this.getWorkspace(), patchId).getParentFile();
                IOUtils.rmdirs(packageDir.toPath());
            }
            this.writeAuditLog(this.getWorkspace(), message, smartPatch);
            if (!smartPatch.isUninstall()) {
                Runtime runtime = Runtime.getRuntime();
                File file = this.homePath.toFile();
                for (String cmd : smartPatch.getMetadata().getPostCommands()) {
                    LOG.info("Run: {}", (Object)cmd);
                    String[] cmdarr = cmd.split("\\s");
                    Process proc = runtime.exec(cmdarr, null, file);
                    try {
                        this.startStreaming(proc.getInputStream(), System.out);
                        this.startStreaming(proc.getErrorStream(), System.err);
                        if (proc.waitFor() == 0) continue;
                        LOG.error("Command did not terminate normally: {}" + cmd);
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
            Patch patch = result;
            return patch;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Thread startStreaming(final InputStream input, final OutputStream output) {
        Thread thread = new Thread("io"){

            @Override
            public void run() {
                try {
                    IOUtils.copy(input, output);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        thread.start();
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateServerFiles(SmartPatch smartPatch, ManagedPaths managedPaths) throws IOException {
        block63: {
            File tmpFile = Files.createTempFile(this.getWorkspace(), "smartpatch", ".zip", new FileAttribute[0]).toFile();
            try {
                Object zip;
                HashSet<Path> addupdPaths = new HashSet<Path>();
                for (Record throwable : smartPatch.getAddSet()) {
                    addupdPaths.add(throwable.getPath());
                }
                for (Record record : smartPatch.getReplaceSet()) {
                    addupdPaths.add(record.getPath());
                }
                if (!smartPatch.isUninstall()) {
                    Throwable throwable = null;
                    try (FileOutputStream output = new FileOutputStream(tmpFile);){
                        InputStream input = smartPatch.getDataHandler().getInputStream();
                        IOUtils.copy(input, output);
                    }
                    catch (Throwable input) {
                        Throwable throwable2 = input;
                        throw input;
                    }
                    zip = new ZipInputStream(new FileInputStream(tmpFile));
                    Throwable throwable3 = null;
                    try {
                        ZipEntry entry = ((ZipInputStream)zip).getNextEntry();
                        while (entry != null) {
                            if (!entry.isDirectory()) {
                                Path path = Paths.get(entry.getName(), new String[0]);
                                addupdPaths.remove(path);
                            }
                            entry = ((ZipInputStream)zip).getNextEntry();
                        }
                    }
                    catch (Throwable entry) {
                        Throwable throwable4 = entry;
                        throw entry;
                    }
                    finally {
                        if (zip != null) {
                            if (throwable3 != null) {
                                try {
                                    ((ZipInputStream)zip).close();
                                }
                                catch (Throwable entry) {
                                    throwable3.addSuppressed(entry);
                                }
                            } else {
                                ((ZipInputStream)zip).close();
                            }
                        }
                    }
                }
                IllegalStateAssertion.assertTrue(addupdPaths.isEmpty(), "Patch file does not contain expected paths: " + addupdPaths);
                for (Record record : smartPatch.getRemoveSet()) {
                    Path path = record.getPath();
                    this.removeServerFile(managedPaths, path);
                }
                if (smartPatch.isUninstall()) break block63;
                zip = new ZipInputStream(new FileInputStream(tmpFile));
                Throwable throwable = null;
                try {
                    byte[] buffer = new byte[1024];
                    ZipEntry entry = ((ZipInputStream)zip).getNextEntry();
                    while (entry != null) {
                        Path path;
                        if (!entry.isDirectory() && (smartPatch.isReplacePath(path = Paths.get(entry.getName(), new String[0])) || smartPatch.isAddPath(path))) {
                            File file = this.homePath.resolve(path).toFile();
                            file.getParentFile().mkdirs();
                            try (FileOutputStream fos = new FileOutputStream(file);){
                                int read = ((FilterInputStream)zip).read(buffer);
                                while (read > 0) {
                                    fos.write(buffer, 0, read);
                                    read = ((FilterInputStream)zip).read(buffer);
                                }
                            }
                            if (file.getName().endsWith(".sh") || file.getName().endsWith(".bat")) {
                                file.setExecutable(true);
                            }
                        }
                        entry = ((ZipInputStream)zip).getNextEntry();
                    }
                }
                catch (Throwable throwable5) {
                    Throwable throwable6 = throwable5;
                    throw throwable5;
                }
                finally {
                    if (zip != null) {
                        if (throwable != null) {
                            try {
                                ((ZipInputStream)zip).close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            ((ZipInputStream)zip).close();
                        }
                    }
                }
            }
            finally {
                tmpFile.delete();
            }
        }
    }

    private void removeServerFile(ManagedPaths managedPaths, Path path) throws IOException {
        File dir;
        Path parent;
        ManagedPath managedPath = managedPaths.getManagedPath(path);
        List<PatchId> owners = managedPath.getOwners();
        if (!owners.contains(Server.SERVER_ID)) {
            Files.deleteIfExists(this.homePath.resolve(path));
        }
        if ((parent = path.getParent()) != null && managedPaths.getManagedPath(parent) != null && (dir = this.homePath.resolve(parent).toFile()).isDirectory() && dir.list().length == 0) {
            this.removeServerFile(managedPaths, parent);
        }
    }

    private Path getWorkspace() {
        Path path = this.homePath.resolve(Paths.get("fusepatch", "workspace"));
        path.toFile().mkdirs();
        return path;
    }

    private List<ManagedPath> queryManagedPaths(Path rootPath, String pattern) {
        try {
            ArrayList<ManagedPath> result = new ArrayList<ManagedPath>();
            ManagedPaths mpaths = this.readManagedPaths(rootPath);
            for (ManagedPath aux : mpaths.getManagedPaths()) {
                String path = aux.getPath().toString();
                if (pattern != null && !path.startsWith(pattern)) continue;
                result.add(aux);
            }
            return Collections.unmodifiableList(result);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private ManagedPaths readManagedPaths(Path rootPath) throws IOException {
        IllegalArgumentAssertion.assertNotNull(rootPath, "rootPath");
        ArrayList<ManagedPath> managedPaths = new ArrayList<ManagedPath>();
        File metadataFile = rootPath.resolve("managed-paths.metadata").toFile();
        if (metadataFile.exists()) {
            try (BufferedReader br = new BufferedReader(new FileReader(metadataFile));){
                String line = br.readLine();
                while (line != null) {
                    managedPaths.add(ManagedPath.fromString(line));
                    line = br.readLine();
                }
            }
        }
        return new ManagedPaths(managedPaths);
    }

    private void writeManagedPaths(Path rootPath, ManagedPaths managedPaths) throws IOException {
        IllegalArgumentAssertion.assertNotNull(rootPath, "rootPath");
        IllegalArgumentAssertion.assertNotNull(managedPaths, "managedPaths");
        File metadataFile = rootPath.resolve("managed-paths.metadata").toFile();
        metadataFile.getParentFile().mkdirs();
        try (PrintWriter pw = new PrintWriter(new FileWriter(metadataFile));){
            for (ManagedPath path : managedPaths.getManagedPaths()) {
                pw.println(path.toString());
            }
        }
    }

    private void writeAuditLog(Path rootPath, String message, SmartPatch smartPatch) throws IOException {
        IllegalArgumentAssertion.assertNotNull(rootPath, "rootPath");
        IllegalArgumentAssertion.assertNotNull(message, "message");
        IllegalArgumentAssertion.assertNotNull(smartPatch, "smartPatch");
        try (FileOutputStream fos = new FileOutputStream(rootPath.resolve(AUDIT_LOG).toFile(), true);){
            PrintStream pw = new PrintStream(fos);
            pw.println();
            String date = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").format(new Date());
            pw.println("# " + date);
            pw.println("# " + message);
            PatchId patchId = smartPatch.getPatchId();
            List<String> postCommands = smartPatch.getMetadata().getPostCommands();
            PatchMetadata metadata = new PatchMetadataBuilder().patchId(patchId).postCommands(postCommands).build();
            Patch patch = Patch.create(metadata, smartPatch.getRecords());
            MetadataParser.writePatch(patch, fos, false);
        }
    }

    private List<String> readAuditLog(Path rootPath) throws IOException {
        IllegalArgumentAssertion.assertNotNull(rootPath, "rootPath");
        ArrayList<String> lines = new ArrayList<String>();
        File auditFile = rootPath.resolve(AUDIT_LOG).toFile();
        if (auditFile.exists()) {
            try (BufferedReader br = new BufferedReader(new FileReader(auditFile));){
                String line = br.readLine();
                while (line != null) {
                    lines.add(line);
                    line = br.readLine();
                }
            }
        }
        return Collections.unmodifiableList(lines);
    }
}

