/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.PatchMetadata;
import org.wildfly.extras.patch.Record;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;

public final class Patch {
    private final PatchMetadata metadata;
    private final Map<Path, Record> recordsMap = new LinkedHashMap<Path, Record>();
    private int hashCache;

    public static Patch create(PatchMetadata metadata, Collection<Record> records) {
        return new Patch(metadata, records);
    }

    public static Patch smartDelta(Patch seedPatch, Patch targetSet) {
        IllegalArgumentAssertion.assertNotNull(targetSet, "targetSet");
        HashMap<Path, Record> removeMap = new HashMap<Path, Record>();
        if (seedPatch != null) {
            for (Record rec : seedPatch.getRecords()) {
                removeMap.put(rec.getPath(), Record.create(null, Record.Action.DEL, rec.getPath(), rec.getChecksum()));
            }
        }
        HashSet<Record> records = new HashSet<Record>();
        for (Record rec : targetSet.getRecords()) {
            Path path = rec.getPath();
            Long checksum = rec.getChecksum();
            if (removeMap.containsValue(rec)) {
                removeMap.remove(path);
                continue;
            }
            if (removeMap.containsKey(path)) {
                records.add(Record.create(null, Record.Action.UPD, path, checksum));
                removeMap.remove(path);
                continue;
            }
            records.add(Record.create(null, Record.Action.ADD, path, checksum));
        }
        records.addAll(removeMap.values());
        return new Patch(targetSet.metadata, records);
    }

    private Patch(PatchMetadata metadata, Collection<Record> records) {
        IllegalArgumentAssertion.assertNotNull(metadata, "metadata");
        IllegalArgumentAssertion.assertNotNull(records, "records");
        this.metadata = metadata;
        HashMap<Path, Record> auxmap = new HashMap<Path, Record>();
        for (Record aux : records) {
            auxmap.put(aux.getPath(), Record.create(metadata.getPatchId(), aux.getAction(), aux.getPath(), aux.getChecksum()));
        }
        ArrayList paths = new ArrayList(auxmap.keySet());
        Collections.sort(paths);
        for (Path path : paths) {
            this.recordsMap.put(path, (Record)auxmap.get(path));
        }
    }

    public PatchMetadata getMetadata() {
        return this.metadata;
    }

    public PatchId getPatchId() {
        return this.metadata.getPatchId();
    }

    public List<Record> getRecords() {
        return Collections.unmodifiableList(new ArrayList<Record>(this.recordsMap.values()));
    }

    public boolean containsPath(Path path) {
        return this.recordsMap.containsKey(path);
    }

    public Record getRecord(Path path) {
        return this.recordsMap.get(path);
    }

    public int hashCode() {
        if (this.hashCache == 0) {
            this.hashCache = ("" + this.metadata + this.recordsMap).hashCode();
        }
        return this.hashCache;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Patch)) {
            return false;
        }
        Patch other = (Patch)obj;
        boolean result = this.metadata.equals(other.metadata);
        return result &= this.recordsMap.equals(other.recordsMap);
    }

    public String toString() {
        return "Patch[" + this.metadata + ",recs=" + this.recordsMap.size() + "]";
    }
}

