/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;

public final class PatchMetadata {
    private final PatchId patchId;
    private final PatchId oneoffId;
    private final Set<String> roles = new LinkedHashSet<String>();
    private final Set<PatchId> dependencies = new LinkedHashSet<PatchId>();
    private final List<String> commands = new ArrayList<String>();
    private final String stringCache;

    PatchMetadata(PatchId patchId, Set<String> roles, PatchId oneoffId, Set<PatchId> dependencies, List<String> commands) {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        this.patchId = patchId;
        this.oneoffId = oneoffId;
        if (roles != null) {
            this.roles.addAll(roles);
        }
        if (dependencies != null) {
            this.dependencies.addAll(dependencies);
        }
        if (commands != null) {
            this.commands.addAll(commands);
        }
        this.stringCache = "[" + patchId + ",roles=" + roles + ",oneoff=" + oneoffId + ",deps=" + dependencies + ",cmds=" + commands + "]";
    }

    public PatchId getPatchId() {
        return this.patchId;
    }

    public Set<String> getRoles() {
        return Collections.unmodifiableSet(this.roles);
    }

    public PatchId getOneoffId() {
        return this.oneoffId;
    }

    public Set<PatchId> getDependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    public List<String> getPostCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PatchMetadata)) {
            return false;
        }
        PatchMetadata other = (PatchMetadata)obj;
        return this.toString().equals(other.toString());
    }

    public String toString() {
        return this.stringCache;
    }
}

