/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.wildfly.extras.patch.Patch;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.PatchMetadata;
import org.wildfly.extras.patch.PatchMetadataBuilder;
import org.wildfly.extras.patch.PatchTool;
import org.wildfly.extras.patch.Record;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;
import org.wildfly.extras.patch.utils.IllegalStateAssertion;

public final class MetadataParser {
    public static final String MANAGED_PATHS = "managed-paths.metadata";
    static final String VERSION_PREFIX = "# fusepatch:";
    static final String PATCHID_PREFIX = "# patch id:";

    public static Patch buildPatchFromZip(PatchId patchId, Record.Action action, ZipInputStream zipInput) throws IOException {
        IllegalArgumentAssertion.assertNotNull(zipInput, "zipInput");
        HashSet<Record> records = new HashSet<Record>();
        byte[] buffer = new byte[65536];
        ZipEntry entry = zipInput.getNextEntry();
        while (entry != null) {
            if (!entry.isDirectory()) {
                String name = entry.getName();
                int read = zipInput.read(buffer);
                while (read > 0) {
                    read = zipInput.read(buffer);
                }
                long crc = entry.getCrc();
                records.add(Record.create(patchId, action, Paths.get(name, new String[0]), crc));
            }
            entry = zipInput.getNextEntry();
        }
        PatchMetadataBuilder mdbuilder = new PatchMetadataBuilder().patchId(patchId);
        return Patch.create(mdbuilder.build(), records);
    }

    public static Patch readPatch(Path rootPath, PatchId patchId) throws IOException {
        IllegalArgumentAssertion.assertNotNull(rootPath, "rootPath");
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        File metadata = MetadataParser.getMetadataFile(rootPath, patchId);
        return metadata.isFile() ? MetadataParser.readPatch(metadata) : null;
    }

    public static List<PatchId> queryAvailablePatches(Path rootPath, final String prefix, boolean latest) {
        IllegalArgumentAssertion.assertNotNull(rootPath, "rootPath");
        final HashMap auxmap = new HashMap();
        if (rootPath.toFile().exists()) {
            try {
                Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                        String name = path.getFileName().toString();
                        if (!MetadataParser.MANAGED_PATHS.equals(name) && name.endsWith(".metadata") && (prefix == null || name.startsWith(prefix))) {
                            PatchId patchId = PatchId.fromURL(path.toUri().toURL());
                            TreeSet<PatchId> idset = (TreeSet<PatchId>)auxmap.get(patchId.getName());
                            if (idset == null) {
                                idset = new TreeSet<PatchId>();
                                auxmap.put(patchId.getName(), idset);
                            }
                            idset.add(patchId);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
        TreeSet sortedSet = new TreeSet();
        for (TreeSet set : auxmap.values()) {
            if (latest) {
                sortedSet.add(set.last());
                continue;
            }
            sortedSet.addAll(set);
        }
        ArrayList result = new ArrayList(sortedSet);
        Collections.reverse(result);
        return Collections.unmodifiableList(result);
    }

    public static void writePatch(Path rootPath, Patch patch) throws IOException {
        IllegalArgumentAssertion.assertNotNull(rootPath, "rootPath");
        IllegalArgumentAssertion.assertNotNull(patch, "patch");
        File metadataFile = MetadataParser.getMetadataFile(rootPath, patch.getPatchId());
        metadataFile.getParentFile().mkdirs();
        try (FileOutputStream fos = new FileOutputStream(metadataFile);){
            MetadataParser.writePatch(patch, fos, true);
        }
    }

    public static File getMetadataDirectory(Path rootPath, PatchId patchId) {
        return rootPath.resolve(Paths.get(patchId.getName(), patchId.getVersion().toString())).toFile();
    }

    public static File getMetadataFile(Path rootPath, PatchId patchId) {
        return MetadataParser.getMetadataDirectory(rootPath, patchId).toPath().resolve(patchId + ".metadata").toFile();
    }

    public static void writePatch(Patch patch, OutputStream outstream, boolean addHeader) throws IOException {
        IllegalArgumentAssertion.assertNotNull(patch, "patch");
        IllegalArgumentAssertion.assertNotNull(outstream, "outstream");
        try (PrintStream pw = new PrintStream(outstream);){
            Object spec;
            if (addHeader) {
                pw.println("# fusepatch: " + PatchTool.VERSION);
                pw.println("# patch id: " + patch.getPatchId());
            }
            pw.println();
            pw.println("[properties]");
            PatchMetadata metadata = patch.getMetadata();
            if (!metadata.getRoles().isEmpty()) {
                spec = metadata.getRoles().toString();
                spec = ((String)spec).substring(1, ((String)spec).length() - 1);
                pw.println("Roles: " + (String)spec);
            }
            if (!metadata.getDependencies().isEmpty()) {
                spec = metadata.getDependencies().toString();
                spec = ((String)spec).substring(1, ((String)spec).length() - 1);
                pw.println("Dependencies: " + (String)spec);
            }
            pw.println();
            pw.println("[content]");
            for (Record rec : patch.getRecords()) {
                pw.println(rec.toString());
            }
            List<String> commands = metadata.getPostCommands();
            if (!commands.isEmpty()) {
                pw.println();
                pw.println("[post-install-commands]");
                for (String cmd : commands) {
                    pw.println(cmd);
                }
            }
        }
    }

    public static Patch readPatch(File metadataFile) throws IOException {
        IllegalArgumentAssertion.assertNotNull(metadataFile, "metadataFile");
        IllegalArgumentAssertion.assertTrue(metadataFile.isFile(), "Cannot find metadata file: " + metadataFile);
        PatchMetadataBuilder mdbuilder = new PatchMetadataBuilder();
        HashSet<Record> records = new HashSet<Record>();
        try (BufferedReader br = new BufferedReader(new FileReader(metadataFile));){
            String line = br.readLine().trim();
            IllegalStateAssertion.assertTrue(line.startsWith(VERSION_PREFIX), "Cannot obtain version info");
            line = br.readLine().trim();
            IllegalStateAssertion.assertTrue(line.startsWith(PATCHID_PREFIX), "Cannot obtain patch id");
            mdbuilder.patchId(PatchId.fromString(line.substring(PATCHID_PREFIX.length()).trim()));
            String mode = null;
            while (line != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) {
                    line = br.readLine();
                    continue;
                }
                if (line.startsWith("[") && line.endsWith("]")) {
                    mode = line;
                    line = br.readLine();
                    continue;
                }
                if ("[properties]".equals(mode)) {
                    String[] toks = line.split(":");
                    IllegalStateAssertion.assertEquals(2, toks.length, "Illegal property spec: " + line);
                    String name = toks[0].trim();
                    String value = toks[1].trim();
                    if ("Roles".equals(name)) {
                        for (String tok : value.split(",")) {
                            mdbuilder.roles(tok.trim());
                        }
                    }
                    if ("Dependencies".equals(name)) {
                        for (String tok : value.split(",")) {
                            mdbuilder.dependencies(PatchId.fromString(tok.trim()));
                        }
                    }
                }
                if ("[content]".equals(mode)) {
                    records.add(Record.fromString(line));
                }
                if ("[post-install-commands]".equals(mode)) {
                    mdbuilder.postCommands(line);
                }
                line = br.readLine();
            }
            Patch patch = Patch.create(mdbuilder.build(), records);
            return patch;
        }
    }
}

