/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.wildfly.extras.patch.ManagedPath;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.Record;
import org.wildfly.extras.patch.Server;
import org.wildfly.extras.patch.SmartPatch;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;

public final class ManagedPaths {
    private final Map<Path, ManagedPath> managedPaths = new HashMap<Path, ManagedPath>();

    public ManagedPaths(List<ManagedPath> managedPaths) {
        IllegalArgumentAssertion.assertNotNull(managedPaths, "managedPaths");
        for (ManagedPath mpath : managedPaths) {
            this.managedPaths.put(mpath.getPath(), mpath);
        }
    }

    public ManagedPath getManagedPath(Path path) {
        return this.managedPaths.get(path);
    }

    public List<ManagedPath> getManagedPaths() {
        ArrayList<Path> keys = new ArrayList<Path>(this.managedPaths.keySet());
        Collections.sort(keys);
        ArrayList<ManagedPath> result = new ArrayList<ManagedPath>();
        for (Path path : keys) {
            result.add(this.managedPaths.get(path));
        }
        return Collections.unmodifiableList(result);
    }

    public ManagedPaths updatePaths(Path rootPath, SmartPatch smartPatch, Record.Action ... actions) {
        List<Record.Action> actlist = Arrays.asList(actions);
        for (Record rec : smartPatch.getRecords()) {
            Record.Action act = rec.getAction();
            if (!actlist.contains((Object)act)) continue;
            if (act == Record.Action.ADD) {
                this.addPathOwner(rootPath, rec.getPath(), rec.getPatchId());
                continue;
            }
            if (act == Record.Action.UPD) {
                this.addPathOwner(rootPath, rec.getPath(), rec.getPatchId());
                continue;
            }
            if (act != Record.Action.DEL) continue;
            this.removePathOwner(rootPath, rec.getPath(), rec.getPatchId());
        }
        return this;
    }

    private void addPathOwner(Path rootPath, Path path, PatchId owner) {
        ManagedPath mpath;
        File parentDir;
        Path parent = path.getParent();
        if (!(parent == null || (parentDir = rootPath.resolve(parent).toFile()).exists() && this.managedPaths.get(parent) == null)) {
            this.addPathOwner(rootPath, parent, owner);
        }
        if ((mpath = this.managedPaths.get(path)) == null) {
            List<PatchId> owners = Collections.singletonList(owner);
            File file = rootPath.resolve(path).toFile();
            if (file.isFile()) {
                owners = new ArrayList<PatchId>(owners);
                owners.add(0, Server.SERVER_ID);
            }
            mpath = ManagedPath.create(path, owners);
            this.managedPaths.put(path, mpath);
        } else {
            ArrayList<PatchId> owners = new ArrayList<PatchId>(mpath.getOwners());
            this.removeOwner(owners, owner);
            owners.add(owner);
            mpath = ManagedPath.create(mpath.getPath(), owners);
            this.managedPaths.put(path, mpath);
        }
    }

    private void removePathOwner(Path rootPath, Path path, PatchId owner) {
        File file;
        Path parent;
        ManagedPath mpath = this.managedPaths.get(path);
        if (mpath != null) {
            ArrayList<PatchId> owners = new ArrayList<PatchId>(mpath.getOwners());
            this.removeOwner(owners, owner);
            if (owners.size() == 1 && owners.contains(Server.SERVER_ID)) {
                owners.clear();
            }
            if (!owners.isEmpty()) {
                mpath = ManagedPath.create(mpath.getPath(), owners);
                this.managedPaths.put(mpath.getPath(), mpath);
            } else {
                this.managedPaths.remove(mpath.getPath());
            }
        }
        if ((parent = path.getParent()) != null && !(file = rootPath.resolve(parent).toFile()).exists()) {
            this.removePathOwner(rootPath, parent, owner);
        }
    }

    private void removeOwner(List<PatchId> owners, PatchId owner) {
        Iterator<PatchId> it = owners.iterator();
        while (it.hasNext()) {
            PatchId aux = it.next();
            if (!aux.getName().equals(owner.getName())) continue;
            it.remove();
            break;
        }
    }
}

