/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.repository;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.locks.Lock;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeployResult;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.util.artifact.SubArtifact;
import org.eclipse.aether.version.Version;
import org.wildfly.extras.patch.Patch;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.aether.AetherFactory;
import org.wildfly.extras.patch.internal.MetadataParser;
import org.wildfly.extras.patch.repository.AbstractRepository;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;
import org.wildfly.extras.patch.utils.IllegalStateAssertion;

public class AetherRepository
extends AbstractRepository {
    static final String GROUP_ID = "fusepatch";
    private final AetherFactory factory;

    public AetherRepository(Lock lock, AetherFactory factory) {
        super(lock, factory.getRepositoryURL());
        IllegalArgumentAssertion.assertNotNull(factory, "factory");
        this.factory = factory;
    }

    @Override
    public List<PatchId> queryAvailable(String prefix) {
        this.lock.tryLock();
        try {
            RepositorySystem system = this.factory.getRepositorySystem();
            RepositorySystemSession session = this.factory.newRepositorySystemSession();
            RemoteRepository target = this.factory.getRemoteRepository();
            HashSet<String> names = new HashSet<String>();
            if (prefix == null) {
                URL repoURL = new URL(target.getUrl());
                IllegalStateAssertion.assertEquals("file", repoURL.getProtocol(), "Cannot query remote repository");
                Path repoPath = Paths.get(repoURL.toURI());
                Path groupPath = repoPath.resolve(GROUP_ID);
                if (groupPath.toFile().isDirectory()) {
                    names.addAll(Arrays.asList(groupPath.toFile().list()));
                }
            } else {
                names.add(prefix);
            }
            ArrayList<PatchId> result = new ArrayList<PatchId>();
            for (String name : names) {
                DefaultArtifact artifact = new DefaultArtifact(GROUP_ID, name, "", "metadata", "[0,)");
                VersionRangeRequest rangeRequest = new VersionRangeRequest();
                rangeRequest.setArtifact((Artifact)artifact);
                rangeRequest.setRepositories(Collections.singletonList(target));
                VersionRangeResult rangeResult = system.resolveVersionRange(session, rangeRequest);
                for (Version version : rangeResult.getVersions()) {
                    result.add(PatchId.create(name, version.toString()));
                }
            }
            Collections.sort(result);
            Collections.reverse(result);
            List list = Collections.unmodifiableList(result);
            return list;
        }
        catch (VersionRangeResolutionException ex) {
            throw new IllegalStateException(ex);
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Patch getPatch(PatchId patchId) {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        this.lock.tryLock();
        try {
            ArtifactResult artifactResult;
            RepositorySystem system = this.factory.getRepositorySystem();
            RepositorySystemSession session = this.factory.newRepositorySystemSession();
            RemoteRepository target = this.factory.getRemoteRepository();
            DefaultArtifact artifact = new DefaultArtifact(GROUP_ID, patchId.getName(), "", "metadata", patchId.getVersion().toString());
            ArtifactRequest artifactRequest = new ArtifactRequest();
            artifactRequest.setArtifact((Artifact)artifact);
            artifactRequest.setRepositories(Collections.singletonList(target));
            try {
                artifactResult = system.resolveArtifact(session, artifactRequest);
            }
            catch (ArtifactResolutionException ex) {
                Patch patch = null;
                this.lock.unlock();
                return patch;
            }
            artifact = artifactResult.getArtifact();
            Patch patch = MetadataParser.readPatch(artifact.getFile());
            return patch;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean removeArchive(PatchId removeId) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PatchId addArchiveInternal(Patch patch, DataHandler dataHandler) throws IOException {
        PatchId patchId = patch.getPatchId();
        File tmpFile = Files.createTempFile("fptmp", ".metadata", new FileAttribute[0]).toFile();
        try {
            DeployResult result;
            RepositorySystem system = this.factory.getRepositorySystem();
            RepositorySystemSession session = this.factory.newRepositorySystemSession();
            RemoteRepository target = this.factory.getRemoteRepository();
            DefaultArtifact zipArtifact = new DefaultArtifact(GROUP_ID, patchId.getName(), "", "zip", patchId.getVersion().toString());
            DataSource dataSource = dataHandler.getDataSource();
            if (dataSource instanceof FileDataSource) {
                FileDataSource fileds = (FileDataSource)dataSource;
                zipArtifact = zipArtifact.setFile(fileds.getFile());
            }
            try (FileOutputStream fos = new FileOutputStream(tmpFile);){
                MetadataParser.writePatch(patch, fos, true);
            }
            SubArtifact metadataArtifact = new SubArtifact((Artifact)zipArtifact, "", "metadata");
            metadataArtifact = metadataArtifact.setFile(tmpFile);
            DeployRequest deployRequest = new DeployRequest();
            deployRequest.addArtifact((Artifact)zipArtifact).addArtifact((Artifact)metadataArtifact);
            deployRequest.setRepository(target);
            try {
                result = system.deploy(session, deployRequest);
            }
            catch (DeploymentException ex) {
                throw new IOException(ex);
            }
            ArrayList artifacts = new ArrayList(result.getArtifacts());
            IllegalStateAssertion.assertEquals(2, artifacts.size(), "Not all artifacts deployed: " + result);
            PatchId patchId2 = patchId;
            return patchId2;
        }
        finally {
            tmpFile.delete();
        }
    }

    @Override
    protected DataSource getDataSource(PatchId patchId) {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        RepositorySystem system = this.factory.getRepositorySystem();
        RepositorySystemSession session = this.factory.newRepositorySystemSession();
        RemoteRepository target = this.factory.getRemoteRepository();
        DefaultArtifact artifact = new DefaultArtifact(GROUP_ID, patchId.getName(), "", "zip", patchId.getVersion().toString());
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact((Artifact)artifact);
        artifactRequest.setRepositories(Collections.singletonList(target));
        try {
            ArtifactResult artifactResult = system.resolveArtifact(session, artifactRequest);
            artifact = artifactResult.getArtifact();
            return new FileDataSource(artifact.getFile());
        }
        catch (ArtifactResolutionException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

