/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.repository;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.extras.patch.Patch;
import org.wildfly.extras.patch.PatchMetadata;
import org.wildfly.extras.patch.Record;
import org.wildfly.extras.patch.repository.PatchMetadataAdapter;

public class PatchAdapter {
    private PatchMetadataAdapter metadataSpec;
    private String[] recordSpecs;

    public static PatchAdapter fromPatch(Patch patch) {
        if (patch == null) {
            return null;
        }
        PatchAdapter result = new PatchAdapter();
        result.metadataSpec = PatchMetadataAdapter.fromPatchMetadata(patch.getMetadata());
        List<Record> records = patch.getRecords();
        result.recordSpecs = new String[records.size()];
        for (int i = 0; i < records.size(); ++i) {
            result.recordSpecs[i] = records.get(i).toString();
        }
        return result;
    }

    public Patch toPatch() {
        PatchMetadata metadata = this.metadataSpec.toPatchMetadata();
        ArrayList<Record> records = new ArrayList<Record>();
        for (String spec : this.recordSpecs) {
            records.add(Record.fromString(spec));
        }
        return Patch.create(metadata, records);
    }

    public PatchMetadataAdapter getMetadata() {
        return this.metadataSpec;
    }

    public void setMetadata(PatchMetadataAdapter metadata) {
        this.metadataSpec = metadata;
    }

    public String[] getRecords() {
        return this.recordSpecs;
    }

    public void setRecords(String[] records) {
        this.recordSpecs = records;
    }
}

