/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.context.propagation.mutiny;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.context.spi.ContextManagerProvider;

public class ThreadContextRegistry {
    public static ThreadContextRegistry INSTANCE = new ThreadContextRegistry();
    private final Map<ClassLoader, ThreadContext> threadContextsByClassLoader = Collections.synchronizedMap(new HashMap());

    private ThreadContextRegistry() {
    }

    ThreadContext getThreadContext() {
        return this.getThreadContext(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ThreadContext getThreadContext(ClassLoader cl) {
        ThreadContext tc = this.threadContextsByClassLoader.get(cl);
        if (tc == null) {
            ThreadContextRegistry threadContextRegistry = this;
            synchronized (threadContextRegistry) {
                tc = this.threadContextsByClassLoader.get(cl);
                if (tc == null) {
                    tc = ContextManagerProvider.instance().getContextManager(cl).newThreadContextBuilder().build();
                    this.threadContextsByClassLoader.put(cl, tc);
                }
            }
        }
        return tc;
    }

    public void cleanup(ClassLoader cl) {
        this.threadContextsByClassLoader.remove(cl);
    }
}

