/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.sunstone.api.wildfly;

import java.io.IOException;
import org.slf4j.Logger;
import org.wildfly.extras.creaper.core.ManagementClient;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.OnlineOptions;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;
import org.wildfly.extras.sunstone.api.Node;
import org.wildfly.extras.sunstone.api.NodeWrapper;
import org.wildfly.extras.sunstone.api.wildfly.SunstoneWildFlyLogger;

public class WildFlyNode
extends NodeWrapper {
    private static final Logger LOGGER = SunstoneWildFlyLogger.DEFAULT;
    private final int mgmtPortUnmapped;
    private final String mgmtUser;
    private final String mgmtPassword;
    private final boolean isDomain;
    private final String defaultProfile;
    private final String defaultHost;

    public WildFlyNode(Node node) {
        super(node);
        String mgmtPortStr = node.config().getProperty("wildfly.management.port", null);
        this.mgmtPortUnmapped = mgmtPortStr != null ? Integer.valueOf(mgmtPortStr) : (node.isPortOpen(9990) ? 9990 : 9999);
        this.mgmtUser = node.config().getProperty("wildfly.management.user", null);
        this.mgmtPassword = node.config().getProperty("wildfly.management.password", null);
        String operatingMode = node.config().getProperty("wildfly.mode", "standalone");
        this.isDomain = "domain".equals(operatingMode);
        this.defaultProfile = node.config().getProperty("wildfly.domain.default.profile", null);
        this.defaultHost = node.config().getProperty("wildfly.domain.default.host", null);
    }

    public int getMgmtPort() {
        return this.getPublicTcpPort(this.mgmtPortUnmapped);
    }

    public String getMgmtUser() {
        return this.mgmtUser;
    }

    public String getMgmtPassword() {
        return this.mgmtPassword;
    }

    public long getMgmtConnectionTimeoutInSec() {
        return this.config().getPropertyAsLong("wildfly.management.connectionTimeoutInSec", 60L);
    }

    public long getMgmtPortOpeningTimeoutInSec() {
        return this.config().getPropertyAsLong("wildfly.management.portOpeningTimeoutInSec", 60L);
    }

    public long getBootTimeoutInSec() {
        return this.config().getPropertyAsLong("wildfly.management.bootTimeoutInSec", 60L);
    }

    public OnlineManagementClient createManagementClient() throws IOException {
        return this.createManagementClient(1000 * (int)this.getMgmtConnectionTimeoutInSec());
    }

    public OnlineManagementClient createManagementClient(int timeoutInMillis) throws IOException {
        OnlineOptions.ConnectionOnlineOptions options = this.isDomain ? OnlineOptions.domain().forProfile(this.defaultProfile).forHost(this.defaultHost).build() : OnlineOptions.standalone();
        OnlineOptions.OptionalOnlineOptions clientOptions = options.hostAndPort(this.getPublicAddress() == null ? this.getPrivateAddress() : this.getPublicAddress(), this.getMgmtPort()).auth(this.mgmtUser, this.mgmtPassword).connectionTimeout(timeoutInMillis).bootTimeout(1000 * (int)this.getBootTimeoutInSec());
        return ManagementClient.online((OnlineOptions)clientOptions.build());
    }

    public void waitUntilRunning(long timeoutForPortInSeconds) throws IOException {
        if (timeoutForPortInSeconds > 0L) {
            LOGGER.debug("Waiting for management port on node '{}'", (Object)this.getName());
            this.waitForPorts(timeoutForPortInSeconds, new int[]{this.mgmtPortUnmapped});
            LOGGER.debug("Management port {} is open on node '{}'", (Object)this.mgmtPortUnmapped, (Object)this.getName());
        }
        try (OnlineManagementClient managementClient = this.createManagementClient();){
            Administration admin = new Administration(managementClient);
            LOGGER.debug("Waiting for WildFly server state running on node '{}'", (Object)this.getName());
            admin.waitUntilRunning();
            LOGGER.debug("WildFly Server is running on node '{}'", (Object)this.getName());
        }
    }

    public void waitUntilRunning() throws IOException {
        this.waitUntilRunning(this.getMgmtPortOpeningTimeoutInSec());
    }
}

