/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config.generator;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.embedded.EmbeddedManagedProcess;
import org.wildfly.core.embedded.EmbeddedProcessFactory;
import org.wildfly.core.embedded.EmbeddedProcessStartException;
import org.wildfly.galleon.plugin.server.ConfigGeneratorException;

public abstract class BaseConfigGenerator {
    protected static final byte INITIAL = 0;
    protected static final byte START_STANDALONE = 1;
    protected static final byte START_HC = 2;
    protected static final byte LOOKING_FOR_ARGS = 4;
    protected static final byte EMBEDDED_STARTED = 8;
    protected static final String BATCH = "batch";
    protected static final String STOP = "stop";
    protected static final String RUN_BATCH = "run-batch";
    protected boolean hc;
    protected String[] args;
    protected Long bootTimeout = null;
    protected EmbeddedManagedProcess embeddedProcess;
    protected ModelControllerClient mcc;
    protected ModelNode composite;
    protected String jbossHome;
    protected boolean forkEmbedded;
    protected String resetSysProps;
    protected String stabilityLevel;
    protected Path script;
    protected PrintWriter scriptWriter;
    protected StringBuilder scriptBuf;

    protected void handle(ModelNode op) throws ConfigGeneratorException {
        if (this.forkEmbedded) {
            op.writeJSONString(this.scriptWriter, true);
            this.scriptWriter.println();
        } else if (this.composite != null) {
            this.composite.get("steps").add(op);
        } else {
            this.doHandle(op);
        }
    }

    protected void doHandle(ModelNode op) throws ConfigGeneratorException {
        try {
            ModelNode response = this.mcc.execute(op);
            if (Operations.isSuccessfulOutcome((ModelNode)response)) {
                return;
            }
            StringBuilder buf = new StringBuilder();
            buf.append("Failed to");
            if (this.hc) {
                String domainConfig = null;
                boolean emptyDomain = false;
                String hostConfig = null;
                boolean emptyHost = false;
                int i = 0;
                while (i < this.args.length) {
                    String arg;
                    if ((arg = this.args[i++]).startsWith("--domain-config")) {
                        if (arg.length() == "--domain-config".length()) {
                            domainConfig = this.args[i++];
                            continue;
                        }
                        domainConfig = arg.substring("--domain-config".length() + 1);
                        continue;
                    }
                    if (arg.startsWith("--host-config")) {
                        if (arg.length() == "--host-config".length()) {
                            hostConfig = this.args[i++];
                            continue;
                        }
                        hostConfig = arg.substring("--host-config".length() + 1);
                        continue;
                    }
                    if (arg.equals("--empty-host-config")) {
                        emptyHost = true;
                        continue;
                    }
                    if (!arg.equals("--empty-domain-config")) continue;
                    emptyDomain = true;
                }
                if (emptyDomain) {
                    buf.append(" generate ").append(domainConfig);
                    if (emptyHost && hostConfig != null) {
                        buf.append(" and ").append(hostConfig);
                    }
                } else if (emptyHost) {
                    buf.append(" generate ").append(hostConfig);
                } else {
                    buf.append(" execute script");
                }
            } else {
                String serverConfig = null;
                boolean emptyConfig = false;
                int i = 0;
                while (i < this.args.length) {
                    String arg;
                    if ((arg = this.args[i++]).equals("--server-config")) {
                        if (arg.length() == "--server-config".length()) {
                            serverConfig = this.args[i++];
                            continue;
                        }
                        serverConfig = arg.substring("--server-config".length() + 1);
                        continue;
                    }
                    if (!arg.equals("--internal-empty-config")) continue;
                    emptyConfig = true;
                }
                if (emptyConfig) {
                    buf.append(" generate ").append(serverConfig);
                } else {
                    buf.append(" execute script");
                }
            }
            buf.append(" on ").append(op).append(": ").append(Operations.getFailureDescription((ModelNode)response));
            throw new ConfigGeneratorException(buf.toString());
        }
        catch (IOException e) {
            throw new ConfigGeneratorException("Failed to execute " + op);
        }
    }

    void startBatch() {
        if (this.forkEmbedded) {
            this.writeScript(BATCH);
        } else {
            this.composite = Operations.createCompositeOperation();
        }
    }

    void endBatch() throws ConfigGeneratorException {
        if (this.forkEmbedded) {
            this.writeScript(RUN_BATCH);
        } else {
            this.doHandle(this.composite);
            this.composite = null;
        }
    }

    protected void doStartHc(String ... args) throws ConfigGeneratorException {
        this.args = args;
        this.hc = true;
        this.embeddedProcess = EmbeddedProcessFactory.createHostController((String)this.jbossHome, null, null, (String[])args);
        try {
            this.embeddedProcess.start();
        }
        catch (EmbeddedProcessStartException e) {
            throw new ConfigGeneratorException("Failed to start embedded hc", (Throwable)e);
        }
        this.mcc = this.embeddedProcess.getModelControllerClient();
        this.waitForHc(this.embeddedProcess);
    }

    protected void waitForHc(EmbeddedManagedProcess embeddedProcess) throws ConfigGeneratorException {
        if (this.bootTimeout == null || this.bootTimeout > 0L) {
            String status;
            long expired;
            long l = expired = this.bootTimeout == null ? Long.MAX_VALUE : System.nanoTime() + this.bootTimeout;
            while ((status = embeddedProcess.getProcessState()) == null || "starting".equals(status)) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ConfigGeneratorException("Interrupted while waiting for embedded server to start");
                }
                if (System.nanoTime() < expired) continue;
            }
            if (status == null || "starting".equals(status)) {
                assert (this.bootTimeout != null);
                this.stopEmbedded();
                throw new ConfigGeneratorException("Embedded host controller did not exit 'starting' status within " + TimeUnit.NANOSECONDS.toSeconds(this.bootTimeout) + " seconds");
            }
        }
    }

    protected void doStartServer(String ... args) throws ConfigGeneratorException {
        this.args = args;
        this.hc = false;
        this.embeddedProcess = EmbeddedProcessFactory.createStandaloneServer((String)this.jbossHome, null, null, (String[])args);
        try {
            this.embeddedProcess.start();
        }
        catch (EmbeddedProcessStartException e) {
            throw new ConfigGeneratorException("Failed to start embedded server", (Throwable)e);
        }
        this.mcc = this.embeddedProcess.getModelControllerClient();
        this.waitForServer();
    }

    protected void doStopEmbedded() throws ConfigGeneratorException {
        if (this.mcc != null) {
            try {
                this.mcc.close();
            }
            catch (IOException e) {
                throw new ConfigGeneratorException("Failed to close ModelControllerClient", (Throwable)e);
            }
            this.mcc = null;
        }
        if (this.embeddedProcess != null) {
            this.embeddedProcess.stop();
            this.embeddedProcess = null;
        }
    }

    protected void waitForServer() throws ConfigGeneratorException {
        if (this.bootTimeout == null || this.bootTimeout > 0L) {
            long expired = this.bootTimeout == null ? Long.MAX_VALUE : System.nanoTime() + this.bootTimeout;
            String status = "starting";
            ModelNode getStateOp = new ModelNode();
            getStateOp.get("operation").set("read-attribute");
            getStateOp.get("name").set("server-state");
            do {
                try {
                    ModelNode response = this.mcc.execute(getStateOp);
                    if (Operations.isSuccessfulOutcome((ModelNode)response)) {
                        status = response.get("result").asString();
                    }
                }
                catch (Exception response) {
                    // empty catch block
                }
                if (!"starting".equals(status)) break;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ConfigGeneratorException("Interrupted while waiting for embedded server to start");
                }
            } while (System.nanoTime() < expired);
            if ("starting".equals(status)) {
                assert (this.bootTimeout != null);
                this.stopEmbedded();
                throw new ConfigGeneratorException("Embedded server did not exit 'starting' status within " + TimeUnit.NANOSECONDS.toSeconds(this.bootTimeout) + " seconds");
            }
        }
    }

    void stopEmbedded() throws ConfigGeneratorException {
        if (this.forkEmbedded) {
            this.writeScript(STOP);
        } else {
            this.doStopEmbedded();
        }
    }

    protected void writeScript(String line) {
        this.scriptWriter.println(line);
    }
}

