/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config.generator;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.wildfly.galleon.plugin.server.ConfigGeneratorException;

public class ServerBridge {
    private static final String ModelControllerClient = "org.jboss.as.controller.client.ModelControllerClient";
    private static final String EmbeddedManagedProcess = "org.wildfly.core.embedded.EmbeddedManagedProcess";
    private static final String EmbeddedProcessFactory = "org.wildfly.core.embedded.EmbeddedProcessFactory";
    private static final String ModelNode = "org.jboss.dmr.ModelNode";
    private static final String Operations = "org.jboss.as.controller.client.helpers.Operations";
    private static final String ClientConstants = "org.jboss.as.controller.client.helpers.ClientConstants";
    private static final String createHostController = "createHostController";
    private static final String createStandaloneServer = "createStandaloneServer";
    private static final String start = "start";
    private static final String getModelControllerClient = "getModelControllerClient";
    private static final String execute = "execute";
    private static final String fromJSONString = "fromJSONString";
    private static final String get = "get";
    private static final String set = "set";
    private static final String add = "add";
    private static final String isSuccessfulOutcome = "isSuccessfulOutcome";
    private static final String getFailureDescription = "getFailureDescription";
    private static final String createCompositeOperation = "createCompositeOperation";
    private static final String getProcessState = "getProcessState";
    private static final String close = "close";
    private static final String stop = "stop";
    private static final String asString = "asString";
    private static final String READ_ATTRIBUTE_OPERATION = "READ_ATTRIBUTE_OPERATION";
    private static final String NAME = "NAME";
    private static final String OP = "OP";
    private static final String RESULT = "RESULT";
    private static Method createHostControllerMethod;
    private static Method createStandaloneServerMethod;
    private static Method startMethod;
    private static Method getModelControllerClientMethod;
    private static Method executeMethod;
    private static Method fromJSONStringMethod;
    private static Method getMethod;
    private static Method setMethod;
    private static Method addMethod;
    private static Method isSuccessfulOutcomeMethod;
    private static Method getFailureDescriptionMethod;
    private static Method createCompositeOperationMethod;
    private static Method getProcessStateMethod;
    private static Method closeMethod;
    private static Method stopMethod;
    private static Method asStringMethod;
    private static Constructor dmrNewInstance;
    static String READ_ATTRIBUTE_OPERATION_FIELD_VALUE;
    static String NAME_FIELD_VALUE;
    static String OP_FIELD_VALUE;
    static String RESULT_FIELD_VALUE;
    private static ServerBridge INSTANCE;

    private ServerBridge() {
    }

    static synchronized ServerBridge get(ClassLoader cl) throws ConfigGeneratorException {
        if (INSTANCE == null) {
            ServerBridge.initializeEmbedded(cl);
            INSTANCE = new ServerBridge();
        }
        return INSTANCE;
    }

    private static void initializeEmbedded(ClassLoader loader) throws ConfigGeneratorException {
        try {
            Class<?> EmbeddedManagedProcessClass = Class.forName(EmbeddedManagedProcess, true, loader);
            Class<?> EmbeddedProcessFactoryClass = Class.forName(EmbeddedProcessFactory, true, loader);
            Class<?> ModelControllerClientClass = Class.forName(ModelControllerClient, true, loader);
            Class<?> ModelNodeClass = Class.forName(ModelNode, true, loader);
            Class<?> OperationsClass = Class.forName(Operations, true, loader);
            Class<?> ClientConstantsClass = Class.forName(ClientConstants, true, loader);
            dmrNewInstance = ModelNodeClass.getConstructor(new Class[0]);
            createHostControllerMethod = EmbeddedProcessFactoryClass.getMethod(createHostController, String.class, String.class, String[].class, String[].class);
            createStandaloneServerMethod = EmbeddedProcessFactoryClass.getMethod(createStandaloneServer, String.class, String.class, String[].class, String[].class);
            startMethod = EmbeddedManagedProcessClass.getMethod(start, new Class[0]);
            getModelControllerClientMethod = EmbeddedManagedProcessClass.getMethod(getModelControllerClient, new Class[0]);
            executeMethod = ModelControllerClientClass.getMethod(execute, ModelNodeClass);
            fromJSONStringMethod = ModelNodeClass.getMethod(fromJSONString, String.class);
            getMethod = ModelNodeClass.getMethod(get, String.class);
            setMethod = ModelNodeClass.getMethod(set, String.class);
            addMethod = ModelNodeClass.getMethod(add, ModelNodeClass);
            isSuccessfulOutcomeMethod = OperationsClass.getMethod(isSuccessfulOutcome, ModelNodeClass);
            getFailureDescriptionMethod = OperationsClass.getMethod(getFailureDescription, ModelNodeClass);
            createCompositeOperationMethod = OperationsClass.getMethod(createCompositeOperation, new Class[0]);
            getProcessStateMethod = EmbeddedManagedProcessClass.getMethod(getProcessState, new Class[0]);
            closeMethod = ModelControllerClientClass.getMethod(close, new Class[0]);
            stopMethod = EmbeddedManagedProcessClass.getMethod(stop, new Class[0]);
            asStringMethod = ModelNodeClass.getMethod(asString, new Class[0]);
            READ_ATTRIBUTE_OPERATION_FIELD_VALUE = (String)ClientConstantsClass.getField(READ_ATTRIBUTE_OPERATION).get(null);
            NAME_FIELD_VALUE = (String)ClientConstantsClass.getField(NAME).get(null);
            OP_FIELD_VALUE = (String)ClientConstantsClass.getField(OP).get(null);
            RESULT_FIELD_VALUE = (String)ClientConstantsClass.getField(RESULT).get(null);
        }
        catch (Exception ex) {
            throw new ConfigGeneratorException(ex);
        }
    }

    void dmr_steps_add(Object composite, String json) throws ConfigGeneratorException {
        try {
            Object steps = getMethod.invoke(composite, "steps");
            Object op = fromJSONStringMethod.invoke(null, json);
            addMethod.invoke(steps, op);
        }
        catch (Exception ex) {
            throw new ConfigGeneratorException(ex);
        }
    }

    Object dmr_fromJSON(String json) throws ConfigGeneratorException {
        try {
            return fromJSONStringMethod.invoke(null, json);
        }
        catch (Exception ex) {
            throw new ConfigGeneratorException(ex);
        }
    }

    Object mcc_execute(Object mcc, Object op) throws ConfigGeneratorException {
        try {
            return executeMethod.invoke(mcc, op);
        }
        catch (Exception ex) {
            throw new ConfigGeneratorException(ex);
        }
    }

    void mcc_close(Object mcc) throws ConfigGeneratorException {
        try {
            closeMethod.invoke(mcc, new Object[0]);
        }
        catch (Exception ex) {
            throw new ConfigGeneratorException(ex);
        }
    }

    Boolean dmr_isSuccessful(Object response) throws ConfigGeneratorException {
        try {
            return (Boolean)isSuccessfulOutcomeMethod.invoke(null, response);
        }
        catch (Exception ex) {
            throw new ConfigGeneratorException(ex);
        }
    }

    String dmr_getFailureDescription(Object response) throws ConfigGeneratorException {
        try {
            return (String)getFailureDescriptionMethod.invoke(null, response);
        }
        catch (Exception ex) {
            throw new ConfigGeneratorException(ex);
        }
    }

    Object dmr_createCompositeOperation() throws ConfigGeneratorException {
        try {
            return createCompositeOperationMethod.invoke(null, new Object[0]);
        }
        catch (Exception ex) {
            throw new ConfigGeneratorException(ex);
        }
    }

    String dmr_asString(Object dmr) throws ConfigGeneratorException {
        try {
            return (String)asStringMethod.invoke(dmr, new Object[0]);
        }
        catch (Exception ex) {
            throw new ConfigGeneratorException(ex);
        }
    }

    Object dmr_get(Object dmr, String field) throws ConfigGeneratorException {
        try {
            return getMethod.invoke(dmr, field);
        }
        catch (Exception ex) {
            throw new ConfigGeneratorException(ex);
        }
    }

    Object dmr_set(Object dmr, String field) throws ConfigGeneratorException {
        try {
            return setMethod.invoke(dmr, field);
        }
        catch (Exception ex) {
            throw new ConfigGeneratorException(ex);
        }
    }

    Object dmr_newInstance() throws ConfigGeneratorException {
        try {
            return dmrNewInstance.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new ConfigGeneratorException(ex);
        }
    }

    Object embed_createHostController(String jbossHome, String[] args) throws ConfigGeneratorException {
        try {
            return createHostControllerMethod.invoke(null, jbossHome, null, null, args);
        }
        catch (Exception ex) {
            throw new ConfigGeneratorException(ex);
        }
    }

    Object embed_createStandalone(String jbossHome, String[] args) throws ConfigGeneratorException {
        try {
            return createStandaloneServerMethod.invoke(null, jbossHome, null, null, args);
        }
        catch (Exception ex) {
            throw new ConfigGeneratorException(ex);
        }
    }

    void embed_start(Object embeddedProcess) throws ConfigGeneratorException {
        try {
            startMethod.invoke(embeddedProcess, new Object[0]);
        }
        catch (Exception ex) {
            throw new ConfigGeneratorException(ex);
        }
    }

    void embed_stop(Object embeddedProcess) throws ConfigGeneratorException {
        try {
            stopMethod.invoke(embeddedProcess, new Object[0]);
        }
        catch (Exception ex) {
            throw new ConfigGeneratorException(ex);
        }
    }

    Object embed_getModelControllerClient(Object embeddedProcess) throws ConfigGeneratorException {
        try {
            return getModelControllerClientMethod.invoke(embeddedProcess, new Object[0]);
        }
        catch (Exception ex) {
            throw new ConfigGeneratorException(ex);
        }
    }

    String embed_getProcessState(Object embeddedProcess) throws ConfigGeneratorException {
        try {
            return (String)getProcessStateMethod.invoke(embeddedProcess, new Object[0]);
        }
        catch (Exception ex) {
            throw new ConfigGeneratorException(ex);
        }
    }
}

