/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config.generator;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.parsing.ParsingState;
import org.jboss.as.cli.parsing.ParsingStateCallbackHandler;
import org.jboss.as.cli.parsing.StateParser;
import org.jboss.as.cli.parsing.arguments.ArgumentValueCallbackHandler;
import org.jboss.as.cli.parsing.arguments.ArgumentValueInitialState;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.plugin.ProvisionedConfigHandler;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.runtime.ResolvedFeatureSpec;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.spec.FeatureAnnotation;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.state.ProvisionedFeature;
import org.jboss.galleon.util.CollectionUtils;
import org.wildfly.galleon.plugin.WfInstallPlugin;
import org.wildfly.galleon.plugin.config.generator.WfConfigGenerator;
import org.wildfly.galleon.plugin.server.ConfigGeneratorException;

public class WfProvisionedConfigHandler
implements ProvisionedConfigHandler,
AutoCloseable {
    private static final int OP = 0;
    private static final int WRITE_ATTR = 1;
    private static final int LIST_ADD = 2;
    private static NameFilter STANDALONE_PARAM_FILTER;
    private static NameFilter DOMAIN_PARAM_FILTER;
    private static NameFilter HOST_PARAM_FILTER;
    private final WfConfigGenerator configGen;
    private final Map<ResolvedSpecId, List<ManagedOp>> specOps = new HashMap<ResolvedSpecId, List<ManagedOp>>();
    private List<ManagedOp> ops = Collections.emptyList();
    private NameFilter paramFilter;
    private Path dumpScriptsDir;
    private BufferedWriter scriptWriter;
    private int batchCount;
    private int opsCount;
    private int individualOpsCount;
    private StringBuilder scriptBuf;
    private boolean inBatch;

    private static NameFilter getStandaloneParamFilter() {
        if (STANDALONE_PARAM_FILTER == null) {
            STANDALONE_PARAM_FILTER = new NameFilter(){

                @Override
                public boolean accepts(String name, int position) {
                    return position > 0 || !"profile".equals(name) && !"host".equals(name);
                }
            };
        }
        return STANDALONE_PARAM_FILTER;
    }

    private static NameFilter getDomainParamFilter() {
        if (DOMAIN_PARAM_FILTER == null) {
            DOMAIN_PARAM_FILTER = new NameFilter(){

                @Override
                public boolean accepts(String name, int position) {
                    return position > 0 || !"host".equals(name);
                }
            };
        }
        return DOMAIN_PARAM_FILTER;
    }

    private static NameFilter getHostParamFilter() {
        if (HOST_PARAM_FILTER == null) {
            HOST_PARAM_FILTER = new NameFilter(){

                @Override
                public boolean accepts(String name, int position) {
                    return position > 0 || !"profile".equals(name);
                }
            };
        }
        return HOST_PARAM_FILTER;
    }

    private List<ManagedOp> createWriteAttributeManagedOperation(ResolvedFeatureSpec spec, FeatureAnnotation annotation) throws ProvisioningException {
        return this.createTwoArgOp(spec, annotation, "write-attribute", 1);
    }

    private List<ManagedOp> createTwoArgOp(ResolvedFeatureSpec spec, FeatureAnnotation annotation, String name, int op) throws ProvisioningException {
        List<ManagedOp> operations;
        String elemValue = annotation.getElement("addr-params");
        if (elemValue == null) {
            throw new ProvisioningException("Required element addr-params is missing for " + spec.getId());
        }
        List<Object> addrParams = Collections.emptyList();
        if (!"server-root".equals(elemValue)) {
            try {
                addrParams = WfProvisionedConfigHandler.parseList(annotation.getElementAsList("addr-params"), annotation.getElementAsList("addr-params-mapping"));
            }
            catch (ProvisioningDescriptionException e) {
                throw new ProvisioningDescriptionException("Saw an empty parameter name in annotation addr-params=" + elemValue + " of " + spec.getId());
            }
        }
        elemValue = annotation.getElement("op-params", "GLN_UNDEFINED");
        String complexAttr = annotation.getElement("complex-attribute");
        if ("GLN_UNDEFINED".equals(elemValue)) {
            if (!spec.hasParams()) {
                throw new ProvisioningDescriptionException("op-params element of " + name + " annotation of " + spec.getId() + " accepts only one parameter: " + annotation);
            }
            Set allParams = spec.getParamNames();
            int opParams = allParams.size() - addrParams.size() / 2;
            if (opParams == 0) {
                throw new ProvisioningDescriptionException("op-params element of " + name + " annotation of " + spec.getId() + " accepts only one parameter: " + annotation);
            }
            if (complexAttr == null) {
                operations = new ArrayList(allParams.size());
                for (String paramName : allParams) {
                    int j;
                    boolean inAddr = false;
                    for (j = 0; !inAddr && j < addrParams.size(); j += 2) {
                        if (!((String)addrParams.get(j)).equals(paramName)) continue;
                        inAddr = true;
                    }
                    if (inAddr || !this.paramFilter.accepts(paramName, j)) continue;
                    ManagedOp mop = new ManagedOp();
                    mop.name = name;
                    mop.op = op;
                    mop.addrParams = addrParams;
                    mop.opParams = new ArrayList<String>(2);
                    mop.opParams.add(paramName);
                    mop.opParams.add(paramName);
                    operations.add(mop);
                }
            } else {
                ManagedOp mop = new ManagedOp();
                mop.name = name;
                mop.op = op;
                mop.complexAttr = complexAttr;
                mop.addrParams = addrParams;
                mop.opParams = new ArrayList<String>(allParams.size());
                for (String paramName : allParams) {
                    int j;
                    boolean inAddr = false;
                    for (j = 0; !inAddr && j < addrParams.size(); j += 2) {
                        if (!((String)addrParams.get(j)).equals(paramName)) continue;
                        inAddr = true;
                    }
                    if (inAddr || !this.paramFilter.accepts(paramName, j)) continue;
                    mop.opParams.add(paramName);
                    mop.opParams.add(paramName);
                }
                operations = Collections.singletonList(mop);
            }
        } else {
            List<String> params;
            try {
                params = WfProvisionedConfigHandler.parseList(annotation.getElementAsList("op-params"), annotation.getElementAsList("op-params-mapping"));
            }
            catch (ProvisioningDescriptionException e) {
                throw new ProvisioningDescriptionException("Saw empty parameter name in note addr-params=" + elemValue + " of " + spec.getId());
            }
            if (complexAttr == null) {
                operations = new ArrayList<ManagedOp>(params.size());
                for (int i = 0; i < params.size(); ++i) {
                    if (i % 2 != 0) continue;
                    ManagedOp mop = new ManagedOp();
                    mop.name = name;
                    mop.op = op;
                    mop.addrParams = addrParams;
                    mop.opParams = new ArrayList<String>(2);
                    mop.opParams.add(params.get(i));
                    mop.opParams.add(params.get(i + 1));
                    operations.add(mop);
                }
            } else {
                ManagedOp mop = new ManagedOp();
                mop.name = name;
                mop.op = op;
                mop.addrParams = addrParams;
                mop.complexAttr = complexAttr;
                mop.opParams = new ArrayList<String>(params.size() * 2);
                for (int i = 0; i < params.size(); ++i) {
                    if (i % 2 != 0) continue;
                    mop.opParams.add(params.get(i));
                    mop.opParams.add(params.get(i + 1));
                }
                operations = Collections.singletonList(mop);
            }
        }
        return operations;
    }

    private List<ManagedOp> createAddListManagedOperation(ResolvedFeatureSpec spec, FeatureAnnotation annotation) throws ProvisioningException {
        return this.createTwoArgOp(spec, annotation, "list-add", 2);
    }

    private List<ManagedOp> createManagedOperation(ResolvedFeatureSpec spec, FeatureAnnotation annotation, String name, int operation) throws ProvisioningException {
        ManagedOp mop = new ManagedOp();
        mop.name = name;
        mop.op = operation;
        String elemValue = annotation.getElement("addr-params");
        if (elemValue == null) {
            throw new ProvisioningException("Required element addr-params is missing for " + spec.getId());
        }
        try {
            mop.addrParams = WfProvisionedConfigHandler.parseList(annotation.getElementAsList("addr-params"), annotation.getElementAsList("addr-params-mapping"));
        }
        catch (ProvisioningDescriptionException e) {
            throw new ProvisioningDescriptionException("Saw an empty parameter name in annotation addr-params=" + elemValue + " of " + spec.getId());
        }
        if (mop.addrParams == null) {
            return Collections.emptyList();
        }
        elemValue = annotation.getElement("op-params", "GLN_UNDEFINED");
        if ("GLN_UNDEFINED".equals(elemValue)) {
            if (spec.hasParams()) {
                Set allParams = spec.getParamNames();
                int opParams = allParams.size() - mop.addrParams.size() / 2;
                if (opParams == 0) {
                    mop.opParams = Collections.emptyList();
                } else {
                    mop.opParams = new ArrayList<String>(opParams * 2);
                    for (String paramName : allParams) {
                        int j;
                        boolean inAddr = false;
                        for (j = 0; !inAddr && j < mop.addrParams.size(); j += 2) {
                            if (!mop.addrParams.get(j).equals(paramName)) continue;
                            inAddr = true;
                        }
                        if (inAddr || !this.paramFilter.accepts(paramName, j)) continue;
                        mop.opParams.add(paramName);
                        mop.opParams.add(paramName);
                    }
                }
            } else {
                mop.opParams = Collections.emptyList();
            }
        } else {
            try {
                mop.opParams = WfProvisionedConfigHandler.parseList(annotation.getElementAsList("op-params", "GLN_UNDEFINED"), annotation.getElementAsList("op-params-mapping"));
            }
            catch (ProvisioningDescriptionException e) {
                throw new ProvisioningDescriptionException("Saw empty parameter name in note addr-params=" + elemValue + " of " + spec.getId());
            }
        }
        return Collections.singletonList(mop);
    }

    public WfProvisionedConfigHandler(ProvisioningRuntime runtime, WfConfigGenerator configGen) throws ProvisioningException {
        this.configGen = configGen;
        if (runtime.isOptionSet(WfInstallPlugin.OPTION_DUMP_CONFIG_SCRIPTS)) {
            String value = runtime.getOptionValue(WfInstallPlugin.OPTION_DUMP_CONFIG_SCRIPTS);
            this.dumpScriptsDir = value == null ? Paths.get(System.getProperty("user.home"), new String[0]).resolve("galleon-scripts") : Paths.get(value, new String[0]);
        }
    }

    public void prepare(ProvisionedConfig config) throws ProvisioningException {
        if ("standalone".equals(config.getModel())) {
            this.configGen.startServer(this.getEmbeddedArgs(config));
            this.paramFilter = WfProvisionedConfigHandler.getStandaloneParamFilter();
        } else if ("domain".equals(config.getModel())) {
            this.configGen.startHc(this.getEmbeddedArgs(config));
            try {
                this.configGen.handle(Operations.createAddOperation((ModelNode)Operations.createAddress((String[])new String[]{"host", "tmp"})).toJSONString(true));
            }
            catch (ConfigGeneratorException e) {
                throw new ProvisioningException("Unsupported config model " + config.getModel());
            }
            this.paramFilter = WfProvisionedConfigHandler.getDomainParamFilter();
        } else if ("host".equals(config.getModel())) {
            this.configGen.startHc(this.getEmbeddedArgs(config));
            this.paramFilter = WfProvisionedConfigHandler.getHostParamFilter();
        } else {
            throw new ProvisioningException("Unsupported config model " + config.getModel());
        }
        if (this.dumpScriptsDir != null) {
            this.initScriptWriter(config);
        }
    }

    public void nextSpec(ResolvedFeatureSpec spec) throws ProvisioningException {
        if (!spec.hasAnnotations()) {
            this.ops = Collections.emptyList();
            return;
        }
        this.ops = this.specOps.get(spec.getId());
        if (this.ops != null) {
            return;
        }
        this.ops = Collections.emptyList();
        try {
            for (FeatureAnnotation annotation : spec.getAnnotations()) {
                if (!annotation.getName().equals("jboss-op")) continue;
                this.ops = CollectionUtils.addAll(this.ops, this.nextAnnotation(spec, annotation));
            }
        }
        catch (Error | RuntimeException | ProvisioningException t) {
            if (this.scriptWriter != null) {
                this.closeScriptWriter();
            }
            throw t;
        }
        this.specOps.put(spec.getId(), this.ops);
    }

    private List<ManagedOp> nextAnnotation(ResolvedFeatureSpec spec, FeatureAnnotation annotation) throws ProvisioningException {
        String name;
        switch (name = annotation.getElement("name")) {
            case "write-attribute": {
                return this.createWriteAttributeManagedOperation(spec, annotation);
            }
            case "list-add": {
                return this.createAddListManagedOperation(spec, annotation);
            }
        }
        return this.createManagedOperation(spec, annotation, name, 0);
    }

    public void nextFeature(ProvisionedFeature feature) throws ProvisioningException {
        if (this.ops.isEmpty()) {
            return;
        }
        try {
            for (ManagedOp op : this.ops) {
                op.toCommandLine(feature);
            }
        }
        catch (Error | RuntimeException | ProvisioningException t) {
            if (this.scriptWriter != null) {
                this.closeScriptWriter();
            }
            throw t;
        }
    }

    public void startBatch() throws ProvisioningException {
        if (this.scriptWriter != null) {
            this.newLineScript();
            this.writeScript("# Batch No. " + ++this.batchCount);
            this.writeScript("batch");
            this.inBatch = true;
        }
        try {
            this.configGen.startBatch();
        }
        catch (Error | RuntimeException t) {
            if (this.scriptWriter != null) {
                this.closeScriptWriter();
            }
            throw t;
        }
    }

    public void endBatch() throws ProvisioningException {
        block4: {
            if (this.scriptWriter != null) {
                this.writeScript("run-batch");
                this.inBatch = false;
            }
            try {
                this.configGen.endBatch();
            }
            catch (Error | RuntimeException | ConfigGeneratorException t) {
                if (this.scriptWriter != null) {
                    this.closeScriptWriter();
                }
                if (!(t instanceof ConfigGeneratorException)) break block4;
                throw new ProvisioningException(t);
            }
        }
    }

    public void done() throws ProvisioningException {
        if (this.scriptWriter != null) {
            this.closeScriptWriter();
        }
        try {
            this.configGen.stopEmbedded();
        }
        catch (ConfigGeneratorException e) {
            throw new ProvisioningException((Throwable)e);
        }
    }

    @Override
    public void close() {
        if (this.scriptWriter != null) {
            this.closeScriptWriter();
        }
    }

    private String[] getEmbeddedArgs(ProvisionedConfig config) throws ProvisioningException {
        String configNameProp;
        ArrayList<Object> embeddedArgs = new ArrayList<Object>(config.getProperties().size());
        if ("standalone".equals(config.getModel())) {
            configNameProp = "--server-config";
        } else if ("domain".equals(config.getModel())) {
            configNameProp = "--domain-config";
        } else if ("host".equals(config.getModel())) {
            configNameProp = "--host-config";
        } else {
            throw new ProvisioningException("Unexpected config model " + config.getModel());
        }
        boolean explicitlyNamed = false;
        for (Map.Entry prop : config.getProperties().entrySet()) {
            if (!((String)prop.getKey()).startsWith("--")) continue;
            embeddedArgs.add((String)prop.getKey());
            if (!((String)prop.getValue()).isEmpty()) {
                embeddedArgs.add((String)prop.getValue());
            }
            if (explicitlyNamed) continue;
            explicitlyNamed = ((String)prop.getKey()).equals(configNameProp);
        }
        if (!explicitlyNamed) {
            embeddedArgs.add(configNameProp);
            embeddedArgs.add(config.getName());
        }
        if (this.configGen.stabilityLevel != null && !this.configGen.stabilityLevel.isEmpty()) {
            embeddedArgs.add("--stability=" + this.configGen.stabilityLevel);
        }
        return embeddedArgs.toArray(new String[embeddedArgs.size()]);
    }

    private void handleOp(ModelNode op) throws ProvisioningException {
        if (this.scriptWriter != null) {
            if (!this.inBatch) {
                ++this.individualOpsCount;
                this.newLineScript();
            }
            this.writeScript(op);
            ++this.opsCount;
        }
        try {
            this.configGen.handle(op.toJSONString(true));
        }
        catch (Throwable t) {
            if (this.scriptWriter != null) {
                this.closeScriptWriter();
            }
            throw new ProvisioningException("Failed to execute operation " + op, t);
        }
    }

    private void setOpParam(ModelNode op, String name, String value) throws ProvisioningException {
        ModelNode toSet = null;
        try {
            toSet = ModelNode.fromString((String)value);
        }
        catch (Exception e) {
            ArgumentValueCallbackHandler handler = new ArgumentValueCallbackHandler();
            try {
                StateParser.parse((String)value, (ParsingStateCallbackHandler)handler, (ParsingState)ArgumentValueInitialState.INSTANCE);
            }
            catch (CommandFormatException e1) {
                throw new ProvisioningException("Failed to parse parameter " + name + " '" + value + "'", (Throwable)e1);
            }
            toSet = handler.getResult();
        }
        op.get(name).set(toSet);
    }

    static List<String> parseList(List<String> params, List<String> mappings) throws ProvisioningDescriptionException {
        if (params == null || params.isEmpty()) {
            return Collections.emptyList();
        }
        if (params.size() != mappings.size() && mappings.size() > 0) {
            throw new ProvisioningDescriptionException("Mappings and params don't match");
        }
        ArrayList<String> list = new ArrayList<String>(2 * params.size());
        for (int i = 0; i < params.size(); ++i) {
            list.add(params.get(i));
            list.add(mappings.isEmpty() ? params.get(i) : mappings.get(i));
        }
        return list;
    }

    private void initScriptWriter(ProvisionedConfig config) {
        try {
            Path scriptDir = this.dumpScriptsDir.resolve(config.getModel());
            Files.createDirectories(scriptDir, new FileAttribute[0]);
            this.scriptWriter = Files.newBufferedWriter(scriptDir.resolve("script-" + config.getName()), new OpenOption[0]);
            this.scriptBuf = new StringBuilder();
            this.scriptBuf.append("# Config");
            if (config.getModel() != null) {
                this.scriptBuf.append(" model=").append(config.getModel());
            }
            this.scriptBuf.append(" name=").append(config.getName());
            this.writeScript(this.scriptBuf.toString());
            this.writeScript("# Properties:");
            for (Map.Entry prop : config.getProperties().entrySet()) {
                this.scriptBuf.setLength(2);
                this.scriptBuf.append((String)prop.getKey());
                String value = (String)prop.getValue();
                if (value != null && !value.isEmpty()) {
                    this.scriptBuf.append('=').append(value);
                }
                this.writeScript(this.scriptBuf.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void newLineScript() {
        try {
            this.scriptWriter.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void closeScriptWriter() {
        try {
            this.scriptWriter.newLine();
            this.writeScript("# Operations total: " + this.opsCount);
            this.opsCount = 0;
            this.writeScript("# Batches total: " + this.batchCount);
            this.batchCount = 0;
            this.writeScript("# Individual operations total: " + this.individualOpsCount);
            this.individualOpsCount = 0;
            this.scriptWriter.close();
            this.scriptWriter = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeScript(String line) {
        try {
            this.scriptWriter.write(line);
            this.scriptWriter.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeScript(ModelNode op) {
        try {
            this.scriptBuf.setLength(0);
            List addrList = op.get("address").asPropertyList();
            if (!addrList.isEmpty()) {
                for (Property addr : addrList) {
                    this.scriptBuf.append('/').append(addr.getName()).append('=').append(addr.getValue().asString());
                }
            }
            this.scriptBuf.append(':');
            this.scriptBuf.append(op.get("operation").asString());
            List params = op.asPropertyList();
            if (params.size() > 2) {
                this.scriptBuf.append('(');
                boolean comma = false;
                for (Property param : params) {
                    String paramName = param.getName();
                    if (paramName.equals("address") || paramName.equals("operation")) continue;
                    if (comma) {
                        this.scriptBuf.append(',');
                    } else {
                        comma = true;
                    }
                    this.scriptBuf.append(param.getName()).append('=').append(param.getValue().asString());
                }
                this.scriptBuf.append(')');
            }
            this.scriptWriter.write(this.scriptBuf.toString());
            this.scriptWriter.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static interface NameFilter {
        public boolean accepts(String var1, int var2);
    }

    private class ManagedOp {
        String name;
        List<String> addrParams = Collections.emptyList();
        List<String> opParams = Collections.emptyList();
        int op;
        String complexAttr;

        private ManagedOp() {
        }

        public String toString() {
            return "ManagedOp{name=" + this.name + ", addrParams=" + this.addrParams + ", opParams=" + this.opParams + ", op=" + this.op + "}";
        }

        private void executeOp(ProvisionedFeature feature) throws ProvisioningException {
            ModelNode op = this.writeOpAddress(feature);
            if (!this.opParams.isEmpty()) {
                int i = 0;
                while (i < this.opParams.size()) {
                    String featureParam;
                    String value;
                    if ((value = feature.getConfigParam(featureParam = this.opParams.get(i++))) == null) {
                        ++i;
                        continue;
                    }
                    WfProvisionedConfigHandler.this.setOpParam(op, this.opParams.get(i++), (String)(value.trim().isEmpty() ? "\"" + value + "\"" : value));
                }
            }
            WfProvisionedConfigHandler.this.handleOp(op);
        }

        private ModelNode writeOpAddress(ProvisionedFeature feature) throws ProvisioningException {
            ModelNode op = Operations.createOperation((String)this.name);
            if (this.addrParams.isEmpty()) {
                return op;
            }
            ModelNode addr = Operations.getOperationAddress((ModelNode)op);
            int i = 0;
            while (i < this.addrParams.size()) {
                String featureParam = this.addrParams.get(i);
                if (!WfProvisionedConfigHandler.this.paramFilter.accepts(featureParam, i)) {
                    i += 2;
                    continue;
                }
                String value = feature.getConfigParam(featureParam);
                if (value == null) {
                    throw new ProvisioningException("Address parameter " + featureParam + " of " + feature.getId() + " is null");
                }
                if ("GLN_UNDEFINED".equals(value)) {
                    i += 2;
                    continue;
                }
                int n = ++i;
                ++i;
                addr.add(this.addrParams.get(n), value);
            }
            return op;
        }

        void toCommandLine(ProvisionedFeature feature) throws ProvisioningException {
            switch (this.op) {
                case 0: {
                    this.executeOp(feature);
                    break;
                }
                case 1: 
                case 2: {
                    this.executeTwoArgOps(feature);
                    break;
                }
                default: {
                    throw new ProvisioningException("Unexpected op " + this.op);
                }
            }
        }

        private void executeTwoArgOps(ProvisionedFeature feature) throws ProvisioningDescriptionException, ProvisioningException {
            if (this.complexAttr == null) {
                int i = 0;
                while (i < this.opParams.size()) {
                    Object value;
                    if ((value = feature.getResolvedParam(this.opParams.get(i++))) == null) {
                        ++i;
                        continue;
                    }
                    ModelNode op = this.writeOpAddress(feature);
                    op.get("name").set(this.opParams.get(i++));
                    WfProvisionedConfigHandler.this.setOpParam(op, "value", value.toString());
                    WfProvisionedConfigHandler.this.handleOp(op);
                }
                return;
            }
            ModelNode op = this.writeOpAddress(feature);
            op.get("name").set(this.complexAttr);
            ModelNode attrValue = new ModelNode();
            int i = 0;
            while (i < this.opParams.size()) {
                Object value;
                if ((value = feature.getResolvedParam(this.opParams.get(i++))) == null) {
                    ++i;
                    continue;
                }
                WfProvisionedConfigHandler.this.setOpParam(attrValue, this.opParams.get(i++), value.toString());
            }
            op.get("value").set(attrValue);
            WfProvisionedConfigHandler.this.handleOp(op);
        }
    }
}

