/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.featurespec.generator;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.wildfly.galleon.plugin.featurespec.generator.FeatureSpecNode;

public class FeatureSpecGenerator {
    private Map<String, FeatureSpecNode> nodesBySpecName = new HashMap<String, FeatureSpecNode>();
    private Map<String, Map<String, FeatureSpecNode>> referencedSpecs = new HashMap<String, Map<String, FeatureSpecNode>>();
    private Map<String, FeatureSpecNode> capProviders = new HashMap<String, FeatureSpecNode>();
    private int specsGenerated;
    final Path outputDir;
    private final boolean debug;
    private Set<String> inheritedSpecs;

    String getBranchId(String spec, int dots) {
        int index = 0;
        for (int i = 0; i <= dots; ++i) {
            if ((index = spec.indexOf(46, index + 1)) >= 0) continue;
            return spec;
        }
        return spec.substring(0, index);
    }

    void addSpec(String name, FeatureSpecNode node) {
        this.nodesBySpecName.put(name, node);
    }

    FeatureSpecNode getSpec(String name) {
        return this.nodesBySpecName.get(name);
    }

    void addReferencedSpec(String referencedSpecName, String referencingSpec, FeatureSpecNode referencingNode) {
        Map<String, FeatureSpecNode> specs = this.referencedSpecs.get(referencedSpecName);
        if (specs != null) {
            if (specs.size() == 1) {
                specs = new HashMap<String, FeatureSpecNode>(specs);
                this.referencedSpecs.put(referencedSpecName, specs);
            }
            specs.put(referencingSpec, referencingNode);
        } else {
            this.referencedSpecs.put(referencedSpecName, Collections.singletonMap(referencingSpec, referencingNode));
        }
    }

    Map<String, FeatureSpecNode> getReferencingSpecs(String referencedSpecName) {
        Map<String, FeatureSpecNode> refs = this.referencedSpecs.get(referencedSpecName);
        return refs == null ? Collections.emptyMap() : refs;
    }

    void clearReferencingSpecs(String referencedSpecName) {
        this.referencedSpecs.remove(referencedSpecName);
    }

    void addCapProvider(String cap, FeatureSpecNode spec) {
        this.capProviders.put(cap, spec);
    }

    FeatureSpecNode getCapProvider(String cap) {
        return this.capProviders.get(cap);
    }

    boolean isInherited(String name) {
        return this.inheritedSpecs.contains(name);
    }

    void increaseSpecCount() {
        ++this.specsGenerated;
    }

    public FeatureSpecGenerator(Path outputDir, Set<String> inheritedSpecs, boolean debug) {
        this.outputDir = outputDir;
        this.debug = debug;
        this.inheritedSpecs = inheritedSpecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int generateSpecs(Path installationHome) throws ProvisioningException {
        ArrayList<String> toClear;
        HashMap<Object, Object> originalProps = new HashMap<Object, Object>(System.getProperties());
        System.setProperty("org.wildfly.logging.skipLogManagerCheck", "true");
        System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        try {
            this.doGenerate(installationHome);
            toClear = new ArrayList<String>();
        }
        catch (Throwable throwable) {
            ArrayList<String> toClear2 = new ArrayList<String>();
            for (Map.Entry<Object, Object> prop : System.getProperties().entrySet()) {
                Object value = originalProps.get(prop.getKey());
                if (value != null) {
                    System.setProperty(prop.getKey().toString(), value.toString());
                    continue;
                }
                toClear2.add(prop.getKey().toString());
            }
            for (Map.Entry<Object, Object> prop : toClear2) {
                System.clearProperty((String)((Object)prop));
            }
            throw throwable;
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            Object value = originalProps.get(entry.getKey());
            if (value != null) {
                System.setProperty(entry.getKey().toString(), value.toString());
                continue;
            }
            toClear.add(entry.getKey().toString());
        }
        for (String string : toClear) {
            System.clearProperty(string);
        }
        return this.specsGenerated;
    }

    private void doGenerate(Path installationHome) throws ProvisioningException {
        ModelNode standaloneFeatures = FeatureSpecGenerator.readStandaloneFeatures(installationHome);
        FeatureSpecNode rootNode = new FeatureSpecNode(this, 1, standaloneFeatures.require("name").asString(), standaloneFeatures);
        ModelNode domainRoots = FeatureSpecGenerator.readDomainFeatures(installationHome);
        rootNode.setDomainDescr("domain", new ModelNode());
        rootNode.generateDomain = false;
        for (Property child : domainRoots.get("children").asPropertyList()) {
            String specName = child.getName();
            if (specName.equals("host")) {
                rootNode.setHostDescr(specName, child.getValue());
                continue;
            }
            if (specName.equals("profile")) {
                rootNode.setProfileDescr(specName, child.getValue());
                continue;
            }
            rootNode.domainDescr.get("children").add(specName, child.getValue());
        }
        rootNode.processChildren(1);
        rootNode.processChildren(2);
        rootNode.processChildren(4);
        rootNode.processChildren(8);
        rootNode.buildSpecs();
    }

    /*
     * Exception decompiling
     */
    private static ModelNode readStandaloneFeatures(Path wildfly) throws ProvisioningException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static ModelNode readDomainFeatures(Path wildfly) throws ProvisioningException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ModelNode readFeatures(ModelControllerClient client) throws IOException, ProvisioningDescriptionException, XMLStreamException {
        ModelNode address = new ModelNode().setEmptyList();
        ModelNode op = Operations.createOperation((String)"read-feature-description", (ModelNode)address);
        op.get("recursive").set(true);
        ModelNode result = client.execute(op);
        FeatureSpecGenerator.checkOutcome(result);
        if (result.hasDefined("result")) {
            result = result.require("result");
        }
        return result.require("feature");
    }

    private static void checkOutcome(ModelNode result) throws ProvisioningDescriptionException {
        if (!result.get("outcome").asString().equals("success")) {
            if (result.hasDefined("failure-description")) {
                throw new ProvisioningDescriptionException(result.get("failure-description").asString());
            }
            throw new ProvisioningDescriptionException("Error executing operation " + result.asString());
        }
    }

    void warn(String str) {
        System.out.println("WARN: " + str);
    }

    void debug(String str, Object ... args) {
        if (this.debug) {
            System.out.println(String.format(str, args));
        }
    }
}

