/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.featurespec.generator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.util.StringUtils;
import org.wildfly.core.embedded.EmbeddedProcessFactory;
import org.wildfly.core.embedded.EmbeddedProcessStartException;
import org.wildfly.core.embedded.HostController;
import org.wildfly.core.embedded.StandaloneServer;

public class FeatureSpecDescriptionReader {
    public static void main(String ... args) throws Exception {
        ModelNode result;
        if (args.length != 3) {
            StringBuilder buf = new StringBuilder();
            StringUtils.append((StringBuilder)buf, Arrays.asList(args));
            throw new IllegalArgumentException("Expected 2 arguments but for " + buf);
        }
        if ("standalone".equals(args[1])) {
            result = FeatureSpecDescriptionReader.readStandaloneFeatures(args[0]);
        } else if ("domain".equals(args[1])) {
            result = FeatureSpecDescriptionReader.readDomainFeatures(args[0]);
        } else {
            throw new IllegalArgumentException("Unexpected controller type " + args[1]);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(args[2], new String[0]), new OpenOption[0]);){
            writer.write(result.asString());
        }
    }

    public static ModelNode readStandalone(String jbossHome, boolean forkEmbedded, boolean echoEmbeddedLog) throws ProvisioningException {
        if (forkEmbedded) {
            return FeatureSpecDescriptionReader.forkEmbedded(jbossHome, "standalone", echoEmbeddedLog);
        }
        return FeatureSpecDescriptionReader.readStandaloneFeatures(jbossHome);
    }

    public static ModelNode readDomain(String jbossHome, boolean forkEmbedded, boolean echoEmbeddedLog) throws ProvisioningException {
        if (forkEmbedded) {
            return FeatureSpecDescriptionReader.forkEmbedded(jbossHome, "domain", echoEmbeddedLog);
        }
        return FeatureSpecDescriptionReader.readDomainFeatures(jbossHome);
    }

    private static ModelNode readStandaloneFeatures(String jbossHome) throws ProvisioningException {
        StandaloneServer server = EmbeddedProcessFactory.createStandaloneServer((String)jbossHome, null, null, (String[])new String[]{"--admin-only"});
        try {
            server.start();
            ModelNode modelNode = FeatureSpecDescriptionReader.readFeatures(server.getModelControllerClient());
            return modelNode;
        }
        catch (EmbeddedProcessStartException ex) {
            throw new ProvisioningException("Failed to embed server", (Throwable)ex);
        }
        finally {
            server.stop();
        }
    }

    private static ModelNode readDomainFeatures(String jbossHome) throws ProvisioningException {
        HostController server = EmbeddedProcessFactory.createHostController((String)jbossHome, null, null, (String[])new String[]{"--admin-only"});
        try {
            server.start();
            ModelNode modelNode = FeatureSpecDescriptionReader.readFeatures(server.getModelControllerClient());
            return modelNode;
        }
        catch (EmbeddedProcessStartException ex) {
            throw new ProvisioningException("Failed to embed host controller", (Throwable)ex);
        }
        finally {
            server.stop();
        }
    }

    private static ModelNode readFeatures(ModelControllerClient client) throws ProvisioningException {
        ModelNode result;
        ModelNode op = Operations.createOperation((String)"read-feature-description");
        op.get("recursive").set(true);
        try {
            result = client.execute(op);
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to read feature descriptions", (Throwable)e);
        }
        if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
            throw new ProvisioningException(Operations.getFailureDescription((ModelNode)result).asString());
        }
        if (result.hasDefined("result")) {
            return result.require("result").require("feature");
        }
        throw new ProvisioningException("The outcome does not include 'result': " + result.asString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ModelNode forkEmbedded(String jbossHome, String controllerType, boolean echoEmbeddedLog) throws ProvisioningException {
        Throwable throwable;
        Process p;
        File descrFile;
        StringBuilder cp = new StringBuilder();
        FeatureSpecDescriptionReader.collectCpUrls(System.getProperty("java.home"), Thread.currentThread().getContextClassLoader(), cp);
        try {
            descrFile = File.createTempFile("rfd", controllerType);
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to create a temporary file", (Throwable)e);
        }
        String[] commands = new String[]{"java", "-cp", cp.toString(), FeatureSpecDescriptionReader.class.getName(), jbossHome, controllerType, descrFile.getAbsolutePath()};
        try {
            p = new ProcessBuilder(Arrays.asList(commands)).redirectErrorStream(true).start();
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to start a feature spec reading process", (Throwable)e);
        }
        try {
            throwable = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                String line = reader.readLine();
                while (line != null) {
                    if (echoEmbeddedLog) {
                        System.out.println(line);
                    }
                    line = reader.readLine();
                }
                if (p.isAlive()) {
                    try {
                        p.waitFor();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (p.exitValue() != 0) {
                    throw new RuntimeException("Process has failed");
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new ProvisioningException("Process has failed", (Throwable)e);
        }
        try {
            throwable = null;
            try (FileInputStream is = new FileInputStream(descrFile);){
                ModelNode modelNode = ModelNode.fromStream((InputStream)is);
                return modelNode;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to read resulting file " + descrFile, (Throwable)e);
        }
    }

    private static void collectCpUrls(String javaHome, ClassLoader cl, StringBuilder buf) {
        ClassLoader parentCl = cl.getParent();
        if (parentCl != null) {
            FeatureSpecDescriptionReader.collectCpUrls(javaHome, cl.getParent(), buf);
        }
        if (cl instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)cl).getURLs()) {
                String file = url.getFile();
                if (file.startsWith(javaHome)) continue;
                if (buf.length() > 0) {
                    buf.append(File.pathSeparatorChar);
                }
                buf.append(file);
            }
        }
    }
}

