/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.featurespec.generator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.StringUtils;
import org.jboss.galleon.xml.FeatureSpecXmlParser;
import org.wildfly.core.embedded.EmbeddedManagedProcess;
import org.wildfly.core.embedded.EmbeddedProcessFactory;
import org.wildfly.core.embedded.EmbeddedProcessStartException;
import org.wildfly.galleon.plugin.featurespec.generator.FeatureSpecNode;
import org.wildfly.galleon.plugin.server.ForkedEmbeddedUtil;

public class FeatureSpecGenerator
implements ForkedEmbeddedUtil.ForkCallback {
    private Map<String, FeatureSpecNode> nodesBySpecName = new HashMap<String, FeatureSpecNode>();
    private Map<String, Map<String, FeatureSpecNode>> referencedSpecs = new HashMap<String, Map<String, FeatureSpecNode>>();
    private Map<String, FeatureSpecNode> capProviders = new HashMap<String, FeatureSpecNode>();
    private int specsGenerated;
    private String installation;
    Path outputDir;
    private boolean fork;
    private boolean debug;
    private Map<String, Path> inheritedSpecs;
    private Map<String, FeatureSpec> parsedInheritedSpecs = Collections.emptyMap();
    private Path systemProps;
    private Path standaloneSpecsFile;
    private Path domainSpecsFile;

    String getBranchId(String spec, int dots) {
        int index = 0;
        for (int i = 0; i <= dots; ++i) {
            if ((index = spec.indexOf(46, index + 1)) >= 0) continue;
            return spec;
        }
        return spec.substring(0, index);
    }

    void addSpec(String name, FeatureSpecNode node) {
        this.nodesBySpecName.put(name, node);
    }

    FeatureSpecNode getSpec(String name) {
        return this.nodesBySpecName.get(name);
    }

    void addReferencedSpec(String referencedSpecName, String referencingSpec, FeatureSpecNode referencingNode) {
        Map<String, FeatureSpecNode> specs = this.referencedSpecs.get(referencedSpecName);
        if (specs != null) {
            if (specs.size() == 1) {
                specs = new HashMap<String, FeatureSpecNode>(specs);
                this.referencedSpecs.put(referencedSpecName, specs);
            }
            specs.put(referencingSpec, referencingNode);
        } else {
            this.referencedSpecs.put(referencedSpecName, Collections.singletonMap(referencingSpec, referencingNode));
        }
    }

    Map<String, FeatureSpecNode> getReferencingSpecs(String referencedSpecName) {
        Map<String, FeatureSpecNode> refs = this.referencedSpecs.get(referencedSpecName);
        return refs == null ? Collections.emptyMap() : refs;
    }

    void clearReferencingSpecs(String referencedSpecName) {
        this.referencedSpecs.remove(referencedSpecName);
    }

    void addCapProvider(String cap, FeatureSpecNode spec) {
        this.capProviders.put(cap, spec);
    }

    FeatureSpecNode getCapProvider(String cap) {
        return this.capProviders.get(cap);
    }

    boolean isInherited(String name) {
        return this.inheritedSpecs.containsKey(name);
    }

    void increaseSpecCount() {
        ++this.specsGenerated;
    }

    public FeatureSpecGenerator() {
    }

    public FeatureSpecGenerator(String installation, Path outputDir, Map<String, Path> inheritedSpecs, boolean fork, boolean debug) {
        this.installation = installation;
        this.outputDir = outputDir;
        this.fork = fork;
        this.debug = debug;
        this.inheritedSpecs = inheritedSpecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int generateSpecs() throws ProvisioningException {
        ArrayList<String> toClear;
        HashMap<Object, Object> originalProps = new HashMap<Object, Object>(System.getProperties());
        try {
            this.doGenerate(this.installation.toString());
            toClear = new ArrayList<String>();
        }
        catch (Throwable throwable) {
            ArrayList<String> toClear2 = new ArrayList<String>();
            for (Map.Entry<Object, Object> prop : System.getProperties().entrySet()) {
                Object value = originalProps.get(prop.getKey());
                if (value != null) {
                    System.setProperty(prop.getKey().toString(), value.toString());
                    continue;
                }
                toClear2.add(prop.getKey().toString());
            }
            for (Map.Entry<Object, Object> prop : toClear2) {
                System.clearProperty((String)((Object)prop));
            }
            if (this.systemProps != null) {
                IoUtils.recursiveDelete((Path)this.systemProps);
            }
            if (this.standaloneSpecsFile != null) {
                IoUtils.recursiveDelete((Path)this.standaloneSpecsFile);
            }
            if (this.domainSpecsFile != null) {
                IoUtils.recursiveDelete((Path)this.domainSpecsFile);
            }
            throw throwable;
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            Object value = originalProps.get(entry.getKey());
            if (value != null) {
                System.setProperty(entry.getKey().toString(), value.toString());
                continue;
            }
            toClear.add(entry.getKey().toString());
        }
        for (String string : toClear) {
            System.clearProperty(string);
        }
        if (this.systemProps != null) {
            IoUtils.recursiveDelete((Path)this.systemProps);
        }
        if (this.standaloneSpecsFile != null) {
            IoUtils.recursiveDelete((Path)this.standaloneSpecsFile);
        }
        if (this.domainSpecsFile != null) {
            IoUtils.recursiveDelete((Path)this.domainSpecsFile);
        }
        return this.specsGenerated;
    }

    private void doGenerate(String installationHome) throws ProvisioningException {
        ModelNode standaloneFeatures;
        ModelNode domainRoots = null;
        if (this.fork) {
            ForkedEmbeddedUtil.fork((ForkedEmbeddedUtil.ForkCallback)this, (Path)this.getStoredSystemProps(), (String[])new String[]{this.installation, this.getStandaloneSpecsFile().toString(), this.getDomainSpecsFile().toString()});
            standaloneFeatures = this.readSpecsFile(this.getStandaloneSpecsFile());
            if (Files.exists(Paths.get(this.installation, new String[0]).resolve("domain").resolve("configuration"), new LinkOption[0])) {
                domainRoots = this.readSpecsFile(this.getDomainSpecsFile());
            }
        } else {
            Path home = Paths.get(this.installation, new String[0]);
            if (!Files.exists(home.resolve("standalone").resolve("configuration"), new LinkOption[0])) {
                throw new ProvisioningException("The installation does not include standalone configuration");
            }
            standaloneFeatures = FeatureSpecGenerator.readFeatureSpecs(FeatureSpecGenerator.createStandaloneServer(this.installation));
            if (Files.exists(home.resolve("domain").resolve("configuration"), new LinkOption[0])) {
                domainRoots = FeatureSpecGenerator.readFeatureSpecs(FeatureSpecGenerator.createEmbeddedHc(this.installation));
            }
        }
        FeatureSpecNode rootNode = new FeatureSpecNode(this, 1, standaloneFeatures.require("name").asString(), standaloneFeatures);
        if (domainRoots != null) {
            rootNode.setDomainDescr("domain", new ModelNode());
            rootNode.generateDomain = false;
            for (Property child : domainRoots.get("children").asPropertyList()) {
                String specName = child.getName();
                if (specName.equals("host")) {
                    rootNode.setHostDescr(specName, child.getValue());
                    continue;
                }
                if (specName.equals("profile")) {
                    rootNode.setProfileDescr(specName, child.getValue());
                    continue;
                }
                rootNode.domainDescr.get("children").add(specName, child.getValue());
            }
        }
        rootNode.processChildren(1);
        if (domainRoots != null) {
            rootNode.processChildren(2);
            rootNode.processChildren(4);
            rootNode.processChildren(8);
        }
        rootNode.buildSpecs();
    }

    public void forkedForEmbedded(String ... args) throws ProvisioningException {
        if (args.length != 3) {
            StringBuilder buf = new StringBuilder();
            StringUtils.append((StringBuilder)buf, Arrays.asList(args));
            throw new IllegalArgumentException("Expected 3 arguments but got " + Arrays.asList(args));
        }
        ModelNode result = FeatureSpecGenerator.readFeatureSpecs(FeatureSpecGenerator.createStandaloneServer(args[0]));
        this.writeSpecsFile(Paths.get(args[1], new String[0]), result);
        if (Files.exists(Paths.get(args[0], new String[0]).resolve("domain").resolve("configuration"), new LinkOption[0])) {
            result = FeatureSpecGenerator.readFeatureSpecs(FeatureSpecGenerator.createEmbeddedHc(args[0]));
            this.writeSpecsFile(Paths.get(args[2], new String[0]), result);
        }
    }

    public void forkedEmbeddedMessage(String msg) {
        if (this.debug) {
            System.out.println(msg);
        }
    }

    protected Path getStoredSystemProps() throws ProvisioningException {
        if (this.systemProps == null) {
            this.systemProps = ForkedEmbeddedUtil.storeSystemProps();
        }
        return this.systemProps;
    }

    protected Path getStandaloneSpecsFile() throws ProvisioningException {
        if (this.standaloneSpecsFile == null) {
            try {
                this.standaloneSpecsFile = Files.createTempFile("wfgp", "standalone-specs", new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ProvisioningException("Failed to create a tmp file", (Throwable)e);
            }
        }
        return this.standaloneSpecsFile;
    }

    protected Path getDomainSpecsFile() throws ProvisioningException {
        if (this.domainSpecsFile == null) {
            try {
                this.domainSpecsFile = Files.createTempFile("wfgp", "domain-specs", new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ProvisioningException("Failed to create a tmp file", (Throwable)e);
            }
        }
        return this.domainSpecsFile;
    }

    protected FeatureSpec getInheritedSpec(String name) throws ProvisioningException {
        FeatureSpec spec = this.parsedInheritedSpecs.get(name);
        if (spec != null) {
            return spec;
        }
        Path path = this.inheritedSpecs.get(name);
        if (path == null) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            spec = FeatureSpecXmlParser.getInstance().parse((Reader)reader);
        }
        catch (IOException | XMLStreamException e) {
            throw new ProvisioningException("Failed to parse " + name + " spec " + path, (Throwable)e);
        }
        this.parsedInheritedSpecs = CollectionUtils.put(this.parsedInheritedSpecs, (Object)name, (Object)spec);
        return spec;
    }

    private static EmbeddedManagedProcess createStandaloneServer(String jbossHome) {
        return EmbeddedProcessFactory.createStandaloneServer((String)jbossHome, null, null, (String[])new String[]{"--admin-only"});
    }

    private static EmbeddedManagedProcess createEmbeddedHc(String jbossHome) {
        return EmbeddedProcessFactory.createHostController((String)jbossHome, null, null, (String[])new String[]{"--admin-only"});
    }

    private static ModelNode readFeatureSpecs(EmbeddedManagedProcess server) throws ProvisioningException {
        try {
            ModelNode result;
            server.start();
            ModelNode op = Operations.createOperation((String)"read-feature-description");
            op.get("recursive").set(true);
            try {
                result = server.getModelControllerClient().execute(op);
            }
            catch (IOException e) {
                throw new ProvisioningException("Failed to read feature descriptions", (Throwable)e);
            }
            if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
                throw new ProvisioningException(Operations.getFailureDescription((ModelNode)result).asString());
            }
            ModelNode modelNode = result.require("result").require("feature");
            return modelNode;
        }
        catch (EmbeddedProcessStartException ex) {
            throw new ProvisioningException("Failed to read feature spec descriptions", (Throwable)ex);
        }
        finally {
            server.stop();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ModelNode readSpecsFile(Path specsFile) throws ProvisioningException {
        try (InputStream is = Files.newInputStream(specsFile, new OpenOption[0]);){
            ModelNode modelNode = ModelNode.fromStream((InputStream)is);
            return modelNode;
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.readFile((Path)specsFile), (Throwable)e);
        }
    }

    private void writeSpecsFile(Path specsFile, ModelNode specs) throws ProvisioningException {
        try (BufferedWriter writer = Files.newBufferedWriter(specsFile, new OpenOption[0]);){
            writer.write(specs.asString());
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.writeFile((Path)specsFile), (Throwable)e);
        }
    }

    void warn(String str) {
        System.out.println("WARN: " + str);
    }

    void debug(String str, Object ... args) {
        if (this.debug) {
            System.out.println(String.format(str, args));
        }
    }
}

