/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigCustomizationsBuilder;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.ConfigXml;
import org.jboss.galleon.xml.FeaturePackPackagesConfigParser10;
import org.jboss.galleon.xml.ProvisioningXmlParser10;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.galleon.maven.FeaturePackDependencySpec;
import org.wildfly.galleon.maven.WildFlyFeaturePackBuild;

class FeaturePackBuildModelParser30
implements XMLElementReader<WildFlyFeaturePackBuild.Builder> {
    public static final String NAMESPACE_3_0 = "urn:wildfly:feature-pack-build:3.0";

    FeaturePackBuildModelParser30() {
    }

    public void readElement(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        FeaturePackLocation fpl = null;
        int count = reader.getAttributeCount();
        block15: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case PRODUCER: {
                    fpl = FeaturePackLocation.fromString((String)reader.getAttributeValue(i));
                    continue block15;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (fpl == null) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.PRODUCER));
        }
        builder.setProducer(fpl);
        block16: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case DEPENDENCIES: {
                            this.parseDependencies(reader, builder);
                            continue block16;
                        }
                        case DEFAULT_PACKAGES: {
                            this.parseDefaultPackages((XMLStreamReader)reader, builder);
                            continue block16;
                        }
                        case PACKAGE_SCHEMAS: {
                            this.parsePackageSchemas((XMLStreamReader)reader, builder);
                            continue block16;
                        }
                        case CONFIG: {
                            ConfigModel.Builder config = ConfigModel.builder();
                            ConfigXml.readConfig((XMLExtendedStreamReader)reader, (ConfigModel.Builder)config);
                            try {
                                builder.addConfig(config.build());
                                continue block16;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException("Failed to create a config model instance", e);
                            }
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseDefaultPackages(XMLStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PACKAGE: {
                            builder.addDefaultPackage(this.parseName(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseDependencies(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case DEPENDENCY: {
                            this.parseDependency(reader, builder);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseDependency(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        FeaturePackLocation fpl = null;
        String groupId = null;
        String artifactId = null;
        String version = null;
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.GROUP_ID, Attribute.ARTIFACT_ID, Attribute.PRODUCER);
        block20: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case GROUP_ID: {
                    groupId = reader.getAttributeValue(i);
                    continue block20;
                }
                case ARTIFACT_ID: {
                    artifactId = reader.getAttributeValue(i);
                    continue block20;
                }
                case PRODUCER: {
                    fpl = FeaturePackLocation.fromString((String)reader.getAttributeValue(i));
                    continue block20;
                }
                case VERSION: {
                    version = reader.getAttributeValue(i);
                    continue block20;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        ArtifactCoords.Gav gav = ArtifactCoords.newGav(groupId, artifactId, version);
        String depName = null;
        FeaturePackConfig.Builder depBuilder = FeaturePackConfig.builder(fpl);
        block21: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    builder.addDependency(gav, FeaturePackDependencySpec.create(depName, depBuilder.build()));
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case NAME: {
                            depName = reader.getElementText().trim();
                            continue block21;
                        }
                        case DEFAULT_CONFIGS: {
                            ProvisioningXmlParser10.parseDefaultConfigs((XMLExtendedStreamReader)reader, (ConfigCustomizationsBuilder)depBuilder);
                            continue block21;
                        }
                        case CONFIG: {
                            ConfigModel.Builder configBuilder = ConfigModel.builder();
                            ConfigXml.readConfig((XMLExtendedStreamReader)reader, (ConfigModel.Builder)configBuilder);
                            try {
                                depBuilder.addConfig(configBuilder.build());
                                continue block21;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException(e);
                            }
                        }
                        case PACKAGES: {
                            try {
                                FeaturePackPackagesConfigParser10.readPackages((XMLStreamReader)reader, (FeaturePackConfig.Builder)depBuilder);
                                continue block21;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException(e);
                            }
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
    }

    private String parseName(XMLStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        return name;
    }

    private void parsePackageSchemas(XMLStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes((XMLStreamReader)reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case GROUP: {
                            builder.addSchemaGroup(this.parseName(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    static enum Attribute implements XmlNameProvider
    {
        ARTIFACT_ID("artifact-id"),
        GROUP_ID("group-id"),
        NAME("name"),
        PRODUCER("producer"),
        VERSION("version"),
        UNKNOWN(null);

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String getNamespace() {
            return null;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>(5);
            attributesMap.put(new QName(ARTIFACT_ID.getLocalName()), ARTIFACT_ID);
            attributesMap.put(new QName(GROUP_ID.getLocalName()), GROUP_ID);
            attributesMap.put(new QName(NAME.getLocalName()), NAME);
            attributesMap.put(new QName(PRODUCER.getLocalName()), PRODUCER);
            attributesMap.put(new QName(VERSION.getLocalName()), VERSION);
            attributes = attributesMap;
        }
    }

    static enum Element {
        BUILD("build"),
        CONFIG("config"),
        DEFAULT_CONFIGS("default-configs"),
        DEFAULT_PACKAGES("default-packages"),
        DEPENDENCIES("dependencies"),
        DEPENDENCY("dependency"),
        GROUP("group"),
        NAME("name"),
        PACKAGE("package"),
        PACKAGES("packages"),
        PACKAGE_SCHEMAS("package-schemas"),
        PRODUCER("producer"),
        UNKNOWN(null);

        private static final Map<QName, Element> elements;
        private final String name;

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>(12);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, BUILD.getLocalName()), BUILD);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, CONFIG.getLocalName()), CONFIG);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, DEFAULT_CONFIGS.getLocalName()), DEFAULT_CONFIGS);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, DEFAULT_PACKAGES.getLocalName()), DEFAULT_PACKAGES);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, DEPENDENCIES.getLocalName()), DEPENDENCIES);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, DEPENDENCY.getLocalName()), DEPENDENCY);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, GROUP.getLocalName()), GROUP);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, NAME.getLocalName()), NAME);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, PACKAGE.getLocalName()), PACKAGE);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, PACKAGES.getLocalName()), PACKAGES);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, PACKAGE_SCHEMAS.getLocalName()), PACKAGE_SCHEMAS);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, PRODUCER.getLocalName()), PRODUCER);
            elements = elementsMap;
        }
    }
}

