/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.util.IoUtils;
import org.wildfly.galleon.maven.ArtifactItem;
import org.wildfly.galleon.maven.ExternalArtifact;
import org.wildfly.galleon.maven.FeatureSpecGeneratorInvoker;
import org.wildfly.galleon.maven.ModuleXmlVersionResolver;

@Mojo(name="generate-feature-specs", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class WfFeatureSpecBuildMojo
extends AbstractMojo {
    private static final String MAVEN_REPO_LOCAL = "maven.repo.local";
    private static final String MODULES = "modules";
    private static final Path MODULE_PATH_SEGMENT = Paths.get("pm", new String[0]).resolve("wildfly").resolve("module").resolve("modules");
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(alias="output-dir", required=true)
    private File outputDirectory;
    @Parameter(alias="feature-packs", required=false)
    private List<ArtifactItem> featurePacks;
    @Parameter(alias="external-artifacts", required=false)
    private List<ExternalArtifact> externalArtifacts;
    @Parameter(alias="standalone-extensions", required=true)
    private List<String> standaloneExtensions;
    @Parameter(alias="domain-extensions", required=true)
    private List<String> domainExtensions;
    @Parameter(alias="host-extensions", required=true)
    private List<String> hostExtensions;
    @Parameter(alias="fork-embedded", required=false)
    private boolean forkEmbedded;
    @Component
    private ArchiverManager archiverManager;
    @Component
    private RepositorySystem repoSystem;
    @Component
    private ArtifactResolver artifactResolver;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        int specsTotal;
        Path wildflyDir;
        long startTime;
        block8: {
            startTime = System.currentTimeMillis();
            Path modulesDir = null;
            wildflyDir = null;
            specsTotal = -1;
            try {
                modulesDir = Files.createTempDirectory(MODULES, new FileAttribute[0]);
                wildflyDir = Files.createTempDirectory("wf-specs-dist", new FileAttribute[0]);
                specsTotal = this.doExecute(wildflyDir, modulesDir);
                if (modulesDir == null) break block8;
            }
            catch (Error | RuntimeException | MojoExecutionException | MojoFailureException e) {
                try {
                    throw e;
                    catch (IOException | MavenFilteringException ex) {
                        throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
                    }
                }
                catch (Throwable throwable) {
                    if (modulesDir != null) {
                        IoUtils.recursiveDelete((Path)modulesDir);
                    }
                    if (wildflyDir != null) {
                        IoUtils.recursiveDelete(wildflyDir);
                    }
                    if (!this.getLog().isDebugEnabled()) throw throwable;
                    if (specsTotal < 0) throw throwable;
                    long totalTime = System.currentTimeMillis() - startTime;
                    long secs = totalTime / 1000L;
                    this.debug("Generated " + specsTotal + " feature specs in " + secs + "." + (totalTime - secs * 1000L) + " secs", new Object[0]);
                    throw throwable;
                }
            }
            IoUtils.recursiveDelete((Path)modulesDir);
        }
        if (wildflyDir != null) {
            IoUtils.recursiveDelete((Path)wildflyDir);
        }
        if (!this.getLog().isDebugEnabled()) return;
        if (specsTotal < 0) return;
        long totalTime = System.currentTimeMillis() - startTime;
        long secs = totalTime / 1000L;
        this.debug("Generated " + specsTotal + " feature specs in " + secs + "." + (totalTime - secs * 1000L) + " secs", new Object[0]);
    }

    private int doExecute(Path wildflyDir, Path modulesDir) throws MojoExecutionException, MojoFailureException, MavenFilteringException, IOException {
        Files.createDirectories(wildflyDir.resolve("standalone").resolve("configuration"), new FileAttribute[0]);
        Files.createDirectories(wildflyDir.resolve("domain").resolve("configuration"), new FileAttribute[0]);
        Files.createDirectories(wildflyDir.resolve("bin"), new FileAttribute[0]);
        Files.createFile(wildflyDir.resolve("bin").resolve("jboss-cli-logging.properties"), new FileAttribute[0]);
        this.copyJbossModule(wildflyDir);
        ArrayList<Artifact> featurePackArtifacts = new ArrayList<Artifact>();
        Set<String> inheritedFeatures = this.getInheritedFeatures(modulesDir, featurePackArtifacts);
        Map<String, Artifact> buildArtifacts = this.collectBuildArtifacts(modulesDir, featurePackArtifacts);
        ArrayList<Artifact> hardcodedArtifacts = new ArrayList<Artifact>();
        ModuleXmlVersionResolver.filterAndConvertModules(modulesDir, wildflyDir.resolve(MODULES), buildArtifacts, hardcodedArtifacts, this.getLog());
        Path modulesTemplates = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("resources").resolve(MODULES);
        if (Files.exists(modulesTemplates, new LinkOption[0])) {
            ModuleXmlVersionResolver.filterAndConvertModules(modulesTemplates, wildflyDir.resolve(MODULES), buildArtifacts, hardcodedArtifacts, this.getLog());
        }
        this.addBasicConfigs(wildflyDir);
        for (Artifact art : hardcodedArtifacts) {
            this.findArtifact(art);
        }
        URL[] specGenCp = new URL[3];
        Artifact artifact = (Artifact)this.project.getPluginArtifactMap().get("org.wildfly.galleon-plugins:wildfly-galleon-maven-plugin");
        specGenCp[0] = this.resolveArtifact(artifact.getGroupId(), "wildfly-feature-spec-gen", artifact.getVersion(), null, "jar").toURI().toURL();
        artifact = buildArtifacts.get("org.jboss.modules:jboss-modules");
        specGenCp[1] = this.resolveArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), null, "jar").toURI().toURL();
        artifact = buildArtifacts.get("org.wildfly.core:wildfly-cli");
        specGenCp[2] = this.resolveArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "client", "jar").toURI().toURL();
        String originalMavenRepoLocal = System.getProperty(MAVEN_REPO_LOCAL);
        System.setProperty(MAVEN_REPO_LOCAL, this.session.getSettings().getLocalRepository());
        this.debug("Generating feature specs using local maven repo %s", System.getProperty(MAVEN_REPO_LOCAL));
        try {
            int n = FeatureSpecGeneratorInvoker.generateSpecs(wildflyDir, inheritedFeatures, this.outputDirectory.toPath(), specGenCp, this.forkEmbedded, this.getLog());
            return n;
        }
        catch (ProvisioningException e) {
            throw new MojoExecutionException("Feature spec generator failed", (Exception)((Object)e));
        }
        finally {
            if (originalMavenRepoLocal == null) {
                System.clearProperty(MAVEN_REPO_LOCAL);
            } else {
                System.setProperty(MAVEN_REPO_LOCAL, originalMavenRepoLocal);
            }
        }
    }

    private File resolveArtifact(String groupId, String artifactId, String version, String classifier, String extension) throws MojoExecutionException {
        ArtifactItem item = new ArtifactItem();
        item.setArtifactId(artifactId);
        item.setGroupId(groupId);
        item.setVersion(version);
        if (classifier != null) {
            item.setClassifier(classifier);
        }
        if (extension != null) {
            item.setExtension(extension);
        }
        return this.findArtifact(item).getFile();
    }

    private void addBasicConfigs(Path wildfly) throws IOException {
        ArrayList<String> lines = new ArrayList<String>(this.standaloneExtensions.size() + 5);
        lines.add("<?xml version='1.0' encoding='UTF-8'?>");
        lines.add("<server xmlns=\"urn:jboss:domain:6.0\">");
        lines.add("<extensions>");
        for (String extension : this.standaloneExtensions) {
            lines.add(String.format("<extension module=\"%s\"/>", extension));
        }
        lines.add("</extensions>");
        lines.add("</server>");
        Files.write(wildfly.resolve("standalone").resolve("configuration").resolve("standalone.xml"), lines, new OpenOption[0]);
        lines.clear();
        lines.add("<?xml version='1.0' encoding='UTF-8'?>");
        lines.add("<domain xmlns=\"urn:jboss:domain:6.0\">");
        lines.add("<extensions>");
        for (String extension : this.domainExtensions) {
            lines.add(String.format("<extension module=\"%s\"/>", extension));
        }
        lines.add("</extensions>");
        lines.add("</domain>");
        Files.write(wildfly.resolve("domain").resolve("configuration").resolve("domain.xml"), lines, new OpenOption[0]);
        lines.clear();
        lines.add("<?xml version='1.0' encoding='UTF-8'?>");
        lines.add("<host xmlns=\"urn:jboss:domain:6.0\" name=\"master\">");
        lines.add("<extensions>");
        for (String extension : this.hostExtensions) {
            lines.add(String.format("<extension module=\"%s\"/>", extension));
        }
        lines.add("</extensions>");
        lines.add("<management>");
        lines.add("<management-interfaces>");
        lines.add("<http-interface security-realm=\"ManagementRealm\">");
        lines.add("<http-upgrade enabled=\"true\"/>");
        lines.add("<socket interface=\"management\" port=\"${jboss.management.http.port:9990}\"/>");
        lines.add("</http-interface>");
        lines.add("</management-interfaces>");
        lines.add("</management>");
        lines.add("<domain-controller>");
        lines.add("<local />");
        lines.add("</domain-controller>");
        lines.add("<interfaces>");
        lines.add("<interface name=\"management\">");
        lines.add("<inet-address value=\"127.0.0.1\"/>");
        lines.add("</interface>");
        lines.add("</interfaces>");
        lines.add("</host>");
        Files.write(wildfly.resolve("domain").resolve("configuration").resolve("host.xml"), lines, new OpenOption[0]);
    }

    private Map<String, Artifact> collectBuildArtifacts(Path tmpModules, List<Artifact> featurePackArtifacts) throws MojoExecutionException, IOException {
        HashMap<String, Artifact> artifacts = new HashMap<String, Artifact>();
        for (Artifact artifact : this.project.getArtifacts()) {
            this.registerArtifact(artifacts, artifact);
        }
        for (Artifact featurePackArtifact : featurePackArtifacts) {
            this.prepareArtifacts(artifacts, featurePackArtifact);
        }
        if (this.externalArtifacts == null || this.externalArtifacts.isEmpty()) {
            return artifacts;
        }
        for (ExternalArtifact fp : this.externalArtifacts) {
            IncludeExcludeFileSelector selector = new IncludeExcludeFileSelector();
            selector.setIncludes(StringUtils.split((String)fp.getIncludes(), (String)","));
            selector.setExcludes(StringUtils.split((String)fp.getExcludes(), (String)","));
            IncludeExcludeFileSelector[] selectors = new IncludeExcludeFileSelector[]{selector};
            Artifact fpArtifact = this.findArtifact(fp.getArtifactItem());
            if (fpArtifact == null) {
                this.getLog().warn((CharSequence)("No artifact was found for " + fp));
                continue;
            }
            this.prepareArtifacts(artifacts, fpArtifact);
            File archive = fpArtifact.getFile();
            Path target = tmpModules.resolve(MODULES).resolve(fp.getToLocation());
            Files.createDirectories(target, new FileAttribute[0]);
            try {
                UnArchiver unArchiver;
                try {
                    unArchiver = this.archiverManager.getUnArchiver(fpArtifact.getType());
                    this.debug("Found unArchiver by type: %s", unArchiver);
                }
                catch (NoSuchArchiverException e) {
                    unArchiver = this.archiverManager.getUnArchiver(archive);
                    this.debug("Found unArchiver by extension: %s", unArchiver);
                }
                unArchiver.setFileSelectors((FileSelector[])selectors);
                unArchiver.setSourceFile(archive);
                unArchiver.setDestDirectory(target.toFile());
                unArchiver.extract();
            }
            catch (NoSuchArchiverException ex) {
                this.getLog().warn((Throwable)ex);
            }
        }
        return artifacts;
    }

    private void registerArtifact(Map<String, Artifact> artifacts, Artifact artifact) {
        String key = this.getArtifactKey(artifact);
        this.debug("Registering %s for key %s", artifact.toString(), key);
        artifacts.putIfAbsent(key, artifact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getInheritedFeatures(Path tmpModules, List<Artifact> featurePackArtifacts) throws MojoExecutionException, IOException {
        if (this.featurePacks == null || this.featurePacks.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> inheritedFeatures = new HashSet<String>(500);
        IncludeExcludeFileSelector selector = new IncludeExcludeFileSelector();
        selector.setIncludes(new String[]{"**/**/module/modules/**/*", "features/**"});
        IncludeExcludeFileSelector[] selectors = new IncludeExcludeFileSelector[]{selector};
        for (ArtifactItem fp : this.featurePacks) {
            Artifact fpArtifact = this.findArtifact(fp);
            if (fpArtifact == null) {
                this.getLog().warn((CharSequence)("No artifact was found for " + fp));
                continue;
            }
            featurePackArtifacts.add(fpArtifact);
            File archive = fpArtifact.getFile();
            Path tmpArchive = Files.createTempDirectory(fp.getGroupId() + '_' + fp.getArtifactId() + '_' + fp.getVersion(), new FileAttribute[0]);
            try {
                UnArchiver unArchiver;
                try {
                    unArchiver = this.archiverManager.getUnArchiver(fpArtifact.getType());
                    this.debug("Found unArchiver by type: %s", unArchiver);
                }
                catch (NoSuchArchiverException e) {
                    unArchiver = this.archiverManager.getUnArchiver(archive);
                    this.debug("Found unArchiver by extension: %s", unArchiver);
                }
                unArchiver.setFileSelectors((FileSelector[])selectors);
                unArchiver.setSourceFile(archive);
                unArchiver.setDestDirectory(tmpArchive.toFile());
                unArchiver.extract();
                Path fpDir = tmpArchive.resolve("features");
                if (Files.exists(fpDir, new LinkOption[0])) {
                    try (Stream<Path> children = Files.list(fpDir);){
                        List features = children.map(Path::getFileName).map(Path::toString).collect(Collectors.toList());
                        for (String feature : features) {
                            inheritedFeatures.add(feature);
                        }
                    }
                }
                if (!Files.exists(fpDir = tmpArchive.resolve("packages"), new LinkOption[0])) continue;
                this.setModules(fpDir, tmpModules.resolve(MODULES));
            }
            catch (NoSuchArchiverException ex) {
                this.getLog().warn((Throwable)ex);
            }
            finally {
                IoUtils.recursiveDelete((Path)tmpArchive);
            }
        }
        return inheritedFeatures;
    }

    private void copyJbossModule(Path wildfly) throws IOException, MojoExecutionException {
        for (Dependency dep : this.project.getDependencyManagement().getDependencies()) {
            if (!"org.jboss.modules".equals(dep.getGroupId()) || !"jboss-modules".equals(dep.getArtifactId())) continue;
            ArtifactItem jbossModule = new ArtifactItem();
            jbossModule.setArtifactId(dep.getArtifactId());
            jbossModule.setGroupId(dep.getGroupId());
            jbossModule.setVersion(dep.getVersion());
            jbossModule.setType(dep.getType());
            jbossModule.setClassifier(dep.getClassifier());
            File jbossModuleJar = this.findArtifact(jbossModule).getFile();
            this.debug("Copying %s to %s", jbossModuleJar.toPath(), wildfly.resolve("jboss-modules.jar"));
            Files.copy(jbossModuleJar.toPath(), wildfly.resolve("jboss-modules.jar"), new CopyOption[0]);
        }
    }

    private void setModules(Path fpDirectory, final Path moduleDir) throws IOException {
        Files.walkFileTree(fpDirectory, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (dir.endsWith(MODULE_PATH_SEGMENT)) {
                    WfFeatureSpecBuildMojo.this.debug("Copying %s to %s", new Object[]{dir, moduleDir});
                    IoUtils.copy((Path)dir, (Path)moduleDir);
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private Artifact findArtifact(ArtifactItem artifact) throws MojoExecutionException {
        this.resolveVersion(artifact);
        try {
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            buildingRequest.setLocalRepository(this.session.getLocalRepository());
            buildingRequest.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
            this.debug("Resolving artifact %s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            org.apache.maven.shared.artifact.resolve.ArtifactResult result = this.artifactResolver.resolveArtifact((ProjectBuildingRequest)buildingRequest, (ArtifactCoordinate)artifact);
            if (result != null) {
                return result.getArtifact();
            }
            return null;
        }
        catch (ArtifactResolverException e) {
            throw new MojoExecutionException("Couldn't resolve artifact: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private Artifact findArtifact(Artifact artifact) throws MojoExecutionException {
        try {
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            buildingRequest.setLocalRepository(this.session.getLocalRepository());
            buildingRequest.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
            this.debug("Resolving artifact %s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            org.apache.maven.shared.artifact.resolve.ArtifactResult result = this.artifactResolver.resolveArtifact((ProjectBuildingRequest)buildingRequest, artifact);
            if (result != null) {
                return result.getArtifact();
            }
            return artifact;
        }
        catch (ArtifactResolverException e) {
            throw new MojoExecutionException("Couldn't resolve artifact: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private String getArtifactKey(Artifact artifact) {
        StringBuilder buf = new StringBuilder(artifact.getGroupId()).append(':').append(artifact.getArtifactId());
        String classifier = artifact.getClassifier();
        if (classifier != null && !classifier.isEmpty()) {
            buf.append("::").append(classifier);
        }
        return buf.toString();
    }

    private void resolveVersion(ArtifactItem artifact) {
        Artifact managedArtifact;
        if (artifact.getVersion() == null && (managedArtifact = (Artifact)this.project.getManagedVersionMap().get(artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + artifact.getType())) != null) {
            artifact.setVersion(managedArtifact.getVersion());
        }
    }

    private void prepareArtifacts(Map<String, Artifact> artifacts, Artifact artifact) throws MojoExecutionException {
        try {
            CollectRequest request = new CollectRequest();
            request.setRepositories(this.project.getRemoteProjectRepositories());
            DefaultArtifact root = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), null, artifact.getVersion(), (ArtifactType)new DefaultArtifactType(artifact.getType()));
            org.eclipse.aether.graph.Dependency dep = new org.eclipse.aether.graph.Dependency((org.eclipse.aether.artifact.Artifact)root, null);
            request.setRoot(dep);
            CollectResult result = this.repoSystem.collectDependencies(this.session.getRepositorySession(), request);
            this.resolveDependency(result.getRoot(), artifacts);
        }
        catch (DependencyCollectionException e) {
            this.getLog().error((CharSequence)("Couldn't download artifact: " + e.getMessage()), (Throwable)e);
        }
    }

    private void resolveDependency(DependencyNode node, Map<String, Artifact> artifacts) {
        org.eclipse.aether.artifact.Artifact aetherArtifact = this.getArtifact(node.getArtifact());
        if (aetherArtifact == null) {
            return;
        }
        this.registerArtifact(artifacts, RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)aetherArtifact));
        for (DependencyNode child : node.getChildren()) {
            this.resolveDependency(child, artifacts);
        }
    }

    private org.eclipse.aether.artifact.Artifact getArtifact(org.eclipse.aether.artifact.Artifact artifact) {
        try {
            ArtifactRequest request = new ArtifactRequest();
            request.setRepositories(this.project.getRemoteProjectRepositories());
            request.setArtifact(artifact);
            ArtifactResult result = this.repoSystem.resolveArtifact(this.session.getRepositorySession(), request);
            return result.getArtifact();
        }
        catch (ArtifactResolutionException e) {
            this.getLog().error((CharSequence)("Couldn't download artifact: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private void debug(String format, Object ... args) {
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)String.format(format, args));
        }
    }
}

