/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.spec.CapabilitySpec;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.CollectionUtils;
import org.wildfly.galleon.maven.FeaturePackDependencySpec;

public class WildFlyFeaturePackBuild {
    private final FeaturePackLocation producer;
    private final Map<ArtifactCoords.Gav, FeaturePackDependencySpec> dependencies;
    private final Set<String> schemaGroups;
    private final Set<String> defaultPackages;
    private final List<ConfigModel> configs;

    public static Builder builder() {
        return new Builder();
    }

    private WildFlyFeaturePackBuild(Builder builder) {
        this.producer = builder.producer;
        this.dependencies = CollectionUtils.unmodifiable((Map)builder.dependencies);
        this.schemaGroups = CollectionUtils.unmodifiable((Set)builder.schemaGroups);
        this.defaultPackages = CollectionUtils.unmodifiable((Set)builder.defaultPackages);
        this.configs = CollectionUtils.unmodifiable((List)builder.configs);
    }

    public FeaturePackLocation getProducer() {
        return this.producer;
    }

    public Collection<String> getDefaultPackages() {
        return this.defaultPackages;
    }

    public Map<ArtifactCoords.Gav, FeaturePackDependencySpec> getDependencies() {
        return this.dependencies;
    }

    public boolean hasSchemaGroups() {
        return !this.schemaGroups.isEmpty();
    }

    public boolean isSchemaGroup(String groupId) {
        return this.schemaGroups.contains(groupId);
    }

    public Set<String> getSchemaGroups() {
        return this.schemaGroups;
    }

    public boolean hasConfigs() {
        return !this.configs.isEmpty();
    }

    public List<ConfigModel> getConfigs() {
        return this.configs;
    }

    public static class Builder {
        private FeaturePackLocation producer;
        private Map<ArtifactCoords.Gav, FeaturePackDependencySpec> dependencies = Collections.emptyMap();
        private Set<String> schemaGroups = Collections.emptySet();
        private Set<String> defaultPackages = Collections.emptySet();
        private List<ConfigModel> configs = Collections.emptyList();

        private Builder() {
        }

        public Builder setProducer(FeaturePackLocation producer) {
            this.producer = producer;
            return this;
        }

        public Builder addDefaultPackage(String packageName) {
            this.defaultPackages = CollectionUtils.add(this.defaultPackages, (Object)packageName);
            return this;
        }

        public Builder addDependency(ArtifactCoords.Gav gav, FeaturePackDependencySpec dependency) {
            this.dependencies = CollectionUtils.put(this.dependencies, (Object)gav, (Object)dependency);
            return this;
        }

        public Builder addSchemaGroup(String groupId) {
            this.schemaGroups = CollectionUtils.add(this.schemaGroups, (Object)groupId);
            return this;
        }

        public Builder addConfig(ConfigModel config) {
            this.configs = CollectionUtils.add(this.configs, (Object)config);
            return this;
        }

        public WildFlyFeaturePackBuild build() {
            return new WildFlyFeaturePackBuild(this);
        }

        void providesCapability(CapabilitySpec cap) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

