/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

class MavenProjectArtifactVersions {
    private final Map<String, String> versions = new TreeMap<String, String>();

    static MavenProjectArtifactVersions getInstance(MavenProject project) {
        return new MavenProjectArtifactVersions(project);
    }

    private MavenProjectArtifactVersions(MavenProject project) {
        for (Artifact artifact : project.getArtifacts()) {
            StringBuilder buf = new StringBuilder(artifact.getGroupId()).append(':').append(artifact.getArtifactId());
            String classifier = artifact.getClassifier();
            StringBuilder version = new StringBuilder(buf);
            version.append(':').append(artifact.getVersion()).append(':');
            if (classifier != null && !classifier.isEmpty()) {
                buf.append("::").append(classifier);
                version.append(classifier);
            }
            this.versions.put(buf.toString(), version.append(':').append(artifact.getType()).toString());
        }
    }

    String getVersion(String gac) {
        return this.versions.get(gac);
    }

    void remove(String groupId, String artifactId) {
        this.versions.remove(groupId + ':' + artifactId);
    }

    void store(Path target) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(target, StandardOpenOption.CREATE);){
            for (Map.Entry<String, String> entry : this.versions.entrySet()) {
                writer.write(entry.getKey());
                writer.write(61);
                writer.write(entry.getValue());
                writer.newLine();
            }
        }
    }
}

