/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseFactoryLoader;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.IoUtils;
import org.wildfly.galleon.maven.ArtifactCoordsUtil;
import org.wildfly.galleon.maven.ArtifactItem;
import org.wildfly.galleon.maven.FeaturePackDependencySpec;
import org.wildfly.galleon.maven.FeatureSpecGeneratorInvoker;
import org.wildfly.galleon.maven.MavenProjectArtifactVersions;
import org.wildfly.galleon.maven.ModuleXmlVersionResolver;
import org.wildfly.galleon.maven.Util;
import org.wildfly.galleon.maven.WildFlyFeaturePackBuild;
import org.wildfly.galleon.plugin.Utils;
import org.wildfly.galleon.plugin.WildFlyPackageTask;
import org.wildfly.galleon.plugin.WildFlyPackageTasks;
import org.wildfly.galleon.plugin.config.CopyArtifact;
import org.wildfly.galleon.plugin.config.WildFlyPackageTasksParser;

@Mojo(name="generate-feature-specs", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class WfFeatureSpecBuildMojo
extends AbstractMojo {
    private static final String MAVEN_REPO_LOCAL = "maven.repo.local";
    private static final String MODULES = "modules";
    private static final Path MODULE_PATH_SEGMENT;
    private static final Path TASKS_XML_PATH_END;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repositories;
    @Parameter(alias="output-dir", required=true)
    private File outputDirectory;
    @Parameter(alias="config-dir", defaultValue="${basedir}", property="wildfly.feature.pack.configDir")
    private File configDir;
    @Parameter(alias="config-file", defaultValue="wildfly-feature-pack-build.xml", property="wildfly.feature.pack.configFile")
    private String configFile;
    @Parameter(alias="fork-embedded", required=false)
    private boolean forkEmbedded;
    @Parameter(alias="wildfly-home", property="wfgp.wildflyHome", defaultValue="${project.build.directory}/wildfly", required=true)
    private Path wildflyHome;
    @Parameter(alias="module-templates", property="wfgp.moduleTemplatesDir", defaultValue="${project.build.directory}/module-templates", required=true)
    private Path moduleTemplatesDir;
    @Component
    private ArchiverManager archiverManager;
    @Component
    private RepositorySystem repoSystem;
    @Component
    private ArtifactResolver artifactResolver;
    private Map<String, Artifact> mergedArtifacts = new HashMap<String, Artifact>();
    private Map<Path, Map<String, Artifact>> moduleTemplates = new HashMap<Path, Map<String, Artifact>>();
    private Set<String> inheritedFeatureSpecs = Collections.emptySet();
    private Set<String> standaloneExtensions = Collections.emptySet();
    private Set<String> domainExtensions = Collections.emptySet();
    private Set<String> hostExtensions = Collections.emptySet();
    private List<Path> layersConfs = Collections.emptyList();
    private WildFlyPackageTasksParser tasksParser;

    public void execute() throws MojoExecutionException, MojoFailureException {
        long startTime = System.currentTimeMillis();
        int specsTotal = -1;
        try {
            IoUtils.recursiveDelete((Path)this.moduleTemplatesDir);
            Files.createDirectories(this.moduleTemplatesDir, new FileAttribute[0]);
            IoUtils.recursiveDelete((Path)this.wildflyHome);
            Files.createDirectories(this.wildflyHome, new FileAttribute[0]);
            specsTotal = this.doExecute();
        }
        catch (Error | RuntimeException | MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (IOException | MavenFilteringException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
        finally {
            if (this.getLog().isDebugEnabled() && specsTotal >= 0) {
                long totalTime = System.currentTimeMillis() - startTime;
                long secs = totalTime / 1000L;
                this.debug("Generated " + specsTotal + " feature specs in " + secs + "." + (totalTime - secs * 1000L) + " secs", new Object[0]);
            }
        }
    }

    public void setWildflyHome(String wildflyHome) {
        this.wildflyHome = Paths.get(wildflyHome, new String[0]);
    }

    public void setModuleTemplatesDir(String moduleTemplatesDir) {
        this.moduleTemplatesDir = Paths.get(moduleTemplatesDir, new String[0]);
    }

    private int doExecute() throws MojoExecutionException, MojoFailureException, MavenFilteringException, IOException {
        Path projectModules;
        Files.createDirectories(this.wildflyHome.resolve("bin"), new FileAttribute[0]);
        Files.createFile(this.wildflyHome.resolve("bin").resolve("jboss-cli-logging.properties"), new FileAttribute[0]);
        WildFlyFeaturePackBuild buildConfig = Util.loadFeaturePackBuildConfig(this.configDir, this.configFile);
        if (buildConfig.hasStandaloneExtensions()) {
            Files.createDirectories(this.wildflyHome.resolve("standalone").resolve("configuration"), new FileAttribute[0]);
            this.standaloneExtensions = new HashSet<String>(buildConfig.getStandaloneExtensions());
        }
        if (buildConfig.hasDomainExtensions() || buildConfig.hasHostExtensions()) {
            Files.createDirectories(this.wildflyHome.resolve("domain").resolve("configuration"), new FileAttribute[0]);
            this.domainExtensions = new HashSet<String>(buildConfig.getDomainExtensions());
            this.hostExtensions = new HashSet<String>(buildConfig.getHostExtensions());
        }
        this.processFeaturePackDeps(buildConfig);
        for (Artifact artifact : this.project.getArtifacts()) {
            this.registerArtifact(artifact, null);
        }
        Path projectResources = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("resources");
        Path packagesDir = projectResources.resolve("packages");
        if (Files.exists(packagesDir, new LinkOption[0])) {
            this.findAndCopyModules(packagesDir, this.mergedArtifacts);
            Path fpLayersConf = packagesDir.resolve("layers.conf");
            if (Files.exists(fpLayersConf, new LinkOption[0])) {
                if (!Files.exists(fpLayersConf = fpLayersConf.resolve("content").resolve(MODULES).resolve("layers.conf"), new LinkOption[0])) {
                    throw new MojoExecutionException("Package layers.conf is expected to contain modules/layers.conf but it does not");
                }
                this.layersConfs = CollectionUtils.add(this.layersConfs, (Object)fpLayersConf);
            }
            if (!this.layersConfs.isEmpty()) {
                try {
                    Utils.mergeLayersConfs(this.layersConfs, (Path)this.wildflyHome);
                }
                catch (ProvisioningException e) {
                    throw new MojoExecutionException("Failed to install layers.conf", (Exception)((Object)e));
                }
            }
        }
        if (Files.exists(projectModules = projectResources.resolve(MODULES), new LinkOption[0])) {
            this.copyModules(projectModules, this.mergedArtifacts);
        }
        if (!this.moduleTemplates.isEmpty()) {
            ArrayList<Artifact> hardcodedArtifacts = new ArrayList<Artifact>();
            Path targetModules = this.wildflyHome.resolve(MODULES);
            for (Map.Entry<Path, Map<String, Artifact>> entry : this.moduleTemplates.entrySet()) {
                try {
                    ModuleXmlVersionResolver.convertModule(this.moduleTemplatesDir.resolve(entry.getKey()), targetModules.resolve(entry.getKey()), entry.getValue(), hardcodedArtifacts, this.getLog());
                }
                catch (XMLStreamException e) {
                    throw new MojoExecutionException("Failed to process " + this.moduleTemplatesDir.resolve(entry.getKey()), (Exception)e);
                }
            }
            for (Artifact art : hardcodedArtifacts) {
                this.findArtifact(art);
            }
        }
        this.addBasicConfigs();
        Path jbossModules = this.wildflyHome.resolve("jboss-modules.jar");
        if (!Files.exists(jbossModules, new LinkOption[0])) {
            throw new MojoExecutionException(jbossModules + " is missing");
        }
        URL[] specGenCp = new URL[]{this.resolveArtifact(this.mergedArtifacts, "org.wildfly.galleon-plugins", "wildfly-feature-spec-gen", null).toURI().toURL(), jbossModules.toUri().toURL(), this.resolveArtifact(this.mergedArtifacts, "org.wildfly.core", "wildfly-cli", "client").toURI().toURL()};
        String originalMavenRepoLocal = System.getProperty(MAVEN_REPO_LOCAL);
        System.setProperty(MAVEN_REPO_LOCAL, this.session.getSettings().getLocalRepository());
        this.debug("Generating feature specs using local maven repo %s", System.getProperty(MAVEN_REPO_LOCAL));
        try {
            int art = FeatureSpecGeneratorInvoker.generateSpecs(this.wildflyHome, this.inheritedFeatureSpecs, this.outputDirectory.toPath(), specGenCp, this.forkEmbedded, this.getLog());
            return art;
        }
        catch (ProvisioningException e) {
            throw new MojoExecutionException("Feature spec generator failed", (Exception)((Object)e));
        }
        finally {
            if (originalMavenRepoLocal == null) {
                System.clearProperty(MAVEN_REPO_LOCAL);
            } else {
                System.setProperty(MAVEN_REPO_LOCAL, originalMavenRepoLocal);
            }
        }
    }

    private File resolveArtifact(Map<String, Artifact> buildArtifacts, String groupId, String artifactId, String classifier) throws MojoExecutionException {
        File f;
        Artifact artifact = buildArtifacts.get(groupId + ':' + artifactId);
        if (artifact == null) {
            throw new MojoExecutionException("Failed to locate " + groupId + ':' + artifactId + " among the project build artifacts");
        }
        if (artifact.getFile() != null && (classifier == null && artifact.getClassifier() == null || classifier != null && classifier.equals(artifact.getClassifier()))) {
            return artifact.getFile();
        }
        ArtifactItem item = new ArtifactItem();
        item.setArtifactId(artifact.getArtifactId());
        item.setGroupId(artifact.getGroupId());
        item.setVersion(artifact.getVersion());
        if (classifier != null && !classifier.isEmpty()) {
            item.setClassifier(classifier);
        }
        File file = f = (artifact = this.findArtifact(item)) == null ? null : artifact.getFile();
        if (f == null) {
            throw new MojoExecutionException("Failed to resolve artifact " + item);
        }
        return f;
    }

    private void addBasicConfigs() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        if (!this.standaloneExtensions.isEmpty()) {
            lines.add("<?xml version='1.0' encoding='UTF-8'?>");
            lines.add("<server xmlns=\"urn:jboss:domain:6.0\">");
            lines.add("<extensions>");
            for (String extension : this.standaloneExtensions) {
                lines.add(String.format("<extension module=\"%s\"/>", extension));
            }
            lines.add("</extensions>");
            lines.add("</server>");
            Files.write(this.wildflyHome.resolve("standalone").resolve("configuration").resolve("standalone.xml"), lines, new OpenOption[0]);
        }
        if (!this.domainExtensions.isEmpty()) {
            lines.clear();
            lines.add("<?xml version='1.0' encoding='UTF-8'?>");
            lines.add("<domain xmlns=\"urn:jboss:domain:6.0\">");
            lines.add("<extensions>");
            for (String extension : this.domainExtensions) {
                lines.add(String.format("<extension module=\"%s\"/>", extension));
            }
            lines.add("</extensions>");
            lines.add("</domain>");
            Files.write(this.wildflyHome.resolve("domain").resolve("configuration").resolve("domain.xml"), lines, new OpenOption[0]);
        }
        if (!this.hostExtensions.isEmpty()) {
            lines.clear();
            lines.add("<?xml version='1.0' encoding='UTF-8'?>");
            lines.add("<host xmlns=\"urn:jboss:domain:6.0\" name=\"master\">");
            lines.add("<extensions>");
            for (String extension : this.hostExtensions) {
                lines.add(String.format("<extension module=\"%s\"/>", extension));
            }
            lines.add("</extensions>");
            lines.add("<management>");
            lines.add("<management-interfaces>");
            lines.add("<http-interface security-realm=\"ManagementRealm\">");
            lines.add("<http-upgrade enabled=\"true\"/>");
            lines.add("<socket interface=\"management\" port=\"${jboss.management.http.port:9990}\"/>");
            lines.add("</http-interface>");
            lines.add("</management-interfaces>");
            lines.add("</management>");
            lines.add("<domain-controller>");
            lines.add("<local />");
            lines.add("</domain-controller>");
            lines.add("<interfaces>");
            lines.add("<interface name=\"management\">");
            lines.add("<inet-address value=\"127.0.0.1\"/>");
            lines.add("</interface>");
            lines.add("</interfaces>");
            lines.add("</host>");
            Files.write(this.wildflyHome.resolve("domain").resolve("configuration").resolve("host.xml"), lines, new OpenOption[0]);
        }
    }

    private void copyArtifact(CopyArtifact task, Map<String, Artifact> artifacts) throws IOException {
        String location;
        String artifactCoords = task.getArtifact();
        ArtifactCoords coords = ArtifactCoordsUtil.fromJBossModules(artifactCoords, "jar");
        Artifact artifact = null;
        if (coords.getVersion() == null) {
            artifact = artifacts.get(artifactCoords);
        }
        if (artifact == null) {
            ArtifactItem item = new ArtifactItem();
            item.setGroupId(coords.getGroupId());
            item.setArtifactId(coords.getArtifactId());
            item.setVersion(coords.getVersion());
            item.setClassifier(coords.getClassifier());
            item.setType(coords.getExtension());
            try {
                artifact = this.findArtifact(item);
            }
            catch (MojoExecutionException e) {
                if (task.isOptional()) {
                    return;
                }
                throw new IOException("Failed to resolve " + coords, e);
            }
            if (artifact == null) {
                if (task.isOptional()) {
                    return;
                }
                throw new IOException("Failed to resolve " + coords);
            }
        }
        if (!(location = task.getToLocation()).isEmpty() && location.charAt(location.length() - 1) == '/') {
            location = location + artifact.getFile().getName();
        }
        Path target = this.wildflyHome.resolve(location);
        Path src = artifact.getFile().toPath();
        this.debug("Copying artifact %s to %s", src, target);
        if (task.isExtract()) {
            Utils.extractArtifact((Path)src, (Path)target, (CopyArtifact)task);
        } else {
            IoUtils.copy((Path)src, (Path)target);
        }
    }

    private void registerArtifact(Artifact artifact, Map<String, Artifact> artifacts) {
        String key = this.getArtifactKey(artifact);
        this.debug("Registering %s for key %s", artifact.toString(), key);
        if (artifacts != null) {
            artifacts.put(key, artifact);
        }
        this.mergedArtifacts.put(key, artifact);
    }

    private void processFeaturePackDeps(WildFlyFeaturePackBuild buildConfig) throws MojoExecutionException, IOException {
        Map<ArtifactCoords.Gav, FeaturePackDependencySpec> fpDeps = buildConfig.getDependencies();
        if (fpDeps.isEmpty()) {
            return;
        }
        MavenProjectArtifactVersions artifactVersions = MavenProjectArtifactVersions.getInstance(this.project);
        MavenArtifactRepositoryManager mvnRepo = new MavenArtifactRepositoryManager(this.repoSystem, this.session.getRepositorySession(), this.repositories);
        UniverseFactoryLoader ufl = UniverseFactoryLoader.getInstance().addArtifactResolver((RepositoryArtifactResolver)mvnRepo);
        try (ProvisioningLayoutFactory layoutFactory = ProvisioningLayoutFactory.getInstance((UniverseResolver)UniverseResolver.builder((UniverseFactoryLoader)ufl).build());){
            ProvisioningConfig.Builder configBuilder = ProvisioningConfig.builder();
            for (Map.Entry<ArtifactCoords.Gav, FeaturePackDependencySpec> entry : fpDeps.entrySet()) {
                Path p;
                ArtifactCoords depCoords = entry.getKey().toArtifactCoords();
                String ext = "zip";
                if (depCoords.getVersion() == null) {
                    String coordsStr = artifactVersions.getVersion(depCoords.getGroupId() + ':' + depCoords.getArtifactId());
                    if (coordsStr == null) {
                        throw new MojoExecutionException("Failed resolve artifact version for " + depCoords);
                    }
                    depCoords = ArtifactCoordsUtil.fromJBossModules(coordsStr, ext);
                    if (!depCoords.getExtension().equals("pom")) {
                        ext = depCoords.getExtension();
                    }
                }
                ArtifactItem artifact = new ArtifactItem();
                artifact.setGroupId(depCoords.getGroupId());
                artifact.setArtifactId(depCoords.getArtifactId());
                artifact.setVersion(depCoords.getVersion());
                artifact.setType(ext);
                Artifact resolved = this.findArtifact(artifact);
                if (resolved == null) {
                    throw new MojoExecutionException("Failed to resolve feature-pack artifact " + artifact);
                }
                Path path = p = resolved == null ? null : resolved.getFile().toPath();
                if (p == null) {
                    throw new MojoExecutionException("Failed to resolve feature-pack artifact " + artifact);
                }
                FeaturePackLocation fpl = layoutFactory.addLocal(p, false);
                FeaturePackConfig depConfig = entry.getValue().getTarget();
                configBuilder.addFeaturePackDep(depConfig.isTransitive() ? FeaturePackConfig.transitiveBuilder((FeaturePackLocation)fpl).init(depConfig).build() : FeaturePackConfig.builder((FeaturePackLocation)fpl).init(depConfig).build());
            }
            try (ProvisioningLayout configLayout = layoutFactory.newConfigLayout(configBuilder.build());){
                for (FeaturePackLayout fp : configLayout.getOrderedFeaturePacks()) {
                    this.processFeaturePackDep(artifactVersions, fp);
                }
                this.layersConfs = Utils.collectLayersConf((ProvisioningLayout)configLayout);
            }
        }
        catch (ProvisioningException e) {
            throw new MojoExecutionException("Failed to initialize provisioning layout for the feature-pack dependencies", (Exception)((Object)e));
        }
    }

    private void processFeaturePackDep(MavenProjectArtifactVersions artifactVersions, FeaturePackLayout fp) throws MojoExecutionException, IOException {
        String line2;
        BufferedReader reader;
        Throwable throwable;
        Path fpDir = fp.getDir();
        Path p = fpDir.resolve("features");
        if (Files.exists(p, new LinkOption[0])) {
            if (this.inheritedFeatureSpecs.isEmpty()) {
                this.inheritedFeatureSpecs = new HashSet<String>(500);
            }
            throwable = null;
            try (Stream<Path> children = Files.list(p);){
                List features = children.map(Path::getFileName).map(Path::toString).collect(Collectors.toList());
                for (String feature : features) {
                    this.inheritedFeatureSpecs.add(feature);
                }
            }
            catch (Throwable features) {
                throwable = features;
                throw features;
            }
        }
        if (Files.exists(p = fpDir.resolve("packages"), new LinkOption[0])) {
            Map<String, Artifact> fpArtifacts = Collections.emptyMap();
            Path versionProps = fpDir.resolve("resources/wildfly/artifact-versions.properties");
            if (Files.exists(versionProps, new LinkOption[0])) {
                Map props;
                try {
                    props = Utils.readProperties((Path)versionProps);
                }
                catch (ProvisioningException e) {
                    throw new MojoExecutionException("Failed to read artifact versions file " + versionProps + " from " + fp.getFPID(), (Exception)((Object)e));
                }
                fpArtifacts = new HashMap<String, Artifact>(props.size());
                for (String v : props.values()) {
                    ArtifactCoords coords = ArtifactCoordsUtil.fromJBossModules(v, "jar");
                    ArtifactItem item = new ArtifactItem();
                    item.setGroupId(coords.getGroupId());
                    item.setArtifactId(coords.getArtifactId());
                    item.setVersion(coords.getVersion());
                    item.setClassifier(coords.getClassifier());
                    item.setType(coords.getExtension());
                    try {
                        this.registerArtifact(this.findArtifact(item), fpArtifacts);
                    }
                    catch (MojoExecutionException e) {
                        throw new MojoExecutionException("Failed to resolve artifact " + coords + " as a dependency of " + fp.getFPID() + " (persisted as " + v + ")", (Exception)((Object)e));
                    }
                }
            }
            this.findAndCopyModules(p, fpArtifacts);
        }
        if (!this.standaloneExtensions.isEmpty()) {
            try {
                p = fp.getResource(new String[]{"wildfly", "extensions-standalone"});
            }
            catch (ProvisioningDescriptionException e) {
                throw new MojoExecutionException("Failed to resolve extensions", (Exception)((Object)e));
            }
            if (Files.exists(p, new LinkOption[0])) {
                reader = Files.newBufferedReader(p);
                throwable = null;
                try {
                    line2 = reader.readLine();
                    while (line2 != null) {
                        this.standaloneExtensions.add(line2);
                        line2 = reader.readLine();
                    }
                }
                catch (Throwable line2) {
                    throwable = line2;
                    throw line2;
                }
                finally {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable line2) {
                                throwable.addSuppressed(line2);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
        }
        if (!this.domainExtensions.isEmpty() || !this.hostExtensions.isEmpty()) {
            try {
                p = fp.getResource(new String[]{"wildfly", "extensions-domain"});
            }
            catch (ProvisioningDescriptionException e) {
                throw new MojoExecutionException("Failed to resolve extensions", (Exception)((Object)e));
            }
            if (Files.exists(p, new LinkOption[0])) {
                reader = Files.newBufferedReader(p);
                throwable = null;
                try {
                    line2 = reader.readLine();
                    while (line2 != null) {
                        this.domainExtensions.add(line2);
                        line2 = reader.readLine();
                    }
                }
                catch (Throwable line3) {
                    throwable = line3;
                    throw line3;
                }
                finally {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable line3) {
                                throwable.addSuppressed(line3);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            try {
                p = fp.getResource(new String[]{"wildfly", "extensions-host"});
            }
            catch (ProvisioningDescriptionException e) {
                throw new MojoExecutionException("Failed to resolve extensions", (Exception)((Object)e));
            }
            if (Files.exists(p, new LinkOption[0])) {
                reader = Files.newBufferedReader(p);
                throwable = null;
                try {
                    line2 = reader.readLine();
                    while (line2 != null) {
                        this.hostExtensions.add(line2);
                        line2 = reader.readLine();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
        }
    }

    private void findAndCopyModules(Path fpDirectory, final Map<String, Artifact> fpArtifacts) throws IOException {
        Files.walkFileTree(fpDirectory, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (dir.endsWith(MODULE_PATH_SEGMENT)) {
                    WfFeatureSpecBuildMojo.this.debug("Copying %s to %s", new Object[]{dir, WfFeatureSpecBuildMojo.this.moduleTemplatesDir});
                    WfFeatureSpecBuildMojo.this.copyModules(dir, fpArtifacts);
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.endsWith(TASKS_XML_PATH_END)) {
                    WfFeatureSpecBuildMojo.this.processPackageTasks(file, fpArtifacts);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void copyModules(final Path source, final Map<String, Artifact> fpArtifacts) throws IOException {
        Files.walkFileTree(source, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                block2: {
                    Path targetDir = WfFeatureSpecBuildMojo.this.moduleTemplatesDir.resolve(source.relativize(dir));
                    try {
                        Files.copy(dir, targetDir, new CopyOption[0]);
                    }
                    catch (FileAlreadyExistsException e) {
                        if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                        throw e;
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if ("module.xml".equals(file.getFileName().toString())) {
                    Path relativePath = source.relativize(file);
                    WfFeatureSpecBuildMojo.this.moduleTemplates.put(relativePath, fpArtifacts);
                    Files.copy(file, WfFeatureSpecBuildMojo.this.moduleTemplatesDir.resolve(relativePath), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Path target = WfFeatureSpecBuildMojo.this.wildflyHome.resolve(WfFeatureSpecBuildMojo.MODULES).resolve(source.relativize(file));
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                    Files.copy(file, target, new CopyOption[0]);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void processPackageTasks(Path file, Map<String, Artifact> artifacts) throws IOException {
        WildFlyPackageTasks tasks;
        if (this.tasksParser == null) {
            this.tasksParser = new WildFlyPackageTasksParser();
        }
        try (InputStream input = Files.newInputStream(file, new OpenOption[0]);){
            tasks = this.tasksParser.parse(input);
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to parse " + file, e);
        }
        for (WildFlyPackageTask task : tasks.getTasks()) {
            if (!task.getClass().equals(CopyArtifact.class)) continue;
            this.copyArtifact((CopyArtifact)task, artifacts);
        }
    }

    private Artifact findArtifact(ArtifactItem artifact) throws MojoExecutionException {
        this.resolveVersion(artifact);
        try {
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            buildingRequest.setLocalRepository(this.session.getLocalRepository());
            buildingRequest.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
            this.debug("Resolving artifact %s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            ArtifactResult result = this.artifactResolver.resolveArtifact((ProjectBuildingRequest)buildingRequest, (ArtifactCoordinate)artifact);
            return result == null ? null : result.getArtifact();
        }
        catch (ArtifactResolverException e) {
            throw new MojoExecutionException("Couldn't resolve artifact: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private Artifact findArtifact(Artifact artifact) throws MojoExecutionException {
        try {
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            buildingRequest.setLocalRepository(this.session.getLocalRepository());
            buildingRequest.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
            this.debug("Resolving artifact %s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            ArtifactResult result = this.artifactResolver.resolveArtifact((ProjectBuildingRequest)buildingRequest, artifact);
            if (result != null) {
                return result.getArtifact();
            }
            return artifact;
        }
        catch (ArtifactResolverException e) {
            throw new MojoExecutionException("Couldn't resolve artifact: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private String getArtifactKey(Artifact artifact) {
        StringBuilder buf = new StringBuilder(artifact.getGroupId()).append(':').append(artifact.getArtifactId());
        String classifier = artifact.getClassifier();
        if (classifier != null && !classifier.isEmpty()) {
            buf.append("::").append(classifier);
        }
        return buf.toString();
    }

    private void resolveVersion(ArtifactItem artifact) {
        Artifact managedArtifact;
        if (artifact.getVersion() == null && (managedArtifact = (Artifact)this.project.getManagedVersionMap().get(artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + artifact.getType())) != null) {
            artifact.setVersion(managedArtifact.getVersion());
        }
    }

    private void debug(String format, Object ... args) {
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)String.format(format, args));
        }
    }

    static {
        Path pmWildFly = Paths.get("pm", new String[0]).resolve("wildfly");
        MODULE_PATH_SEGMENT = pmWildFly.resolve("module").resolve(MODULES);
        TASKS_XML_PATH_END = pmWildFly.resolve("tasks.xml");
    }
}

