/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.jboss.galleon.util.IoUtils;
import org.wildfly.galleon.maven.Util;
import org.wildfly.galleon.plugin.ArtifactCoords;
import org.wildfly.galleon.plugin.WfInstallPlugin;
import org.wildfly.galleon.plugin.transformer.JakartaTransformer;
import org.wildfly.galleon.plugin.transformer.TransformedArtifact;

public class JakartaTransformation {
    private final boolean jakartaTransform;
    private final boolean jakartaTransformVerbose;
    private final Path jakartaTransformConfigsDir;
    private final Path jakartaTransformMavenRepo;
    private final Set<String> transformExcluded = new TreeSet<String>();
    private final String jakartaTransformSuffix;
    private final Pattern excludedArtifactPattern;
    private final Set<Artifact> transformed = new HashSet<Artifact>();
    private final JakartaTransformer.LogHandler logHandler;
    private final Log log;

    JakartaTransformation(final Log log, boolean jakartaTransform, boolean jakartaTransformVerbose, File jakartaTransformConfigsDir, File jakartaTransformRepo, String jakartaTransformSuffix, List<String> jakartaTransformExcludedArtifacts) {
        this.log = log;
        this.jakartaTransform = jakartaTransform;
        this.jakartaTransformVerbose = jakartaTransformVerbose;
        this.jakartaTransformConfigsDir = jakartaTransformConfigsDir == null ? null : jakartaTransformConfigsDir.toPath();
        this.jakartaTransformMavenRepo = jakartaTransformRepo.toPath();
        this.jakartaTransformSuffix = jakartaTransformSuffix;
        this.excludedArtifactPattern = jakartaTransformExcludedArtifacts == null || jakartaTransformExcludedArtifacts.isEmpty() ? null : Pattern.compile(JakartaTransformation.toExcludedPattern(jakartaTransformExcludedArtifacts));
        JakartaTransformer.LogHandler logHandler = null;
        if (jakartaTransform) {
            logHandler = new JakartaTransformer.LogHandler(){

                public void print(String format, Object ... args) {
                    log.info((CharSequence)String.format(format, args));
                }
            };
            IoUtils.recursiveDelete((Path)this.jakartaTransformMavenRepo);
        }
        this.logHandler = logHandler;
    }

    private boolean isAlreadyTransformed(Artifact a) {
        return this.transformed.contains(a);
    }

    boolean isJakartaTransformEnabled() {
        return this.jakartaTransform;
    }

    boolean transform(Artifact artifact) throws MojoExecutionException, IOException {
        if (this.isAlreadyTransformed(artifact)) {
            return false;
        }
        String grpid = artifact.getGroupId().replaceAll("\\.", Matcher.quoteReplacement(File.separator));
        Path grpidPath = this.getJakartaTransformMavenRepo().resolve(grpid);
        Path artifactidPath = grpidPath.resolve(artifact.getArtifactId());
        Path versionPath = artifactidPath.resolve(artifact.getVersion());
        Files.createDirectories(versionPath, new FileAttribute[0]);
        boolean isTransformed = this.transform(artifact, versionPath);
        if (isTransformed && this.jakartaTransformSuffix != null) {
            Path transformedVersionPath = artifactidPath.resolve(artifact.getVersion() + this.jakartaTransformSuffix);
            Files.createDirectories(transformedVersionPath, new FileAttribute[0]);
            String fileName = WfInstallPlugin.getTransformedArtifactFileName((String)artifact.getVersion(), (String)artifact.getFile().toPath().getFileName().toString(), (String)this.jakartaTransformSuffix);
            Files.copy(versionPath.resolve(artifact.getFile().toPath().getFileName()), transformedVersionPath.resolve(fileName), StandardCopyOption.REPLACE_EXISTING);
        }
        return isTransformed;
    }

    private boolean transform(Artifact artifact, Path target) throws MojoExecutionException, IOException {
        boolean isTransformed;
        if (this.isAlreadyTransformed(artifact)) {
            return false;
        }
        if (this.isExcludedFromTransformation(artifact)) {
            this.transformExcluded.add(ArtifactCoords.newGav((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getVersion()).toString());
            isTransformed = false;
            Path srcPath = artifact.getFile().toPath();
            Files.copy(srcPath, target.resolve(srcPath.getFileName().toString()), StandardCopyOption.REPLACE_EXISTING);
        } else {
            TransformedArtifact a = JakartaTransformer.transform((Path)this.jakartaTransformConfigsDir, (Path)artifact.getFile().toPath(), (Path)target, (boolean)this.jakartaTransformVerbose, (JakartaTransformer.LogHandler)this.logHandler);
            isTransformed = a.isTransformed();
            if (!a.isTransformed()) {
                this.transformExcluded.add(ArtifactCoords.newGav((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getVersion()).toString());
            }
        }
        this.transformed.add(artifact);
        return isTransformed;
    }

    Path getJakartaTransformMavenRepo() {
        return this.jakartaTransformMavenRepo;
    }

    void writeExcludedArtifactsFile(Path wildflyResourcesDir) throws MojoExecutionException {
        if (!this.transformExcluded.isEmpty()) {
            try {
                Path excludedFilePath = wildflyResourcesDir.resolve("wildfly-jakarta-transform-excludes.txt");
                Util.mkdirs(wildflyResourcesDir);
                StringBuilder builder = new StringBuilder();
                for (String s : this.transformExcluded) {
                    builder.append(s).append(System.lineSeparator());
                }
                Files.write(excludedFilePath, builder.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
            }
            catch (IOException ex) {
                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
            }
        }
    }

    private boolean isExcludedFromTransformation(Artifact artifact) throws MojoExecutionException {
        if (this.excludedArtifactPattern != null) {
            try {
                Matcher matchArtifact = this.excludedArtifactPattern.matcher(artifact.getGroupId() + ":" + artifact.getArtifactId());
                if (matchArtifact.find()) {
                    this.log.info((CharSequence)("EE9: excluded " + artifact.getGroupId() + ":" + artifact.getArtifactId()));
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                throw new MojoExecutionException("Invalid exclusion pattern: " + e.getMessage(), (Exception)e);
            }
        }
        return false;
    }

    private static String toExcludedPattern(List<String> patterns) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < patterns.size(); ++i) {
            builder.append(patterns.get(i));
            if (i >= patterns.size() - 1) continue;
            builder.append("|");
        }
        return builder.toString();
    }
}

