/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

public class ModuleIdentifier {
    private final String name;
    private final String slot;

    public ModuleIdentifier(String name, String slot) {
        this.name = name;
        this.slot = slot;
    }

    public ModuleIdentifier(String name) {
        this.name = name;
        this.slot = "main";
    }

    public String getName() {
        return this.name;
    }

    public String getSlot() {
        return this.slot;
    }

    public static ModuleIdentifier fromString(String moduleId) {
        String[] parts = moduleId.split(":");
        if (parts.length == 1) {
            return new ModuleIdentifier(parts[0]);
        }
        if (parts.length == 2) {
            return new ModuleIdentifier(parts[0], parts[1]);
        }
        throw new IllegalArgumentException("Not a valid module identifier " + moduleId);
    }

    public String toString() {
        return "ModuleIdentifier{name='" + this.name + "', slot='" + this.slot + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleIdentifier that = (ModuleIdentifier)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.slot != null ? !this.slot.equals(that.slot) : that.slot != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.slot != null ? this.slot.hashCode() : 0);
        return result;
    }
}

