/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.spec.FeatureAnnotation;
import org.jboss.galleon.spec.FeatureParameterSpec;
import org.jboss.galleon.spec.FeatureReferenceSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.xml.FeatureSpecXmlWriter;

public class FeatureSpecExporter {
    public static void export(ModelNode node, Path directory, Map<String, String> inheritedFeatures) throws IOException, ProvisioningDescriptionException, XMLStreamException {
        List<FeatureSpec> specs = FeatureSpecExporter.readFeatureSpecs(node, inheritedFeatures);
        FeatureSpecExporter.saveFeatureSpecs(directory, specs);
    }

    public static List<FeatureSpec> readFeatureSpecs(ModelNode node, Map<String, String> inheritedFeatures) throws ProvisioningDescriptionException {
        ArrayList<FeatureSpec> specs = new ArrayList<FeatureSpec>();
        ModelNode rootNode = node.hasDefined("result") ? node.require("result").require("feature") : node.require("feature");
        List<Property> rootFeatures = rootNode.hasDefined("name") ? Collections.singletonList(new Property(rootNode.require("name").asString(), rootNode)) : rootNode.get("children").asPropertyList();
        Iterator iterator = rootFeatures.iterator();
        while (iterator.hasNext()) {
            Property childFeature;
            FeatureSpecExporter.toFeatureSpec(childFeature, specs, inheritedFeatures, (childFeature = (Property)iterator.next()).getName().charAt(0) == 'd' ? 1 : 0);
        }
        return specs;
    }

    public static void saveFeatureSpecs(Path directory, List<FeatureSpec> specs) throws ProvisioningDescriptionException, IOException, XMLStreamException {
        if (Files.notExists(directory, new LinkOption[0])) {
            Files.createDirectory(directory, new FileAttribute[0]);
        }
        for (FeatureSpec spec : specs) {
            Path specDir = directory.resolve(spec.getName());
            if (Files.notExists(specDir, new LinkOption[0])) {
                Files.createDirectory(specDir, new FileAttribute[0]);
            }
            FeatureSpecXmlWriter.getInstance().write((Object)spec, specDir.resolve("spec.xml"));
        }
    }

    private static void toFeatureSpec(Property featureProperty, List<FeatureSpec> specs, Map<String, String> inheritedFeatures, int level) throws ProvisioningDescriptionException {
        ModelNode feature;
        if (!inheritedFeatures.containsKey(featureProperty.getName())) {
            specs.add(FeatureSpecExporter.buildSpec(featureProperty, inheritedFeatures, level));
        }
        if ((feature = featureProperty.getValue()).hasDefined("children")) {
            for (Property childFeature : feature.get("children").asPropertyList()) {
                FeatureSpecExporter.toFeatureSpec(childFeature, specs, inheritedFeatures, level + 1);
            }
        }
    }

    private static FeatureSpec buildSpec(Property featureProperty, Map<String, String> inheritedFeatures, int level) throws ProvisioningDescriptionException {
        ModelNode feature;
        FeatureAnnotation annotation;
        String specName = featureProperty.getName();
        FeatureSpec.Builder builder = FeatureSpec.builder((String)specName);
        if (level == 1 && (specName.contains("subsystem.") || specName.contains("core-service."))) {
            builder.addAnnotation(FeatureAnnotation.parentChildrenBranch());
        }
        if ((annotation = FeatureSpecExporter.toFeatureAnnotation(feature = featureProperty.getValue())) != null) {
            builder.addAnnotation(annotation);
        }
        if (feature.hasDefined("requires")) {
            for (ModelNode capability : feature.require("requires").asList()) {
                boolean optional = capability.hasDefined("optional") && capability.get("optional").asBoolean();
                builder.requiresCapability(capability.get("name").asString(), optional);
            }
        }
        if (feature.hasDefined("provides")) {
            for (ModelNode capability : feature.require("provides").asList()) {
                builder.providesCapability(capability.asString());
            }
        }
        if (feature.hasDefined("params")) {
            for (ModelNode param : feature.require("params").asList()) {
                FeatureParameterSpec.Builder featureParamSpecBuilder = FeatureParameterSpec.builder((String)param.get("name").asString());
                if (param.hasDefined("feature-id") && param.get("feature-id").asBoolean()) {
                    featureParamSpecBuilder.setFeatureId();
                }
                if (param.hasDefined("nillable") && param.get("nillable").asBoolean()) {
                    featureParamSpecBuilder.setNillable();
                }
                featureParamSpecBuilder.setDefaultValue(param.hasDefined("default") ? FeatureSpecExporter.convertToCli(param.get("default").asString()) : null);
                if (param.hasDefined("type")) {
                    featureParamSpecBuilder.setType(param.get("type").asString());
                }
                builder.addParam(featureParamSpecBuilder.build());
            }
        }
        if (feature.hasDefined("refs")) {
            for (ModelNode ref : feature.get("refs").asList()) {
                String mergedName;
                boolean isInclude = ref.hasDefined("include") && ref.get("include").asBoolean();
                String featureRefName = ref.get("feature").asString();
                FeatureReferenceSpec.Builder refBuilder = FeatureReferenceSpec.builder((String)featureRefName).setInclude(isInclude);
                if (inheritedFeatures.containsKey(featureRefName)) {
                    refBuilder.setOrigin(inheritedFeatures.get(featureRefName));
                }
                if (FeatureSpecExporter.isProfileFeature(featureRefName) && inheritedFeatures.containsKey(mergedName = FeatureSpecExporter.extractFeatureName(featureRefName))) {
                    refBuilder.setOrigin(inheritedFeatures.get(mergedName));
                }
                if (ref.hasDefined("mappings")) {
                    for (Property mapping : ref.require("mappings").asPropertyList()) {
                        refBuilder.mapParam(mapping.getName(), mapping.getValue().asString());
                    }
                }
                if ("profile".equals(featureRefName)) {
                    refBuilder.setNillable(true);
                }
                builder.addFeatureRef(refBuilder.build());
            }
        }
        if (feature.hasDefined("packages")) {
            for (ModelNode packageDep : feature.get("packages").asList()) {
                if (!packageDep.hasDefined("package")) continue;
                builder.addPackageDep(packageDep.require("package").asString());
            }
        }
        return builder.build();
    }

    private static boolean isProfileFeature(String featureName) {
        return featureName.startsWith("profile.");
    }

    private static String extractFeatureName(String featureName) {
        if (FeatureSpecExporter.isProfileFeature(featureName)) {
            return featureName.substring("profile.".length());
        }
        return featureName;
    }

    private static String convertToCli(String value) {
        if (!(value == null || value.isEmpty() || value.indexOf(44) < 0 || value.startsWith("\"") && value.endsWith("\"") || value.startsWith("[") && value.endsWith("]"))) {
            return "\"" + value + "\"";
        }
        return value;
    }

    private static FeatureAnnotation toFeatureAnnotation(ModelNode feature) {
        if (feature.hasDefined("annotation")) {
            ModelNode annotationNode = feature.require("annotation");
            FeatureAnnotation annotation = new FeatureAnnotation("jboss-op");
            annotation.setElement("name", annotationNode.require("name").asString());
            for (Property property : annotationNode.asPropertyList()) {
                annotation.setElement(property.getName(), property.getValue().asString());
            }
            return annotation;
        }
        return null;
    }
}

