/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;
import org.jboss.galleon.spec.CapabilitySpec;
import org.jboss.galleon.spec.FeatureAnnotation;
import org.jboss.galleon.spec.FeatureDependencySpec;
import org.jboss.galleon.spec.FeatureReferenceSpec;
import org.jboss.galleon.spec.FeatureSpec;

public class FeatureSpecFilter {
    public static boolean areIdentical(FeatureSpec standalone, FeatureSpec domain, Log log) {
        String standaloneName;
        String domainName = domain.getName();
        if (domainName.equals("profile." + (standaloneName = standalone.getName()))) {
            return FeatureSpecFilter.sameCapabilities(standalone.getProvidedCapabilities(), domain.getProvidedCapabilities(), log) && FeatureSpecFilter.sameCapabilities(standalone.getRequiredCapabilities(), domain.getRequiredCapabilities(), log) && FeatureSpecFilter.samePackages(standalone, domain, log) && FeatureSpecFilter.sameAnnotations(standalone, domain) && FeatureSpecFilter.sameProfileFeatureReferences(standalone, domain);
        }
        if (domainName.equals("host." + standaloneName)) {
            return FeatureSpecFilter.sameCapabilities(standalone.getProvidedCapabilities(), domain.getProvidedCapabilities(), log) && FeatureSpecFilter.sameCapabilities(standalone.getRequiredCapabilities(), domain.getRequiredCapabilities(), log) && FeatureSpecFilter.samePackages(standalone, domain, log) && FeatureSpecFilter.sameAnnotations(standalone, domain) && FeatureSpecFilter.sameHostFeatureReferences(standalone, domain);
        }
        if (domainName.equals("domain." + standaloneName)) {
            return FeatureSpecFilter.sameCapabilities(standalone.getProvidedCapabilities(), domain.getProvidedCapabilities(), log) && FeatureSpecFilter.sameCapabilities(standalone.getRequiredCapabilities(), domain.getRequiredCapabilities(), log) && FeatureSpecFilter.samePackages(standalone, domain, log) && FeatureSpecFilter.sameAnnotations(standalone, domain);
        }
        return false;
    }

    private static boolean sameCapabilities(Set<CapabilitySpec> standaloneCaps, Set<CapabilitySpec> domainCaps, Log log) {
        Set domain = domainCaps.stream().map(CapabilitySpec::toString).map(s -> s.startsWith("$profile.") ? s.substring(9) : s).collect(Collectors.toSet());
        Set<String> capabilities = standaloneCaps.stream().map(CapabilitySpec::toString).filter(s -> !domain.contains(s)).collect(Collectors.toSet());
        capabilities.forEach(s -> log.warn((CharSequence)("We haven't found the capability " + s + " in domain spec")));
        return capabilities.isEmpty();
    }

    private static boolean samePackages(FeatureSpec standalone, FeatureSpec domain, Log log) {
        if (standalone.hasFeatureDeps() && domain.hasFeatureDeps()) {
            Set<FeatureDependencySpec> packages = standalone.getFeatureDeps().stream().filter(s -> !domain.getFeatureDeps().contains(s)).collect(Collectors.toSet());
            packages.forEach(s -> log.warn((CharSequence)("We haven't found the package " + s + " in domain spec")));
            return packages.isEmpty();
        }
        return standalone.hasFeatureDeps() == domain.hasFeatureDeps();
    }

    private static boolean sameAnnotations(FeatureSpec standalone, FeatureSpec domain) {
        if (standalone.hasAnnotations() && domain.hasAnnotations()) {
            Map domainAnnotations = domain.getAnnotations().stream().collect(Collectors.toMap(FeatureAnnotation::getName, Function.identity()));
            Set annotations = standalone.getAnnotations().stream().filter(s -> !domainAnnotations.containsKey(s.getName()) && !FeatureSpecFilter.sameAnnotation(s, (FeatureAnnotation)domainAnnotations.get(s.getName()))).collect(Collectors.toSet());
            return annotations.isEmpty();
        }
        return false;
    }

    private static boolean sameAnnotation(FeatureAnnotation standaloneAnnotation, FeatureAnnotation domainAnnotation) {
        if (standaloneAnnotation.getElements().size() == domainAnnotation.getElements().size()) {
            for (String name : standaloneAnnotation.getElements().keySet()) {
                List standaloneValues = standaloneAnnotation.getElementAsList(name);
                List domainValues = domainAnnotation.getElementAsList(name);
                if (standaloneValues.size() != domainValues.size()) continue;
                List values = standaloneValues.stream().filter(s -> !domainValues.contains(s)).collect(Collectors.toList());
                return values.isEmpty();
            }
        }
        return false;
    }

    private static boolean sameProfileFeatureReferences(FeatureSpec standalone, FeatureSpec domain) {
        Set domainRefs = domain.getFeatureRefs().stream().map(ref -> ref.getName().startsWith("profile.") ? ref.getName().substring("profile.".length()) : ref.getName()).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        Set refs = standalone.getFeatureRefs().stream().map(FeatureReferenceSpec::getName).filter(s -> !domainRefs.contains(s)).collect(Collectors.toSet());
        return refs.isEmpty();
    }

    private static boolean sameHostFeatureReferences(FeatureSpec standalone, FeatureSpec domain) {
        Set domainRefs = domain.getFeatureRefs().stream().map(ref -> ref.getName().startsWith("host.") ? ref.getName().substring("host.".length()) : ref.getName()).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        Set refs = standalone.getFeatureRefs().stream().map(FeatureReferenceSpec::getName).filter(s -> !domainRefs.contains(s)).collect(Collectors.toSet());
        return refs.isEmpty();
    }
}

